/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.aliyun.hitsdb.client.value.JSONValue;
import com.aliyun.hitsdb.client.value.request.LastLimit;
import com.aliyun.hitsdb.client.value.request.LastPointSubQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LastPointQuery
extends JSONValue {
    private Boolean msResolution;
    private Integer backScan;
    private Long timestamp;
    private LastLimit limit;
    private Boolean tupleFormat;
    private List<LastPointSubQuery> queries;
    private Map<String, Map<String, Integer>> hint;

    public static Builder builder() {
        return new Builder();
    }

    public Boolean isMsResolution() {
        return this.msResolution;
    }

    public void setMsResolution(boolean msResolution) {
        this.msResolution = msResolution;
    }

    public Integer getBackScan() {
        return this.backScan;
    }

    public void setBackScan(int backScan) {
        this.backScan = backScan;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Boolean getTupleFormat() {
        return this.tupleFormat;
    }

    public void setTupleFormat(Boolean tupleFormat) {
        this.tupleFormat = tupleFormat;
    }

    public List<LastPointSubQuery> getQueries() {
        return this.queries;
    }

    public void setQueries(List<LastPointSubQuery> queries) {
        this.queries = queries;
    }

    public LastLimit getLimit() {
        return this.limit;
    }

    public void setLimit(LastLimit limit) {
        this.limit = limit;
    }

    public Map<String, Map<String, Integer>> getHint() {
        return this.hint;
    }

    public void setHint(Map<String, Map<String, Integer>> hint) {
        this.hint = hint;
    }

    public static class Builder {
        private Integer backScan;
        private Boolean msResolution;
        private Long timestamp;
        private List<LastPointSubQuery> queries;
        private Boolean tupleFormat;
        private LastLimit limit;
        private Map<String, Map<String, Integer>> hint;

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder backScan(int backScan) {
            this.backScan = backScan;
            return this;
        }

        public Builder msResolution(boolean msResolution) {
            this.msResolution = msResolution;
            return this;
        }

        public Builder hint(Map<String, Map<String, Integer>> hint) {
            this.hint = hint;
            return this;
        }

        public Builder sub(LastPointSubQuery subQuery) {
            if (this.queries == null) {
                this.queries = new ArrayList<LastPointSubQuery>();
            }
            this.queries.add(subQuery);
            return this;
        }

        public Builder tupleFormat(boolean tupleFormat) {
            this.tupleFormat = tupleFormat;
            return this;
        }

        public Builder limit(LastLimit limit) {
            this.limit = limit;
            return this;
        }

        public LastPointQuery build() {
            if (this.queries == null || this.queries.isEmpty()) {
                throw new IllegalArgumentException("the LastPointSubQuery must be set");
            }
            LastPointQuery query = new LastPointQuery();
            query.backScan = this.backScan;
            query.msResolution = this.msResolution;
            query.timestamp = this.timestamp;
            query.setQueries(this.queries);
            query.tupleFormat = this.tupleFormat;
            query.limit = this.limit;
            query.hint = this.hint;
            return query;
        }
    }
}

