/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.hitsdb.client.value.JSONValue;
import com.aliyun.hitsdb.client.value.request.MultiFieldSubQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class MultiFieldQuery
extends JSONValue {
    private Long start;
    private Long end;
    private List<MultiFieldSubQuery> queries;
    private Boolean msResolution;
    @JSONField(serialize=false)
    private boolean showType;
    @JSONField(serialize=false)
    private List<Class<?>> types;
    private Map<String, Map<String, Integer>> hint;

    public static Builder start(long startTime) {
        return new Builder(startTime);
    }

    public static Builder start(Date startDate) {
        long startTime = startDate.getTime();
        return new Builder(startTime);
    }

    public static Builder timeRange(Date startDate, Date endDate) {
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        return new Builder(startTime, endTime);
    }

    public static Builder timeRange(long startTime, long endTime) {
        return new Builder(startTime, endTime);
    }

    public Long getStart() {
        return this.start;
    }

    public Long getEnd() {
        return this.end;
    }

    public Boolean getMsResolution() {
        return this.msResolution;
    }

    public List<MultiFieldSubQuery> getQueries() {
        return this.queries;
    }

    public boolean isShowType() {
        return this.showType;
    }

    public void setShowType(boolean showType) {
        this.showType = showType;
    }

    public List<Class<?>> getTypes() {
        return this.types;
    }

    public void setTypes(List<Class<?>> types) {
        this.types = types;
    }

    public Map<String, Map<String, Integer>> getHint() {
        return this.hint;
    }

    public void setHint(Map<String, Map<String, Integer>> hint) {
        this.hint = hint;
    }

    public static class Builder {
        private Long startTime;
        private Long endTime;
        private Boolean msResolution;
        private List<MultiFieldSubQuery> subQueryList = new ArrayList<MultiFieldSubQuery>();
        private boolean showType;
        private List<Class<?>> types;
        private Map<String, Map<String, Integer>> hint;
        private static final long MIN_START_TIME = 4284768L;
        private static final long MAX_END_TIME = 9999999999999L;

        public Builder(long startTime) {
            this.startTime = startTime;
        }

        public Builder(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public Builder end(Date endDate) {
            this.endTime = endDate.getTime();
            return this;
        }

        public Builder end(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder msResolution(Boolean msResolution) {
            this.msResolution = msResolution != false ? Boolean.valueOf(true) : null;
            return this;
        }

        public Builder msResolution() {
            this.msResolution = true;
            return this;
        }

        public Builder showType() {
            this.showType = true;
            return this;
        }

        public Builder withTypes(List<Class<?>> types) {
            this.showType = true;
            this.types = types;
            return this;
        }

        public Builder hint(Map<String, Map<String, Integer>> hint) {
            this.hint = hint;
            return this;
        }

        public Builder sub(MultiFieldSubQuery ... subQuerys) {
            for (MultiFieldSubQuery subQuery : subQuerys) {
                this.subQueryList.add(subQuery);
            }
            return this;
        }

        public Builder sub(Collection<MultiFieldSubQuery> subQuerys) {
            for (MultiFieldSubQuery subQuery : subQuerys) {
                this.subQueryList.add(subQuery);
            }
            return this;
        }

        public MultiFieldQuery build() {
            MultiFieldQuery query = new MultiFieldQuery();
            query.queries = this.subQueryList;
            if (this.startTime == null) {
                throw new IllegalArgumentException("the start time must be set");
            }
            if (this.startTime < 4284768L) {
                throw new IllegalArgumentException("the start time must be greater than 4284768");
            }
            query.start = this.startTime;
            if (this.endTime != null) {
                if (this.endTime > 9999999999999L) {
                    throw new IllegalArgumentException("the end time must be less than9999999999999");
                }
                if (this.endTime < this.startTime) {
                    throw new IllegalArgumentException("the end time (" + this.endTime + ") must be greater than start time (" + this.startTime + ")");
                }
            }
            query.end = this.endTime;
            if (this.subQueryList == null || this.subQueryList.isEmpty()) {
                throw new IllegalArgumentException("Missing sub queries.");
            }
            query.queries = this.subQueryList;
            query.msResolution = this.msResolution;
            query.showType = this.showType;
            query.types = this.types;
            query.hint = this.hint;
            return query;
        }
    }
}

