/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.hitsdb.client.value.response;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.hitsdb.client.value.request.ByteArrayValue;
import com.aliyun.hitsdb.client.value.request.ComplexValue;
import com.aliyun.hitsdb.client.value.request.GeoPointValue;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javafx.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFieldQueryValuesSerializer
implements ObjectSerializer,
ObjectDeserializer {
    private static final Logger log = LoggerFactory.getLogger(MultiFieldQueryValuesSerializer.class);

    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        List objectsList = parser.parseArray(List.class);
        for (int i = 0; i < objectsList.size(); ++i) {
            List objects = (List)objectsList.get(i);
            boolean changed = false;
            for (int j = 0; j < objects.size(); ++j) {
                JSONObject jsonObject;
                if (!(objects.get(j) instanceof JSONObject) || !ComplexValue.isJsonObjectTypeMatch(jsonObject = (JSONObject)objects.get(j))) continue;
                String valueType = jsonObject.getString("type");
                if ("bytes".equals(valueType)) {
                    ByteArrayValue bv = (ByteArrayValue)JSON.parseObject((String)jsonObject.toJSONString(), ByteArrayValue.class);
                    objects.set(j, bv.decode());
                    changed = true;
                    continue;
                }
                if ("geopoint".equals(valueType)) {
                    GeoPointValue gp = (GeoPointValue)JSON.parseObject((String)jsonObject.toJSONString(), GeoPointValue.class);
                    objects.set(j, gp);
                    changed = true;
                    continue;
                }
                log.error("Illegal value type {}", (Object)valueType);
                throw new IllegalArgumentException("Illegal value type " + valueType);
            }
            if (!changed) continue;
            objectsList.set(i, objects);
        }
        return (T)objectsList;
    }

    public int getFastMatchToken() {
        return 0;
    }

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        int i;
        ArrayList<Pair> indexes = new ArrayList<Pair>();
        ArrayList values = new ArrayList();
        List lists = (List)object;
        for (i = 0; i < lists.size(); ++i) {
            List list = (List)lists.get(i);
            for (int j = 0; j < list.size(); ++j) {
                Object o = list.get(j);
                if (!(o instanceof byte[])) continue;
                ByteArrayValue bv = new ByteArrayValue((byte[])o);
                list.set(j, bv);
                indexes.add(new Pair((Object)i, (Object)j));
                values.add(o);
            }
        }
        serializer.write((Object)lists);
        for (i = 0; i < indexes.size(); ++i) {
            Pair index = (Pair)indexes.get(i);
            ((List)lists.get((Integer)index.getKey())).set((Integer)index.getValue(), values.get(i));
        }
    }
}

