package com.aliyun.mns.model;

public class MessageAttributes implements BaseAttributes {
    private MailAttributes mailAttributes;
    private DayuAttributes dayuAttributes;
    private SmsAttributes smsAttributes;
    private WebSocketAttributes webSocketAttributes;
    private BatchSmsAttributes batchSmsAttributes;
    private PushAttributes pushAttributes;

    @Override
    public AttributesValidationResult validate() {
        AttributesValidationResult result;
        if (mailAttributes != null) {
            result = mailAttributes.validate();
            if (!result.isSuccess()) {
                return result;
            }
        }

        if (dayuAttributes != null) {
            result = dayuAttributes.validate();
            if (!result.isSuccess()) {
                return result;
            }
        }

        if (smsAttributes != null) {
            result = smsAttributes.validate();
            if (!result.isSuccess()) {
                return result;
            }
        }

        if (pushAttributes != null) {
            result = pushAttributes.validate();
            if (!result.isSuccess()) {
                return result;
            }
        }

        result = new AttributesValidationResult();
        result.setSuccess(true);
        return result;
    }

    public MailAttributes getMailAttributes() {
        return mailAttributes;
    }

    public void setMailAttributes(MailAttributes mailAttributes) {
        this.mailAttributes = mailAttributes;
    }

    public DayuAttributes getDayuAttributes() {
        return dayuAttributes;
    }

    public void setDayuAttributes(DayuAttributes dayuAttributes) {
        this.dayuAttributes = dayuAttributes;
    }

    public SmsAttributes getSmsAttributes() {
        return smsAttributes;
    }

    public void setSmsAttributes(SmsAttributes smsAttributes) {
        this.smsAttributes = smsAttributes;
    }

    public WebSocketAttributes getWebSocketAttributes() {
        return webSocketAttributes;
    }

    public void setWebSocketAttributes(WebSocketAttributes webSocketAttributes) {
        this.webSocketAttributes = webSocketAttributes;
    }

    public BatchSmsAttributes getBatchSmsAttributes() {
        return batchSmsAttributes;
    }

    public void setBatchSmsAttributes(BatchSmsAttributes batchSmsAttributes) {
        this.batchSmsAttributes = batchSmsAttributes;
    }

    public PushAttributes getPushAttributes() {
        return pushAttributes;
    }

    public void setPushAttributes(PushAttributes pushAttributes) {
        this.pushAttributes = pushAttributes;
    }
}
