/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSInputStream;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSOutputStream;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSUtils;
import org.apache.hadoop.fs.aliyun.oss.RetryOnceSecurityTokenExpired;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOSSFileSystem
extends FileSystem {
    private static final Logger LOG;
    private URI uri;
    private String bucket;
    private Path workingDir;
    private AliyunOSSFileSystemStore store;
    private int maxKeys;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;

    static {
        AliyunOSSFileSystem.ajc$preClinit();
        LOG = LoggerFactory.getLogger(AliyunOSSFileSystem.class);
    }

    public FSDataOutputStream append(Path path, int bufferSize, Progressable progress) throws IOException {
        Path path2 = path;
        int n = bufferSize;
        Progressable progressable = progress;
        Object[] objectArray = new Object[]{path2, Conversions.intObject((int)n), progressable};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        return (FSDataOutputStream)AliyunOSSFileSystem.append_aroundBody1$advice(this, path2, n, progressable, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void close() throws IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        AliyunOSSFileSystem.close_aroundBody3$advice(this, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path path2 = path;
        FsPermission fsPermission = permission;
        boolean bl = overwrite;
        int n = bufferSize;
        short s = replication;
        long l = blockSize;
        Progressable progressable = progress;
        Object[] objectArray = new Object[]{path2, fsPermission, Conversions.booleanObject((boolean)bl), Conversions.intObject((int)n), Conversions.shortObject((short)s), Conversions.longObject((long)l), progressable};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        return (FSDataOutputStream)AliyunOSSFileSystem.create_aroundBody5$advice(this, path2, fsPermission, bl, n, s, l, progressable, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        Path path2 = path;
        boolean bl = recursive;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)path2, (Object)Conversions.booleanObject((boolean)bl));
        return Conversions.booleanValue((Object)AliyunOSSFileSystem.delete_aroundBody7$advice(this, path2, bl, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    private boolean innerDelete(FileStatus status, boolean recursive) throws IOException {
        Path f = status.getPath();
        String p = f.toUri().getPath();
        if (p.equals("/")) {
            FileStatus[] statuses = this.listStatus(status.getPath());
            boolean isEmptyDir = statuses.length <= 0;
            return this.rejectRootDirectoryDelete(isEmptyDir, recursive);
        }
        String key = this.pathToKey(f);
        if (status.isDirectory()) {
            if (!recursive) {
                FileStatus[] statuses = this.listStatus(status.getPath());
                if (statuses.length > 0) {
                    throw new IOException("Cannot remove directory " + f + ": It is not empty!");
                }
                key = AliyunOSSUtils.maybeAddTrailingSlash(key);
                this.store.deleteObject(key);
            } else {
                this.store.deleteDirs(key);
            }
        } else {
            this.store.deleteObject(key);
        }
        this.createFakeDirectoryIfNecessary(f);
        return true;
    }

    private boolean rejectRootDirectoryDelete(boolean isEmptyDir, boolean recursive) throws IOException {
        LOG.info("oss delete the {} root directory of {}", (Object)this.bucket, (Object)recursive);
        if (isEmptyDir) {
            return true;
        }
        if (recursive) {
            return false;
        }
        throw new PathIOException(this.bucket, "Cannot delete root path");
    }

    private void createFakeDirectoryIfNecessary(Path f) throws IOException {
        String key = this.pathToKey(f);
        if (StringUtils.isNotEmpty((String)key) && !this.exists(f)) {
            LOG.debug("Creating new fake directory at {}", (Object)f);
            this.mkdir(this.pathToKey(f.getParent()));
        }
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        Path path2 = path;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)path2);
        return (FileStatus)AliyunOSSFileSystem.getFileStatus_aroundBody9$advice(this, path2, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public String getScheme() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        return (String)AliyunOSSFileSystem.getScheme_aroundBody11$advice(this, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public URI getUri() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this));
        return (URI)AliyunOSSFileSystem.getUri_aroundBody13$advice(this, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public Path getWorkingDirectory() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this));
        return (Path)AliyunOSSFileSystem.getWorkingDirectory_aroundBody15$advice(this, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @Deprecated
    public long getDefaultBlockSize() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)((Object)this), (Object)((Object)this));
        return Conversions.longValue((Object)AliyunOSSFileSystem.getDefaultBlockSize_aroundBody17$advice(this, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    public String getCanonicalServiceName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)((Object)this), (Object)((Object)this));
        return (String)AliyunOSSFileSystem.getCanonicalServiceName_aroundBody19$advice(this, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        URI uRI = name;
        Configuration configuration = conf;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)((Object)this), (Object)((Object)this), (Object)uRI, (Object)configuration);
        AliyunOSSFileSystem.initialize_aroundBody21$advice(this, uRI, configuration, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private boolean objectRepresentsDirectory(String name, long size) {
        return StringUtils.isNotEmpty((String)name) && name.endsWith("/") && size == 0L;
    }

    private String pathToKey(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.workingDir, path);
        }
        return path.toUri().getPath().substring(1);
    }

    private Path keyToPath(String key) {
        return new Path("/" + key);
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        Path path2 = path;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)((Object)this), (Object)((Object)this), (Object)path2);
        return (FileStatus[])AliyunOSSFileSystem.listStatus_aroundBody23$advice(this, path2, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private boolean mkdir(String key) throws IOException {
        String dirName = key;
        if (StringUtils.isNotEmpty((String)key)) {
            if (!key.endsWith("/")) {
                dirName = String.valueOf(dirName) + "/";
            }
            this.store.storeEmptyFile(dirName);
        }
        return true;
    }

    public boolean mkdirs(Path path, FsPermission permission) throws IOException {
        Path path2 = path;
        FsPermission fsPermission = permission;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)((Object)this), (Object)((Object)this), (Object)path2, (Object)fsPermission);
        return Conversions.booleanValue((Object)AliyunOSSFileSystem.mkdirs_aroundBody25$advice(this, path2, fsPermission, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    private void validatePath(Path path) throws IOException {
        Path fPart = path.getParent();
        while (true) {
            try {
                FileStatus fileStatus = this.getFileStatus(fPart);
                if (!fileStatus.isDirectory()) {
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s', it is a file.", fPart));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if ((fPart = fPart.getParent()) != null) continue;
            }
            break;
        }
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        Path path2 = path;
        int n = bufferSize;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)((Object)this), (Object)((Object)this), (Object)path2, (Object)Conversions.intObject((int)n));
        return (FSDataInputStream)AliyunOSSFileSystem.open_aroundBody27$advice(this, path2, n, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public boolean rename(Path srcPath, Path dstPath) throws IOException {
        Path path = srcPath;
        Path path2 = dstPath;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)((Object)this), (Object)((Object)this), (Object)path, (Object)path2);
        return Conversions.booleanValue((Object)AliyunOSSFileSystem.rename_aroundBody29$advice(this, path, path2, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    private boolean copyFile(Path srcPath, Path dstPath) {
        String srcKey = this.pathToKey(srcPath);
        String dstKey = this.pathToKey(dstPath);
        return this.store.copyFile(srcKey, dstKey);
    }

    private boolean copyDirectory(Path srcPath, Path dstPath) throws IOException {
        String srcKey = AliyunOSSUtils.maybeAddTrailingSlash(this.pathToKey(srcPath));
        String dstKey = AliyunOSSUtils.maybeAddTrailingSlash(this.pathToKey(dstPath));
        if (dstKey.startsWith(srcKey)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot rename a directory to a subdirectory of self");
            }
            return false;
        }
        this.store.storeEmptyFile(dstKey);
        ObjectListing objects = this.store.listObjects(srcKey, this.maxKeys, null, true);
        this.statistics.incrementReadOps(1);
        while (true) {
            for (OSSObjectSummary objectSummary : objects.getObjectSummaries()) {
                String newKey = dstKey.concat(objectSummary.getKey().substring(srcKey.length()));
                this.store.copyFile(objectSummary.getKey(), newKey);
            }
            if (!objects.isTruncated()) break;
            String nextMarker = objects.getNextMarker();
            objects = this.store.listObjects(srcKey, this.maxKeys, nextMarker, true);
            this.statistics.incrementReadOps(1);
        }
        return true;
    }

    public void setWorkingDirectory(Path dir) {
        Path path = dir;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)((Object)this), (Object)((Object)this), (Object)path);
        AliyunOSSFileSystem.setWorkingDirectory_aroundBody31$advice(this, path, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public AliyunOSSFileSystemStore getStore() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)((Object)this), (Object)((Object)this));
        return (AliyunOSSFileSystemStore)AliyunOSSFileSystem.getStore_aroundBody33$advice(this, joinPoint, RetryOnceSecurityTokenExpired.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private static final /* synthetic */ FSDataOutputStream append_aroundBody0(AliyunOSSFileSystem ajc$this, Path path, int bufferSize, Progressable progress, JoinPoint joinPoint) {
        throw new IOException("Append is not supported!");
    }

    private static final /* synthetic */ Object append_aroundBody1$advice(AliyunOSSFileSystem ajc$this, Path path, int bufferSize, Progressable progress, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return AliyunOSSFileSystem.append_aroundBody0(ajc$this, path, bufferSize, progress, (JoinPoint)proceedingJoinPoint);
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ void close_aroundBody2(AliyunOSSFileSystem ajc$this, JoinPoint joinPoint) {
        try {
            ajc$this.store.close();
        }
        finally {
            super.close();
        }
    }

    private static final /* synthetic */ Object close_aroundBody3$advice(AliyunOSSFileSystem ajc$this, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                AliyunOSSFileSystem.close_aroundBody2(ajc$this, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ FSDataOutputStream create_aroundBody4(AliyunOSSFileSystem ajc$this, Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, JoinPoint joinPoint) {
        String key = ajc$this.pathToKey(path);
        FileStatus status = null;
        try {
            status = ajc$this.getFileStatus(path);
            if (status.isDirectory()) {
                throw new FileAlreadyExistsException(path + " is a directory");
            }
            if (!overwrite) {
                throw new FileAlreadyExistsException(path + " already exists");
            }
            LOG.debug("Overwriting file {}", (Object)path);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        return new FSDataOutputStream((OutputStream)new AliyunOSSOutputStream(ajc$this.getConf(), ajc$this.store, key, progress, ajc$this.statistics), null);
    }

    private static final /* synthetic */ Object create_aroundBody5$advice(AliyunOSSFileSystem ajc$this, Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return AliyunOSSFileSystem.create_aroundBody4(ajc$this, path, permission, overwrite, bufferSize, replication, blockSize, progress, (JoinPoint)proceedingJoinPoint);
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ boolean delete_aroundBody6(AliyunOSSFileSystem ajc$this, Path path, boolean recursive, JoinPoint joinPoint) {
        try {
            return ajc$this.innerDelete(ajc$this.getFileStatus(path), recursive);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOG.debug("Couldn't delete {} - does not exist", (Object)path);
            return false;
        }
    }

    private static final /* synthetic */ Object delete_aroundBody7$advice(AliyunOSSFileSystem ajc$this, Path path, boolean recursive, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return Conversions.booleanObject((boolean)AliyunOSSFileSystem.delete_aroundBody6(ajc$this, path, recursive, (JoinPoint)proceedingJoinPoint));
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ FileStatus getFileStatus_aroundBody8(AliyunOSSFileSystem ajc$this, Path path, JoinPoint joinPoint) {
        Path qualifiedPath = path.makeQualified(ajc$this.uri, ajc$this.workingDir);
        String key = ajc$this.pathToKey(qualifiedPath);
        if (key.length() == 0) {
            return new FileStatus(0L, true, 1, 0L, 0L, qualifiedPath);
        }
        ObjectMetadata meta = ajc$this.store.getObjectMetadata(key);
        if (meta == null && !key.endsWith("/")) {
            key = String.valueOf(key) + "/";
            meta = ajc$this.store.getObjectMetadata(key);
        }
        if (meta == null) {
            ObjectListing listing = ajc$this.store.listObjects(key, 1, null, false);
            if (CollectionUtils.isNotEmpty((Collection)listing.getObjectSummaries()) || CollectionUtils.isNotEmpty((Collection)listing.getCommonPrefixes())) {
                return new FileStatus(0L, true, 1, 0L, 0L, qualifiedPath);
            }
            throw new FileNotFoundException(path + ": No such file or directory!");
        }
        if (ajc$this.objectRepresentsDirectory(key, meta.getContentLength())) {
            return new FileStatus(0L, true, 1, 0L, 0L, qualifiedPath);
        }
        return new FileStatus(meta.getContentLength(), false, 1, ajc$this.getDefaultBlockSize(path), meta.getLastModified().getTime(), qualifiedPath);
    }

    private static final /* synthetic */ Object getFileStatus_aroundBody9$advice(AliyunOSSFileSystem ajc$this, Path path, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return AliyunOSSFileSystem.getFileStatus_aroundBody8(ajc$this, path, (JoinPoint)proceedingJoinPoint);
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ String getScheme_aroundBody10(AliyunOSSFileSystem ajc$this, JoinPoint joinPoint) {
        return "oss";
    }

    private static final /* synthetic */ Object getScheme_aroundBody11$advice(AliyunOSSFileSystem ajc$this, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return AliyunOSSFileSystem.getScheme_aroundBody10(ajc$this, (JoinPoint)proceedingJoinPoint);
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ Object getUri_aroundBody13$advice(AliyunOSSFileSystem ajc$this, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return ajc$this.uri;
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ Object getWorkingDirectory_aroundBody15$advice(AliyunOSSFileSystem ajc$this, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return ajc$this.workingDir;
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ long getDefaultBlockSize_aroundBody16(AliyunOSSFileSystem ajc$this, JoinPoint joinPoint) {
        return ajc$this.getConf().getLong("fs.oss.block.size", 0x4000000L);
    }

    private static final /* synthetic */ Object getDefaultBlockSize_aroundBody17$advice(AliyunOSSFileSystem ajc$this, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return Conversions.longObject((long)AliyunOSSFileSystem.getDefaultBlockSize_aroundBody16(ajc$this, (JoinPoint)proceedingJoinPoint));
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ String getCanonicalServiceName_aroundBody18(AliyunOSSFileSystem ajc$this, JoinPoint joinPoint) {
        return null;
    }

    private static final /* synthetic */ Object getCanonicalServiceName_aroundBody19$advice(AliyunOSSFileSystem ajc$this, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return AliyunOSSFileSystem.getCanonicalServiceName_aroundBody18(ajc$this, (JoinPoint)proceedingJoinPoint);
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ void initialize_aroundBody20(AliyunOSSFileSystem ajc$this, URI name, Configuration conf, JoinPoint joinPoint) {
        super.initialize(name, conf);
        ajc$this.bucket = name.getHost();
        ajc$this.uri = URI.create(String.valueOf(name.getScheme()) + "://" + name.getAuthority());
        ajc$this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(ajc$this.uri, null);
        if (name.getQuery() != null) {
            LOG.debug("set roleArn from GetQuery: " + name.getQuery());
            List params = URLEncodedUtils.parse((URI)name, (String)"UTF-8");
            for (NameValuePair item : params) {
                if (!item.getName().equals("fs.oss.ststoken.roleArn")) continue;
                conf.set(item.getName(), item.getValue());
                break;
            }
        }
        ajc$this.store = new AliyunOSSFileSystemStore();
        ajc$this.store.initialize(name, conf, ajc$this.statistics);
        ajc$this.maxKeys = conf.getInt("fs.oss.paging.maximum", 1000);
        ajc$this.setConf(conf);
    }

    private static final /* synthetic */ Object initialize_aroundBody21$advice(AliyunOSSFileSystem ajc$this, URI name, Configuration conf, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                AliyunOSSFileSystem.initialize_aroundBody20(ajc$this, name, conf, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ FileStatus[] listStatus_aroundBody22(AliyunOSSFileSystem ajc$this, Path path, JoinPoint joinPoint) {
        String key = ajc$this.pathToKey(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("List status for path: " + path);
        }
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        FileStatus fileStatus = ajc$this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("listStatus: doing listObjects for directory " + key);
            }
            ObjectListing objects = ajc$this.store.listObjects(key, ajc$this.maxKeys, null, false);
            while (true) {
                ajc$this.statistics.incrementReadOps(1);
                for (OSSObjectSummary objectSummary : objects.getObjectSummaries()) {
                    String objKey = objectSummary.getKey();
                    if (objKey.equals(String.valueOf(key) + "/")) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring: " + objKey);
                        continue;
                    }
                    Path keyPath = ajc$this.keyToPath(objectSummary.getKey()).makeQualified(ajc$this.uri, ajc$this.workingDir);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding: fi: " + keyPath);
                    }
                    result.add(new FileStatus(objectSummary.getSize(), false, 1, ajc$this.getDefaultBlockSize(keyPath), objectSummary.getLastModified().getTime(), keyPath));
                }
                for (String prefix : objects.getCommonPrefixes()) {
                    if (prefix.equals(String.valueOf(key) + "/")) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring: " + prefix);
                        continue;
                    }
                    Path keyPath = ajc$this.keyToPath(prefix).makeQualified(ajc$this.uri, ajc$this.workingDir);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding: rd: " + keyPath);
                    }
                    result.add(new FileStatus(0L, true, 1, 0L, 0L, keyPath));
                }
                if (objects.isTruncated()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("listStatus: list truncated - getting next batch");
                    }
                    String nextMarker = objects.getNextMarker();
                    objects = ajc$this.store.listObjects(key, ajc$this.maxKeys, nextMarker, false);
                    ajc$this.statistics.incrementReadOps(1);
                    continue;
                }
                break;
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding: rd (not a dir): " + path);
            }
            result.add(fileStatus);
        }
        return result.toArray(new FileStatus[result.size()]);
    }

    private static final /* synthetic */ Object listStatus_aroundBody23$advice(AliyunOSSFileSystem ajc$this, Path path, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return AliyunOSSFileSystem.listStatus_aroundBody22(ajc$this, path, (JoinPoint)proceedingJoinPoint);
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ boolean mkdirs_aroundBody24(AliyunOSSFileSystem ajc$this, Path path, FsPermission permission, JoinPoint joinPoint) {
        block3: {
            try {
                FileStatus fileStatus = ajc$this.getFileStatus(path);
                if (!fileStatus.isDirectory()) break block3;
                return true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                ajc$this.validatePath(path);
                String key = ajc$this.pathToKey(path);
                return ajc$this.mkdir(key);
            }
        }
        throw new FileAlreadyExistsException("Path is a file: " + path);
    }

    private static final /* synthetic */ Object mkdirs_aroundBody25$advice(AliyunOSSFileSystem ajc$this, Path path, FsPermission permission, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return Conversions.booleanObject((boolean)AliyunOSSFileSystem.mkdirs_aroundBody24(ajc$this, path, permission, (JoinPoint)proceedingJoinPoint));
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ FSDataInputStream open_aroundBody26(AliyunOSSFileSystem ajc$this, Path path, int bufferSize, JoinPoint joinPoint) {
        FileStatus fileStatus = ajc$this.getFileStatus(path);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException("Can't open " + path + " because it is a directory");
        }
        return new FSDataInputStream((InputStream)((Object)new AliyunOSSInputStream(ajc$this.getConf(), ajc$this.store, ajc$this.pathToKey(path), fileStatus.getLen(), ajc$this.statistics)));
    }

    private static final /* synthetic */ Object open_aroundBody27$advice(AliyunOSSFileSystem ajc$this, Path path, int bufferSize, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return AliyunOSSFileSystem.open_aroundBody26(ajc$this, path, bufferSize, (JoinPoint)proceedingJoinPoint);
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ boolean rename_aroundBody28(AliyunOSSFileSystem ajc$this, Path srcPath, Path dstPath, JoinPoint joinPoint) {
        FileStatus dstStatus;
        if (srcPath.isRoot()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot rename the root of a filesystem");
            }
            return false;
        }
        Path parent = dstPath.getParent();
        while (parent != null && !srcPath.equals((Object)parent)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return false;
        }
        FileStatus srcStatus = ajc$this.getFileStatus(srcPath);
        try {
            dstStatus = ajc$this.getFileStatus(dstPath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            dstStatus = null;
        }
        if (dstStatus == null) {
            dstStatus = ajc$this.getFileStatus(dstPath.getParent());
            if (!dstStatus.isDirectory()) {
                throw new IOException(String.format("Failed to rename %s to %s, %s is a file", srcPath, dstPath, dstPath.getParent()));
            }
        } else {
            if (srcStatus.getPath().equals((Object)dstStatus.getPath())) {
                return !srcStatus.isDirectory();
            }
            if (dstStatus.isDirectory()) {
                FileStatus[] statuses;
                dstPath = new Path(dstPath, srcPath.getName());
                try {
                    statuses = ajc$this.listStatus(dstPath);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    statuses = null;
                }
                if (statuses != null && statuses.length > 0) {
                    throw new FileAlreadyExistsException(String.format("Failed to rename %s to %s, file already exists or not empty!", srcPath, dstPath));
                }
            } else {
                throw new FileAlreadyExistsException(String.format("Failed to rename %s to %s, file already exists!", srcPath, dstPath));
            }
        }
        if (srcStatus.isDirectory()) {
            ajc$this.copyDirectory(srcPath, dstPath);
        } else {
            ajc$this.copyFile(srcPath, dstPath);
        }
        return srcPath.equals((Object)dstPath) || ajc$this.delete(srcPath, true);
    }

    private static final /* synthetic */ Object rename_aroundBody29$advice(AliyunOSSFileSystem ajc$this, Path srcPath, Path dstPath, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return Conversions.booleanObject((boolean)AliyunOSSFileSystem.rename_aroundBody28(ajc$this, srcPath, dstPath, (JoinPoint)proceedingJoinPoint));
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ Object setWorkingDirectory_aroundBody31$advice(AliyunOSSFileSystem ajc$this, Path dir, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                ajc$this.workingDir = dir;
                return null;
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static final /* synthetic */ Object getStore_aroundBody33$advice(AliyunOSSFileSystem ajc$this, JoinPoint thisJoinPoint, RetryOnceSecurityTokenExpired ajc$aspectInstance, ProceedingJoinPoint point) {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                ProceedingJoinPoint proceedingJoinPoint = point;
                return ajc$this.store;
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.ajc$inlineAccessFieldGet$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$org_apache_hadoop_fs_aliyun_oss_RetryOnceSecurityTokenExpired$LOG().warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AliyunOSSFileSystem.java", AliyunOSSFileSystem.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "append", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "org.apache.hadoop.fs.Path:int:org.apache.hadoop.util.Progressable", "path:bufferSize:progress", "java.io.IOException", "org.apache.hadoop.fs.FSDataOutputStream"), 64);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "", "", "java.io.IOException", "void"), 70);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "java.net.URI:org.apache.hadoop.conf.Configuration", "name:conf", "java.io.IOException", "void"), 263);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listStatus", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "org.apache.hadoop.fs.Path", "path", "java.io.IOException", "[Lorg.apache.hadoop.fs.FileStatus;"), 319);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mkdirs", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "org.apache.hadoop.fs.Path:org.apache.hadoop.fs.permission.FsPermission", "path:permission", "java.io.IOException", "boolean"), 410);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "open", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "org.apache.hadoop.fs.Path:int", "path:bufferSize", "java.io.IOException", "org.apache.hadoop.fs.FSDataInputStream"), 452);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rename", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "org.apache.hadoop.fs.Path:org.apache.hadoop.fs.Path", "srcPath:dstPath", "java.io.IOException", "boolean"), 464);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setWorkingDirectory", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "org.apache.hadoop.fs.Path", "dir", "", "void"), 585);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getStore", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "", "", "", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore"), 589);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "org.apache.hadoop.fs.Path:org.apache.hadoop.fs.permission.FsPermission:boolean:int:short:long:org.apache.hadoop.util.Progressable", "path:permission:overwrite:bufferSize:replication:blockSize:progress", "java.io.IOException", "org.apache.hadoop.fs.FSDataOutputStream"), 79);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "org.apache.hadoop.fs.Path:boolean", "path:recursive", "java.io.IOException", "boolean"), 108);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFileStatus", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "org.apache.hadoop.fs.Path", "path", "java.io.IOException", "org.apache.hadoop.fs.FileStatus"), 197);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getScheme", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "", "", "", "java.lang.String"), 231);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUri", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "", "", "", "java.net.URI"), 236);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkingDirectory", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "", "", "", "org.apache.hadoop.fs.Path"), 241);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDefaultBlockSize", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "", "", "", "long"), 246);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCanonicalServiceName", "org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem", "", "", "", "java.lang.String"), 251);
    }
}

