/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.requestcupid.CupidStsTokenUtil;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.DefaultCredentials;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadPartCopyRequest;
import com.aliyun.oss.model.UploadPartCopyResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSUtils;
import org.apache.hadoop.fs.aliyun.oss.AliyunStsTokenCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOSSFileSystemStore {
    public static final Logger LOG = LoggerFactory.getLogger(AliyunOSSFileSystemStore.class);
    private FileSystem.Statistics statistics;
    private OSSClient ossClient;
    private String bucketName;
    private long uploadPartSize;
    private long multipartThreshold;
    private long partSize;
    private int maxKeys;
    private String serverSideEncryptionAlgorithm;

    /*
     * Unable to fully structure code
     */
    public void initialize(URI uri, Configuration conf, FileSystem.Statistics stat) throws IOException {
        block21: {
            this.statistics = stat;
            clientConf = new ClientConfiguration();
            clientConf.setMaxConnections(conf.getInt("fs.oss.connection.maximum", 32));
            secureConnections = conf.getBoolean("fs.oss.connection.secure.enabled", true);
            clientConf.setProtocol(secureConnections != false ? Protocol.HTTPS : Protocol.HTTP);
            clientConf.setMaxErrorRetry(conf.getInt("fs.oss.attempts.maximum", 20));
            clientConf.setConnectionTimeout(conf.getInt("fs.oss.connection.establish.timeout", 50000));
            clientConf.setSocketTimeout(conf.getInt("fs.oss.connection.timeout", 200000));
            clientConf.setSupportCname(conf.getBoolean("fs.oss.cname.enable", true));
            proxyHost = conf.getTrimmed("fs.oss.proxy.host", "");
            proxyPort = conf.getInt("fs.oss.proxy.port", -1);
            if (StringUtils.isNotEmpty((String)proxyHost)) {
                clientConf.setProxyHost(proxyHost);
                if (proxyPort >= 0) {
                    clientConf.setProxyPort(proxyPort);
                } else if (secureConnections) {
                    AliyunOSSFileSystemStore.LOG.warn("Proxy host set without port. Using HTTPS default 443");
                    clientConf.setProxyPort(443);
                } else {
                    AliyunOSSFileSystemStore.LOG.warn("Proxy host set without port. Using HTTP default 80");
                    clientConf.setProxyPort(80);
                }
                proxyUsername = conf.getTrimmed("fs.oss.proxy.username");
                proxyPassword = conf.getTrimmed("fs.oss.proxy.password");
                if (proxyUsername == null != (proxyPassword == null)) {
                    msg = "Proxy error: fs.oss.proxy.username or fs.oss.proxy.password set without the other.";
                    AliyunOSSFileSystemStore.LOG.error(msg);
                    throw new IllegalArgumentException(msg);
                }
                clientConf.setProxyUsername(proxyUsername);
                clientConf.setProxyPassword(proxyPassword);
                clientConf.setProxyDomain(conf.getTrimmed("fs.oss.proxy.domain"));
                clientConf.setProxyWorkstation(conf.getTrimmed("fs.oss.proxy.workstation"));
            } else if (proxyPort >= 0) {
                msg = "Proxy error: fs.oss.proxy.port set without fs.oss.proxy.host";
                AliyunOSSFileSystemStore.LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            endPoint = conf.getTrimmed("fs.oss.endpoint", "");
            provider = AliyunOSSUtils.getCredentialsProvider(conf);
            if (provider.getClass() == AliyunStsTokenCredentialsProvider.class) {
                try {
                    AliyunOSSFileSystemStore.LOG.debug("hadoopConf roleArn: " + conf.get("fs.oss.ststoken.roleArn"));
                    stsTokenInfo = CupidStsTokenUtil.FetchStsToken((String)conf.get("fs.oss.ststoken.roleArn"), (String)"Oss");
                    provider.setCredentials((Credentials)new DefaultCredentials(stsTokenInfo.akId, stsTokenInfo.akSecret, stsTokenInfo.token));
                    break block21;
                }
                catch (Exception v0) {
                    cupidConf = new CupidConf();
                    ** for (confItem : conf)
                }
lbl-1000:
                // 1 sources

                {
                    cupidConf.set((String)confItem.getKey(), (String)confItem.getValue());
                    continue;
                }
lbl53:
                // 1 sources

                cupidSession = new CupidSession(cupidConf);
                try {
                    CupidStsTokenUtil.GenerateStsToken((String)conf.get("fs.oss.ststoken.roleArn"), (String)"Oss", (CupidSession)cupidSession);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                stsTokenInfo = null;
                try {
                    stsTokenInfo = CupidStsTokenUtil.FetchStsToken((String)conf.get("fs.oss.ststoken.roleArn"), (String)"Oss");
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                provider.setCredentials((Credentials)new DefaultCredentials(stsTokenInfo.akId, stsTokenInfo.akSecret, stsTokenInfo.token));
            }
        }
        this.ossClient = new OSSClient(endPoint, provider, clientConf);
        this.uploadPartSize = conf.getLong("fs.oss.multipart.upload.size", 0xA00000L);
        this.multipartThreshold = conf.getLong("fs.oss.multipart.upload.threshold", 0x1400000L);
        this.partSize = conf.getLong("fs.oss.multipart.upload.size", 0xA00000L);
        if (this.partSize < 102400L) {
            this.partSize = 102400L;
        }
        this.serverSideEncryptionAlgorithm = conf.get("fs.oss.server-side-encryption-algorithm", "");
        if (this.uploadPartSize < 0x500000L) {
            AliyunOSSFileSystemStore.LOG.warn("fs.oss.multipart.upload.size must be at least 5 MB");
            this.uploadPartSize = 0x500000L;
        }
        if (this.multipartThreshold < 0x500000L) {
            AliyunOSSFileSystemStore.LOG.warn("fs.oss.multipart.upload.threshold must be at least 5 MB");
            this.multipartThreshold = 0x500000L;
        }
        if (this.multipartThreshold > 0x40000000L) {
            AliyunOSSFileSystemStore.LOG.warn("fs.oss.multipart.upload.threshold must be less than 1 GB");
            this.multipartThreshold = 0x40000000L;
        }
        if (StringUtils.isNotEmpty((String)(cannedACLName = conf.get("fs.oss.acl.default", "")))) {
            cannedACL = CannedAccessControlList.valueOf((String)cannedACLName);
            this.ossClient.setBucketAcl(this.bucketName, cannedACL);
        }
        this.maxKeys = conf.getInt("fs.oss.paging.maximum", 1000);
        this.bucketName = uri.getHost();
    }

    public void deleteObject(String key) {
        this.ossClient.deleteObject(this.bucketName, key);
        this.statistics.incrementWriteOps(1);
    }

    public void deleteObjects(List<String> keysToDelete) {
        if (CollectionUtils.isNotEmpty(keysToDelete)) {
            DeleteObjectsRequest deleteRequest = new DeleteObjectsRequest(this.bucketName);
            deleteRequest.setKeys(keysToDelete);
            this.ossClient.deleteObjects(deleteRequest);
            this.statistics.incrementWriteOps(keysToDelete.size());
        }
    }

    public void deleteDirs(String key) {
        key = AliyunOSSUtils.maybeAddTrailingSlash(key);
        ListObjectsRequest listRequest = new ListObjectsRequest(this.bucketName);
        listRequest.setPrefix(key);
        listRequest.setDelimiter(null);
        listRequest.setMaxKeys(Integer.valueOf(this.maxKeys));
        while (true) {
            ObjectListing objects = this.ossClient.listObjects(listRequest);
            this.statistics.incrementReadOps(1);
            ArrayList<String> keysToDelete = new ArrayList<String>();
            for (OSSObjectSummary objectSummary : objects.getObjectSummaries()) {
                keysToDelete.add(objectSummary.getKey());
            }
            this.deleteObjects(keysToDelete);
            if (!objects.isTruncated()) break;
            listRequest.setMarker(objects.getNextMarker());
        }
    }

    public ObjectMetadata getObjectMetadata(String key) {
        try {
            ObjectMetadata objectMetadata = this.ossClient.getObjectMetadata(this.bucketName, key);
            return objectMetadata;
        }
        catch (OSSException oSSException) {
            return null;
        }
        finally {
            this.statistics.incrementReadOps(1);
        }
    }

    public void storeEmptyFile(String key) throws IOException {
        ObjectMetadata dirMeta = new ObjectMetadata();
        byte[] buffer = new byte[]{};
        dirMeta.setContentLength(0L);
        try (ByteArrayInputStream in = new ByteArrayInputStream(buffer);){
            this.ossClient.putObject(this.bucketName, key, (InputStream)in, dirMeta);
        }
    }

    public boolean copyFile(String srcKey, String dstKey) {
        ObjectMetadata objectMeta = this.ossClient.getObjectMetadata(this.bucketName, srcKey);
        long contentLength = objectMeta.getContentLength();
        if (contentLength <= this.multipartThreshold) {
            return this.singleCopy(srcKey, dstKey);
        }
        return this.multipartCopy(srcKey, contentLength, dstKey);
    }

    private boolean singleCopy(String srcKey, String dstKey) {
        CopyObjectResult copyResult = this.ossClient.copyObject(this.bucketName, srcKey, this.bucketName, dstKey);
        LOG.debug(copyResult.getETag());
        return true;
    }

    private boolean multipartCopy(String srcKey, long contentLength, String dstKey) {
        long realPartSize = AliyunOSSUtils.calculatePartSize(contentLength, this.uploadPartSize);
        int partNum = (int)(contentLength / realPartSize);
        if (contentLength % realPartSize != 0L) {
            ++partNum;
        }
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(this.bucketName, dstKey);
        ObjectMetadata meta = new ObjectMetadata();
        if (StringUtils.isNotEmpty((String)this.serverSideEncryptionAlgorithm)) {
            meta.setServerSideEncryption(this.serverSideEncryptionAlgorithm);
        }
        initiateMultipartUploadRequest.setObjectMetadata(meta);
        InitiateMultipartUploadResult initiateMultipartUploadResult = this.ossClient.initiateMultipartUpload(initiateMultipartUploadRequest);
        String uploadId = initiateMultipartUploadResult.getUploadId();
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        try {
            int i = 0;
            while (i < partNum) {
                long skipBytes = realPartSize * (long)i;
                long size = realPartSize < contentLength - skipBytes ? realPartSize : contentLength - skipBytes;
                UploadPartCopyRequest partCopyRequest = new UploadPartCopyRequest();
                partCopyRequest.setSourceBucketName(this.bucketName);
                partCopyRequest.setSourceKey(srcKey);
                partCopyRequest.setBucketName(this.bucketName);
                partCopyRequest.setKey(dstKey);
                partCopyRequest.setUploadId(uploadId);
                partCopyRequest.setPartSize(Long.valueOf(size));
                partCopyRequest.setBeginIndex(Long.valueOf(skipBytes));
                partCopyRequest.setPartNumber(i + 1);
                UploadPartCopyResult partCopyResult = this.ossClient.uploadPartCopy(partCopyRequest);
                this.statistics.incrementWriteOps(1);
                partETags.add(partCopyResult.getPartETag());
                ++i;
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.bucketName, dstKey, uploadId, partETags);
            CompleteMultipartUploadResult completeMultipartUploadResult = this.ossClient.completeMultipartUpload(completeMultipartUploadRequest);
            LOG.debug(completeMultipartUploadResult.getETag());
            return true;
        }
        catch (ClientException | OSSException throwable) {
            AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(this.bucketName, dstKey, uploadId);
            this.ossClient.abortMultipartUpload(abortMultipartUploadRequest);
            return false;
        }
    }

    public void uploadObject(String key, File file) throws IOException {
        File object = file.getAbsoluteFile();
        FileInputStream fis = new FileInputStream(object);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentLength(object.length());
        if (StringUtils.isNotEmpty((String)this.serverSideEncryptionAlgorithm)) {
            meta.setServerSideEncryption(this.serverSideEncryptionAlgorithm);
        }
        try {
            PutObjectResult result = this.ossClient.putObject(this.bucketName, key, (InputStream)fis, meta);
            LOG.debug(result.getETag());
            this.statistics.incrementWriteOps(1);
        }
        finally {
            fis.close();
        }
    }

    public void multipartUploadObject(String key, File file) throws IOException {
        File object = file.getAbsoluteFile();
        long dataLen = object.length();
        long realPartSize = AliyunOSSUtils.calculatePartSize(dataLen, this.partSize);
        int partNum = (int)(dataLen / realPartSize);
        if (dataLen % realPartSize != 0L) {
            ++partNum;
        }
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(this.bucketName, key);
        ObjectMetadata meta = new ObjectMetadata();
        if (StringUtils.isNotEmpty((String)this.serverSideEncryptionAlgorithm)) {
            meta.setServerSideEncryption(this.serverSideEncryptionAlgorithm);
        }
        initiateMultipartUploadRequest.setObjectMetadata(meta);
        InitiateMultipartUploadResult initiateMultipartUploadResult = this.ossClient.initiateMultipartUpload(initiateMultipartUploadRequest);
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        String uploadId = initiateMultipartUploadResult.getUploadId();
        try {
            int i = 0;
            while (i < partNum) {
                try (FileInputStream fis = new FileInputStream(object);){
                    long skipBytes = realPartSize * (long)i;
                    AliyunOSSUtils.skipFully(fis, skipBytes);
                    long size = realPartSize < dataLen - skipBytes ? realPartSize : dataLen - skipBytes;
                    UploadPartRequest uploadPartRequest = new UploadPartRequest();
                    uploadPartRequest.setBucketName(this.bucketName);
                    uploadPartRequest.setKey(key);
                    uploadPartRequest.setUploadId(uploadId);
                    uploadPartRequest.setInputStream((InputStream)fis);
                    uploadPartRequest.setPartSize(size);
                    uploadPartRequest.setPartNumber(i + 1);
                    UploadPartResult uploadPartResult = this.ossClient.uploadPart(uploadPartRequest);
                    this.statistics.incrementWriteOps(1);
                    partETags.add(uploadPartResult.getPartETag());
                }
                ++i;
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(this.bucketName, key, uploadId, partETags);
            CompleteMultipartUploadResult completeMultipartUploadResult = this.ossClient.completeMultipartUpload(completeMultipartUploadRequest);
            LOG.debug(completeMultipartUploadResult.getETag());
        }
        catch (ClientException | OSSException throwable) {
            AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(this.bucketName, key, uploadId);
            this.ossClient.abortMultipartUpload(abortMultipartUploadRequest);
        }
    }

    public ObjectListing listObjects(String prefix, int maxListingLength, String marker, boolean recursive) {
        String delimiter = recursive ? null : "/";
        prefix = AliyunOSSUtils.maybeAddTrailingSlash(prefix);
        ListObjectsRequest listRequest = new ListObjectsRequest(this.bucketName);
        listRequest.setPrefix(prefix);
        listRequest.setDelimiter(delimiter);
        listRequest.setMaxKeys(Integer.valueOf(maxListingLength));
        listRequest.setMarker(marker);
        ObjectListing listing = this.ossClient.listObjects(listRequest);
        this.statistics.incrementReadOps(1);
        return listing;
    }

    public InputStream retrieve(String key, long byteStart, long byteEnd) {
        try {
            GetObjectRequest request = new GetObjectRequest(this.bucketName, key);
            request.setRange(byteStart, byteEnd);
            return this.ossClient.getObject(request).getObjectContent();
        }
        catch (ClientException | OSSException throwable) {
            return null;
        }
    }

    public void close() {
        if (this.ossClient != null) {
            this.ossClient.shutdown();
            this.ossClient = null;
        }
    }

    public void purge(String prefix) {
        try {
            ObjectListing objects = this.listObjects(prefix, this.maxKeys, null, true);
            for (OSSObjectSummary object : objects.getObjectSummaries()) {
                String key = object.getKey();
                this.ossClient.deleteObject(this.bucketName, key);
            }
            for (String dir : objects.getCommonPrefixes()) {
                this.deleteDirs(dir);
            }
        }
        catch (ClientException | OSSException throwable) {
            LOG.error("Failed to purge " + prefix);
        }
    }
}

