/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.InvalidCredentialsException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSUtils;

public class AliyunStsTokenCredentialsProvider
implements CredentialsProvider {
    private Credentials credentials = null;

    public AliyunStsTokenCredentialsProvider(Configuration conf) throws IOException {
        try {
            AliyunOSSUtils.getValueWithKey(conf, "fs.oss.accessKeyId");
            AliyunOSSUtils.getValueWithKey(conf, "fs.oss.accessKeySecret");
        }
        catch (IOException e) {
            throw new InvalidCredentialsException((Throwable)e);
        }
        try {
            AliyunOSSUtils.getValueWithKey(conf, "fs.oss.securityToken");
        }
        catch (IOException iOException) {
        }
    }

    public void setCredentials(Credentials creds) {
        if (creds == null) {
            throw new InvalidCredentialsException("Credentials should not be null.");
        }
        this.credentials = creds;
    }

    public Credentials getCredentials() {
        if (this.credentials == null) {
            throw new InvalidCredentialsException("Invalid credentials");
        }
        return this.credentials;
    }
}

