/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.oss;

import com.aliyun.oss.OSSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public final class RetryOnceSecurityTokenExpired {
    private static final Log LOG = LogFactory.getLog(RetryOnceSecurityTokenExpired.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ RetryOnceSecurityTokenExpired ajc$perSingletonInstance;

    static {
        try {
            RetryOnceSecurityTokenExpired.ajc$perSingletonInstance = new RetryOnceSecurityTokenExpired();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Around(value="execution(public * org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem.*(..))")
    public Object wrap(ProceedingJoinPoint point) throws Throwable {
        AliyunOSSFileSystem target = (AliyunOSSFileSystem)((Object)point.getTarget());
        int attempt = 0;
        int maxAttempt = 1;
        while (true) {
            try {
                RetryOnceSecurityTokenExpired.LOG.debug((Object)(String.valueOf(point.getSignature().getName()) + " called, RetryOnceSecurityTokenExpired intercepted"));
                return point.proceed();
            }
            catch (Throwable ex) {
                if (attempt >= maxAttempt) {
                    RetryOnceSecurityTokenExpired.LOG.warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry becaulse maxAttempt exceed"));
                    throw ex;
                }
                if (ex.getClass() != OSSException.class || !((OSSException)ex).getErrorCode().equals("SecurityTokenExpired")) {
                    RetryOnceSecurityTokenExpired.LOG.warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with " + ex.getMessage() + ", will not retry"));
                    throw ex;
                }
                RetryOnceSecurityTokenExpired.LOG.warn((Object)(String.valueOf(point.getSignature().getName()) + " failed with SecurityTokenExpired, try initialize again and retry"));
                target.initialize(target.getUri(), target.getConf());
                ++attempt;
                continue;
            }
            break;
        }
    }

    public static RetryOnceSecurityTokenExpired aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.apache.hadoop.fs.aliyun.oss.RetryOnceSecurityTokenExpired", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

