/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.data.Record;
import com.aliyun.odps.jdbc.OdpsResultSet;
import com.aliyun.odps.jdbc.OdpsResultSetMetaData;
import com.aliyun.odps.jdbc.OdpsStatement;
import com.aliyun.odps.jdbc.PublicMethodAspect;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class OdpsScollResultSet
extends OdpsResultSet
implements ResultSet {
    private InstanceTunnel.DownloadSession sessionHandle;
    private int fetchSize;
    private OdpsStatement.FetchDirection fetchDirection;
    private final long totalRows;
    private Object[][] rowsCache;
    private long cursorRow;
    private long cachedUpperRow;
    private boolean isClosed = false;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;

    OdpsScollResultSet(OdpsStatement stmt, OdpsResultSetMetaData meta, InstanceTunnel.DownloadSession session) throws SQLException {
        super(stmt.getConnection(), stmt, meta);
        this.sessionHandle = session;
        this.fetchSize = stmt.resultSetFetchSize;
        this.fetchDirection = stmt.resultSetFetchDirection;
        int maxRows = stmt.resultSetMaxRows;
        long recordCount = this.sessionHandle.getRecordCount();
        this.totalRows = maxRows > 0 && (long)maxRows <= recordCount ? (long)maxRows : recordCount;
        this.cachedUpperRow = this.totalRows;
        this.cursorRow = -1L;
        this.rowsCache = new Object[this.fetchSize][];
    }

    @Override
    public boolean absolute(int rows) throws SQLException {
        int n = rows;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            long target = rows >= 0 ? (long)rows : this.totalRows + (long)rows;
            long l = target = rows >= 0 ? target - 1L : target;
            if (target >= 0L && target < this.totalRows) {
                this.cursorRow = target;
                bl2 = bl3 = true;
            } else {
                this.cursorRow = target < 0L ? -1L : this.totalRows;
                bl2 = bl3 = false;
            }
            boolean bl4 = bl = bl2;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl3;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void afterLast() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            this.cursorRow = this.totalRows;
            Object var2_2 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var2_2, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The result set has been closed");
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            this.cursorRow = -1L;
            Object var2_2 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var2_2, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean first() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            this.cursorRow = 0L;
            boolean bl3 = bl2 = this.totalRows > 0L ? (bl = true) : (bl = false);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        try {
            int n;
            int n2;
            int direction;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            switch (this.fetchDirection) {
                case FORWARD: {
                    direction = 1000;
                    break;
                }
                case REVERSE: {
                    direction = 1001;
                    break;
                }
                default: {
                    direction = 1002;
                }
            }
            int n3 = n2 = (n = direction);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        try {
            int n;
            int n2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            int n3 = n2 = (n = this.fetchSize);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        int n = rows;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.fetchSize = rows;
            this.rowsCache = new Object[this.fetchSize][];
            this.cachedUpperRow = this.totalRows;
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getRow() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        try {
            int n;
            int n2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            int n3 = n2 = (n = (int)this.cursorRow + 1);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n2), joinPoint);
            return n;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public int getType() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        try {
            int n;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            int n2 = 1004;
            int n3 = n = 1004;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.intObject((int)n), joinPoint);
            return n2;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            boolean bl3 = bl2 = this.cursorRow == this.totalRows ? (bl = true) : (bl = false);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            boolean bl3 = bl2 = this.cursorRow == -1L ? (bl = true) : (bl = false);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            boolean bl3 = bl2 = (bl = this.isClosed);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            boolean bl3 = bl2 = this.cursorRow == 0L ? (bl = true) : (bl = false);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            boolean bl3 = bl2 = this.cursorRow == this.totalRows - 1L ? (bl = true) : (bl = false);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean last() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_14, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            this.cursorRow = this.totalRows - 1L;
            boolean bl3 = bl2 = this.totalRows > 0L ? (bl = true) : (bl = false);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean previous() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_15, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            if (this.cursorRow != -1L) {
                --this.cursorRow;
            }
            boolean bl3 = bl2 = this.cursorRow != -1L ? (bl = true) : (bl = false);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        int n = rows;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_16, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            long target = this.cursorRow + (long)rows;
            if (target >= 0L && target < this.totalRows) {
                this.cursorRow = target;
                bl2 = bl3 = true;
            } else {
                this.cursorRow = target < 0L ? -1L : this.totalRows;
                bl2 = bl3 = false;
            }
            boolean bl4 = bl = bl2;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl), joinPoint);
            return bl3;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        int n = direction;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_17, (Object)this, (Object)this, (Object)Conversions.intObject((int)n));
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            switch (direction) {
                case 1000: {
                    this.fetchDirection = OdpsStatement.FetchDirection.FORWARD;
                    break;
                }
                case 1001: {
                    this.fetchDirection = OdpsStatement.FetchDirection.REVERSE;
                    break;
                }
                case 1002: {
                    this.fetchDirection = OdpsStatement.FetchDirection.UNKNOWN;
                    break;
                }
                default: {
                    throw new SQLException("invalid argument for setFetchDirection()");
                }
            }
            this.conn.log.info("setFetchDirection has not been utilized");
            Object var4_4 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var4_4, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public void close() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_18, (Object)this, (Object)this);
        try {
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            if (!this.isClosed) {
                this.isClosed = true;
                this.sessionHandle = null;
                this.rowsCache = null;
            }
            Object var2_2 = null;
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(var2_2, joinPoint);
            return;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    public boolean next() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_19, (Object)this, (Object)this);
        try {
            boolean bl;
            boolean bl2;
            PublicMethodAspect.aspectOf().ajc$before$com_aliyun_odps_jdbc_PublicMethodAspect$1$1e38ef89(joinPoint);
            this.checkClosed();
            if (this.cursorRow != this.totalRows) {
                ++this.cursorRow;
            }
            boolean bl3 = bl2 = this.cursorRow != this.totalRows ? (bl = true) : (bl = false);
            PublicMethodAspect.aspectOf().ajc$afterReturning$com_aliyun_odps_jdbc_PublicMethodAspect$2$1e38ef89(Conversions.booleanObject((boolean)bl2), joinPoint);
            return bl;
        }
        catch (Exception exception) {
            PublicMethodAspect.aspectOf().ajc$afterThrowing$com_aliyun_odps_jdbc_PublicMethodAspect$3$1e38ef89(exception);
            throw exception;
        }
    }

    @Override
    protected Object[] rowAtCursor() throws SQLException {
        int offset;
        Object[] row;
        boolean cacheHit;
        boolean bl = cacheHit = this.cursorRow >= this.cachedUpperRow && this.cursorRow < this.cachedUpperRow + (long)this.fetchSize;
        if (!cacheHit) {
            this.fetchRows();
        }
        if ((row = this.rowsCache[offset = (int)(this.cursorRow - this.cachedUpperRow)]) == null) {
            throw new SQLException("the row should be not-null, row=" + this.cursorRow);
        }
        if (row.length == 0) {
            throw new SQLException("the row should have more than 1 column , row=" + this.cursorRow);
        }
        return row;
    }

    private void fetchRows() throws SQLException {
        this.cachedUpperRow = this.cursorRow / (long)this.fetchSize * (long)this.fetchSize;
        long count = this.fetchSize;
        if (this.cachedUpperRow + count > this.totalRows) {
            count = this.totalRows - this.cachedUpperRow;
        }
        try {
            long start = System.currentTimeMillis();
            Record reuseRecord = null;
            TunnelRecordReader reader = this.sessionHandle.openRecordReader(this.cachedUpperRow, count, true);
            int i = 0;
            while ((long)i < count) {
                reuseRecord = reader.read(reuseRecord);
                int columns = reuseRecord.getColumnCount();
                this.rowsCache[i] = new Object[columns];
                int j = 0;
                while (j < reuseRecord.getColumnCount()) {
                    this.rowsCache[i][j] = reuseRecord.get(j);
                    ++j;
                }
                ++i;
            }
            long duration = System.currentTimeMillis() - start;
            long totalKBytes = reader.getTotalBytes() / 1024L;
            this.conn.log.debug(String.format("fetch records, start=%d, cnt=%d, %d KB, %.2f KB/s", this.cachedUpperRow, count, totalKBytes, Float.valueOf((float)totalKBytes / (float)duration * 1000.0f)));
            reader.close();
        }
        catch (TunnelException e) {
            throw new SQLException(e);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    static {
        OdpsScollResultSet.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OdpsScollResultSet.java", OdpsScollResultSet.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "absolute", "com.aliyun.odps.jdbc.OdpsScollResultSet", "int", "rows", "java.sql.SQLException", "boolean"), 81);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "afterLast", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "void"), 98);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isBeforeFirst", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "boolean"), 168);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isClosed", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "boolean"), 174);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isFirst", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "boolean"), 179);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isLast", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "boolean"), 185);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "last", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "boolean"), 191);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "previous", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "boolean"), 198);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "relative", "com.aliyun.odps.jdbc.OdpsScollResultSet", "int", "rows", "java.sql.SQLException", "boolean"), 208);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFetchDirection", "com.aliyun.odps.jdbc.OdpsScollResultSet", "int", "direction", "java.sql.SQLException", "void"), 223);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "close", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "void"), 242);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "next", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "boolean"), 252);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "beforeFirst", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "void"), 110);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "first", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "boolean"), 116);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFetchDirection", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "int"), 123);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFetchSize", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "int"), 139);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setFetchSize", "com.aliyun.odps.jdbc.OdpsScollResultSet", "int", "rows", "java.sql.SQLException", "void"), 144);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getRow", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "int"), 151);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getType", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "int"), 157);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isAfterLast", "com.aliyun.odps.jdbc.OdpsScollResultSet", "", "", "java.sql.SQLException", "boolean"), 162);
    }
}

