/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcDateTypeTransformer;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ToJdbcDateToJdbcDateTypeTransformer
extends AbstractToJdbcDateTypeTransformer {
    /*
     * Loose catch block
     */
    @Override
    public Object transform(Object o, String charset, Calendar cal) throws SQLException {
        if (o == null) {
            return null;
        }
        if (Date.class.isInstance(o)) {
            return new java.sql.Date(((Date)o).getTime());
        }
        if (o instanceof byte[]) {
            try {
                SimpleDateFormat datetimeFormat = AbstractToJdbcDateTypeTransformer.DATETIME_FORMAT.get();
                SimpleDateFormat dateFormat = AbstractToJdbcDateTypeTransformer.DATE_FORMAT.get();
                if (cal != null) {
                    datetimeFormat.setCalendar(cal);
                    dateFormat.setCalendar(cal);
                }
                try {
                    java.sql.Date date = new java.sql.Date(datetimeFormat.parse(ToJdbcDateToJdbcDateTypeTransformer.encodeBytes((byte[])o, charset)).getTime());
                    return date;
                }
                catch (ParseException parseException) {
                    java.sql.Date date = new java.sql.Date(dateFormat.parse(ToJdbcDateToJdbcDateTypeTransformer.encodeBytes((byte[])o, charset)).getTime());
                    this.restoreToDefaultCalendar();
                    return date;
                    {
                        catch (ParseException parseException2) {
                            String errorMsg = ToJdbcDateToJdbcDateTypeTransformer.getTransformationErrMsg(ToJdbcDateToJdbcDateTypeTransformer.encodeBytes((byte[])o, charset), java.sql.Date.class);
                            throw new SQLException(errorMsg);
                        }
                    }
                }
            }
            finally {
                this.restoreToDefaultCalendar();
            }
        }
        String errorMsg = ToJdbcDateToJdbcDateTypeTransformer.getInvalidTransformationErrorMsg(o.getClass(), java.sql.Date.class);
        throw new SQLException(errorMsg);
    }
}

