/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcDateTypeTransformer;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ToJdbcTimestampTransformer
extends AbstractToJdbcDateTypeTransformer {
    @Override
    public Object transform(Object o, String charset, Calendar cal) throws SQLException {
        if (o == null) {
            return null;
        }
        if (Date.class.isInstance(o)) {
            if (o instanceof Timestamp) {
                return o;
            }
            return new Timestamp(((Date)o).getTime());
        }
        if (o instanceof byte[]) {
            try {
                String timestampStr;
                int dotIndex;
                SimpleDateFormat datetimeFormat = AbstractToJdbcDateTypeTransformer.DATETIME_FORMAT.get();
                if (cal != null) {
                    datetimeFormat.setCalendar(cal);
                }
                Date date = (dotIndex = (timestampStr = ToJdbcTimestampTransformer.encodeBytes((byte[])o, charset)).indexOf(46)) == -1 ? datetimeFormat.parse(timestampStr) : datetimeFormat.parse(timestampStr.substring(0, dotIndex));
                Timestamp timestamp = Timestamp.valueOf(timestampStr);
                int nanoValue = timestamp.getNanos();
                timestamp.setTime(date.getTime());
                timestamp.setNanos(nanoValue);
                Timestamp timestamp2 = timestamp;
                return timestamp2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String errorMsg = ToJdbcTimestampTransformer.getTransformationErrMsg(o, Timestamp.class);
                throw new SQLException(errorMsg);
            }
            catch (ParseException parseException) {
                String errorMsg = ToJdbcTimestampTransformer.getTransformationErrMsg(o, Timestamp.class);
                throw new SQLException(errorMsg);
            }
            finally {
                this.restoreToDefaultCalendar();
            }
        }
        String errorMsg = ToJdbcTimestampTransformer.getInvalidTransformationErrorMsg(o.getClass(), Timestamp.class);
        throw new SQLException(errorMsg);
    }
}

