/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.IntervalDayTime;
import com.aliyun.odps.data.IntervalYearMonth;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.CharTypeInfo;
import com.aliyun.odps.type.DecimalTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.VarcharTypeInfo;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OdpsTypeTransformer {
    private static final int UTF8_ENCODED_CHAR_MAX_SIZE = 6;
    private static final long DATETIME_MAX_TICKS = 253402387200000L;
    private static final long DATETIME_MIN_TICKS = -62167305600000L;
    private static Map<OdpsType, Class> ODPS_TYPE_MAPPER = new HashMap<OdpsType, Class>();

    OdpsTypeTransformer() {
    }

    public static Class odpsTypeToJavaType(OdpsType type) {
        if (ODPS_TYPE_MAPPER.containsKey((Object)type)) {
            return ODPS_TYPE_MAPPER.get((Object)type);
        }
        throw new IllegalArgumentException("Cannot get Java type for Odps type: " + (Object)((Object)type));
    }

    private static void validateString(String value, long limit) {
        try {
            if ((long)(value.length() * 6) > limit && (long)value.getBytes("utf-8").length > limit) {
                throw new IllegalArgumentException("InvalidData: The string's length is more than " + limit + " bytes.");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static void validateChar(Char value, CharTypeInfo typeInfo) {
        if (value.length() > typeInfo.getLength()) {
            throw new IllegalArgumentException(String.format("InvalidData: %s data is overflow, pls check data length: %s.", typeInfo.getTypeName(), value.length()));
        }
    }

    private static void validateVarChar(Varchar value, VarcharTypeInfo typeInfo) {
        if (value.length() > typeInfo.getLength()) {
            throw new IllegalArgumentException(String.format("InvalidData: %s data is overflow, pls check data length: %s.", typeInfo.getTypeName(), value.length()));
        }
    }

    private static void validateBigint(Long value) {
        if (value == Long.MIN_VALUE) {
            throw new IllegalArgumentException("InvalidData: Bigint out of range.");
        }
    }

    private static void validateDateTime(Date value) {
        if (value.getTime() > 253402387200000L || value.getTime() < -62167305600000L) {
            throw new IllegalArgumentException("InvalidData: Datetime out of range.");
        }
    }

    private static void validateDecimal(BigDecimal value, DecimalTypeInfo typeInfo) {
        BigDecimal tmpValue = value.setScale(typeInfo.getScale(), RoundingMode.HALF_UP);
        int intLength = tmpValue.precision() - tmpValue.scale();
        if (intLength > typeInfo.getPrecision() - typeInfo.getScale()) {
            throw new IllegalArgumentException(String.format("InvalidData: decimal value %s overflow, max integer digit number is %s.", value, typeInfo.getPrecision() - typeInfo.getScale()));
        }
    }

    private static List transformArray(List value, ArrayTypeInfo typeInfo, boolean strict, long fieldMaxSize) {
        ArrayList<Object> newList = new ArrayList<Object>(value.size());
        TypeInfo elementTypeInfo = typeInfo.getElementTypeInfo();
        for (Object obj : value) {
            newList.add(OdpsTypeTransformer.transform(obj, elementTypeInfo, strict, fieldMaxSize));
        }
        return newList;
    }

    private static Map transformMap(Map value, MapTypeInfo typeInfo, boolean strict, long fieldMaxSize) {
        TypeInfo keyTypeInfo = typeInfo.getKeyTypeInfo();
        TypeInfo valTypeInfo = typeInfo.getValueTypeInfo();
        HashMap<Object, Object> newMap = new HashMap<Object, Object>(value.size(), 1.0f);
        for (Map.Entry entry : value.entrySet()) {
            Object entryKey = OdpsTypeTransformer.transform(entry.getKey(), keyTypeInfo, strict, fieldMaxSize);
            Object entryValue = OdpsTypeTransformer.transform(entry.getValue(), valTypeInfo, strict, fieldMaxSize);
            newMap.put(entryKey, entryValue);
        }
        return newMap;
    }

    private static Struct transformStruct(Struct value, StructTypeInfo typeInfo, boolean strict, long fieldMaxSize) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int i = 0; i < typeInfo.getFieldCount(); ++i) {
            TypeInfo fieldTypeInfo = value.getFieldTypeInfo(i);
            elements.add(OdpsTypeTransformer.transform(value.getFieldValue(i), fieldTypeInfo, strict, fieldMaxSize));
        }
        return new SimpleStruct(typeInfo, elements);
    }

    static Object transform(Object value, TypeInfo typeInfo, boolean strict, long fieldMaxSize) {
        if (value == null) {
            return null;
        }
        switch (typeInfo.getOdpsType()) {
            case STRING: {
                if (value instanceof byte[]) {
                    value = ArrayRecord.bytesToString((byte[])value);
                }
                if (!strict) break;
                OdpsTypeTransformer.validateString((String)value, fieldMaxSize);
                break;
            }
            case BIGINT: {
                OdpsTypeTransformer.validateBigint((Long)value);
                break;
            }
            case DATETIME: {
                if (!strict) break;
                OdpsTypeTransformer.validateDateTime((Date)value);
                break;
            }
            case DECIMAL: {
                OdpsTypeTransformer.validateDecimal((BigDecimal)value, (DecimalTypeInfo)typeInfo);
                break;
            }
            case CHAR: {
                OdpsTypeTransformer.validateChar((Char)value, (CharTypeInfo)typeInfo);
                break;
            }
            case VARCHAR: {
                OdpsTypeTransformer.validateVarChar((Varchar)value, (VarcharTypeInfo)typeInfo);
                break;
            }
            case ARRAY: {
                return OdpsTypeTransformer.transformArray((List)value, (ArrayTypeInfo)typeInfo, strict, fieldMaxSize);
            }
            case MAP: {
                return OdpsTypeTransformer.transformMap((Map)value, (MapTypeInfo)typeInfo, strict, fieldMaxSize);
            }
            case STRUCT: {
                return OdpsTypeTransformer.transformStruct((Struct)value, (StructTypeInfo)typeInfo, strict, fieldMaxSize);
            }
            case DATE: {
                if (!(value instanceof Date)) break;
                value = ArrayRecord.dateToLocalDate((Date)value, ArrayRecord.DEFAULT_CALENDAR);
                break;
            }
        }
        return OdpsTypeTransformer.odpsTypeToJavaType(typeInfo.getOdpsType()).cast(value);
    }

    static {
        ODPS_TYPE_MAPPER.put(OdpsType.BIGINT, Long.class);
        ODPS_TYPE_MAPPER.put(OdpsType.STRING, String.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DATETIME, Date.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DOUBLE, Double.class);
        ODPS_TYPE_MAPPER.put(OdpsType.BOOLEAN, Boolean.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DECIMAL, BigDecimal.class);
        ODPS_TYPE_MAPPER.put(OdpsType.ARRAY, List.class);
        ODPS_TYPE_MAPPER.put(OdpsType.MAP, Map.class);
        ODPS_TYPE_MAPPER.put(OdpsType.STRUCT, Struct.class);
        ODPS_TYPE_MAPPER.put(OdpsType.INT, Integer.class);
        ODPS_TYPE_MAPPER.put(OdpsType.TINYINT, Byte.class);
        ODPS_TYPE_MAPPER.put(OdpsType.SMALLINT, Short.class);
        ODPS_TYPE_MAPPER.put(OdpsType.DATE, LocalDate.class);
        ODPS_TYPE_MAPPER.put(OdpsType.TIMESTAMP, Timestamp.class);
        ODPS_TYPE_MAPPER.put(OdpsType.FLOAT, Float.class);
        ODPS_TYPE_MAPPER.put(OdpsType.CHAR, Char.class);
        ODPS_TYPE_MAPPER.put(OdpsType.BINARY, Binary.class);
        ODPS_TYPE_MAPPER.put(OdpsType.VARCHAR, Varchar.class);
        ODPS_TYPE_MAPPER.put(OdpsType.INTERVAL_YEAR_MONTH, IntervalYearMonth.class);
        ODPS_TYPE_MAPPER.put(OdpsType.INTERVAL_DAY_TIME, IntervalDayTime.class);
    }
}

