/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.AbstractChar;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.IntervalDayTime;
import com.aliyun.odps.data.IntervalYearMonth;
import com.aliyun.odps.data.OdpsTypeTransformer;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.chrono.IsoChronology;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;

public class ArrayRecord
implements Record {
    private static final Long DEFAULT_FIELD_MAX_SIZE = 0x800000L;
    private static final String DEFAULT_CHARSET = "utf-8";
    static final Calendar DEFAULT_CALENDAR = new Calendar.Builder().setCalendarType("iso8601").setLenient(true).setTimeZone(TimeZone.getTimeZone("GMT")).build();
    private Column[] columns;
    private final Object[] values;
    private HashMap<String, Integer> nameMap = new HashMap();
    private boolean strictTypeValidation;
    private Long fieldMaxSize = DEFAULT_FIELD_MAX_SIZE;

    public ArrayRecord(Column[] columns) {
        this(columns, true);
    }

    public ArrayRecord(Column[] columns, boolean strictTypeValidation) {
        this(columns, strictTypeValidation, DEFAULT_FIELD_MAX_SIZE);
    }

    public ArrayRecord(Column[] columns, boolean strictTypeValidation, Long fieldMaxSize) {
        if (columns == null) {
            throw new IllegalArgumentException();
        }
        this.columns = columns;
        this.strictTypeValidation = strictTypeValidation;
        if (fieldMaxSize != null) {
            this.fieldMaxSize = fieldMaxSize;
        }
        this.values = new Object[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.nameMap.put(columns[i].getName(), i);
        }
    }

    public ArrayRecord(Column[] columns, Object[] values) {
        this(columns, values, true);
    }

    public ArrayRecord(Column[] columns, Object[] values, boolean strictTypeValidation) {
        this(columns, strictTypeValidation);
        if (values.length != columns.length) {
            throw new IllegalArgumentException("Lengths of schema and column values of the Record mismatches.");
        }
        for (int i = 0; i < columns.length; ++i) {
            this.set(i, values[i]);
        }
    }

    public ArrayRecord(TableSchema schema) {
        this(schema, true);
    }

    public ArrayRecord(TableSchema schema, boolean strictTypeValidation) {
        this(schema.getColumns().toArray(new Column[0]), strictTypeValidation);
    }

    @Override
    public int getColumnCount() {
        return this.values.length;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public void set(int idx, Object value) {
        if (this.columns[idx].getTypeInfo().getOdpsType() == OdpsType.STRING && value instanceof byte[]) {
            this.values[idx] = value;
            return;
        }
        this.values[idx] = OdpsTypeTransformer.transform(value, this.columns[idx].getTypeInfo(), this.strictTypeValidation, this.fieldMaxSize);
    }

    @Override
    public Object get(int idx) {
        return this.values[idx];
    }

    @Override
    public void set(String columnName, Object value) {
        this.set(this.getColumnIndex(columnName), value);
    }

    @Override
    public Object get(String columnName) {
        return this.values[this.getColumnIndex(columnName)];
    }

    @Override
    public void setBigint(int idx, Long value) {
        this.set(idx, (Object)value);
    }

    @Override
    public Long getBigint(int idx) {
        return (Long)this.getInternal(idx);
    }

    @Override
    public void setBigint(String columnName, Long value) {
        this.setBigint(this.getColumnIndex(columnName), value);
    }

    @Override
    public Long getBigint(String columnName) {
        return this.getBigint(this.getColumnIndex(columnName));
    }

    @Override
    public void setDouble(int idx, Double value) {
        this.set(idx, (Object)value);
    }

    @Override
    public Double getDouble(int idx) {
        return (Double)this.getInternal(idx);
    }

    @Override
    public void setDouble(String columnName, Double value) {
        this.setDouble(this.getColumnIndex(columnName), value);
    }

    @Override
    public Double getDouble(String columnName) {
        return this.getDouble(this.getColumnIndex(columnName));
    }

    @Override
    public void setBoolean(int idx, Boolean value) {
        this.set(idx, (Object)value);
    }

    @Override
    public Boolean getBoolean(int idx) {
        return (Boolean)this.getInternal(idx);
    }

    @Override
    public void setBoolean(String columnName, Boolean value) {
        this.setBoolean(this.getColumnIndex(columnName), value);
    }

    @Override
    public Boolean getBoolean(String columnName) {
        return this.getBoolean(this.getColumnIndex(columnName));
    }

    @Override
    public void setDatetime(int idx, java.util.Date value) {
        this.set(idx, (Object)value);
    }

    @Override
    public java.util.Date getDatetime(int idx) {
        return (java.util.Date)this.getInternal(idx);
    }

    @Override
    public void setDatetime(String columnName, java.util.Date value) {
        this.setDatetime(this.getColumnIndex(columnName), value);
    }

    @Override
    public java.util.Date getDatetime(String columnName) {
        return this.getDatetime(this.getColumnIndex(columnName));
    }

    @Override
    public void setDecimal(int idx, BigDecimal value) {
        this.set(idx, (Object)value);
    }

    @Override
    public BigDecimal getDecimal(int idx) {
        return (BigDecimal)this.getInternal(idx);
    }

    @Override
    public void setDecimal(String columnName, BigDecimal value) {
        this.setDecimal(this.getColumnIndex(columnName), value);
    }

    @Override
    public BigDecimal getDecimal(String columnName) {
        return this.getDecimal(this.getColumnIndex(columnName));
    }

    @Override
    public void setString(int idx, String value) {
        this.set(idx, (Object)value);
    }

    @Override
    public String getString(int idx) {
        Object obj = this.values[idx];
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return ArrayRecord.bytesToString((byte[])obj);
        }
        return (String)this.getInternal(idx);
    }

    @Override
    public void setString(String columnName, String value) {
        this.setString(this.getColumnIndex(columnName), value);
    }

    @Override
    public String getString(String columnName) {
        return this.getString(this.getColumnIndex(columnName));
    }

    @Override
    public void setString(int idx, byte[] value) {
        this.set(idx, (Object)value);
    }

    @Override
    public void setString(String columnName, byte[] value) {
        this.setString(this.getColumnIndex(columnName), value);
    }

    @Override
    public byte[] getBytes(int idx) {
        Object obj = this.values[idx];
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return ArrayRecord.stringToBytes((String)obj);
        }
        if (obj instanceof Binary) {
            return ((Binary)obj).data();
        }
        if (obj instanceof AbstractChar) {
            return ArrayRecord.stringToBytes(((AbstractChar)obj).getValue());
        }
        throw new RuntimeException("Does not support getBytes for type other than String/Binary/Char/VarChar, sees " + obj.getClass());
    }

    @Override
    public byte[] getBytes(String columnName) {
        return this.getBytes(this.getColumnIndex(columnName));
    }

    public void setBinary(int idx, Binary value) {
        this.set(idx, (Object)value);
    }

    public void setBinary(String columnName, Binary value) {
        this.setBinary(this.getColumnIndex(columnName), value);
    }

    public Binary getBinary(int idx) {
        return (Binary)this.getInternal(idx);
    }

    public Binary getBinary(String columnName) {
        return this.getBinary(this.getColumnIndex(columnName));
    }

    @Override
    public void set(Object[] values) {
        if (values == null || this.columns.length != values.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < values.length; ++i) {
            this.set(i, values[i]);
        }
    }

    @Override
    public Object[] toArray() {
        return this.values;
    }

    private int getColumnIndex(String name) {
        Integer idx = this.nameMap.get(name);
        if (idx == null) {
            throw new IllegalArgumentException("No such column:" + name);
        }
        return idx;
    }

    public void clear() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    public void setArray(String columnName, List list) {
        this.setArray(this.getColumnIndex(columnName), list);
    }

    public void setArray(int idx, List list) {
        this.set(idx, (Object)list);
    }

    public void setMap(int idx, Map map) {
        this.set(idx, (Object)map);
    }

    public void setMap(String columnName, Map map) {
        this.setMap(this.getColumnIndex(columnName), map);
    }

    public <T> List<T> getArray(Class<T> className, String columnName) {
        return this.getArray(className, this.getColumnIndex(columnName));
    }

    public <T> List<T> getArray(Class<T> className, int idx) {
        List list = this.getArray(idx);
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        for (Object obj : list) {
            if (obj instanceof String && className == byte[].class) {
                newList.add(ArrayRecord.stringToBytes((String)obj));
                continue;
            }
            newList.add(className.cast(obj));
        }
        return newList;
    }

    public List getArray(String columnName) {
        return this.getArray(this.getColumnIndex(columnName));
    }

    public List getArray(int idx) {
        return this.toCompatibleArray((ArrayTypeInfo)this.columns[idx].getTypeInfo(), (List)this.getInternal(idx));
    }

    private List toCompatibleArray(ArrayTypeInfo typeInfo, List list) {
        if (list == null) {
            return null;
        }
        TypeInfo elementTypeInfo = typeInfo.getElementTypeInfo();
        ArrayList<Object> ret = new ArrayList<Object>(list.size());
        block6: for (Object o : list) {
            if (o == null) {
                ret.add(null);
                continue;
            }
            switch (elementTypeInfo.getOdpsType()) {
                case DATE: {
                    ret.add(new Date(ArrayRecord.localDateToDate((LocalDate)o, DEFAULT_CALENDAR).getTime()));
                    continue block6;
                }
                case ARRAY: {
                    ret.add(this.toCompatibleArray((ArrayTypeInfo)elementTypeInfo, (List)o));
                    continue block6;
                }
                case MAP: {
                    ret.add(this.toCompatibleMap((MapTypeInfo)elementTypeInfo, (Map)o));
                    continue block6;
                }
                case STRUCT: {
                    ret.add(this.toCompatibleStruct((StructTypeInfo)elementTypeInfo, (Struct)o));
                    continue block6;
                }
            }
            ret.add(o);
        }
        return ret;
    }

    public <k, v> Map<k, v> getMap(Class<k> keyClass, Class<v> valueClass, String columnName) {
        return this.getMap(keyClass, valueClass, this.getColumnIndex(columnName));
    }

    public <k, v> Map<k, v> getMap(Class<k> keyClass, Class<v> valueClass, int idx) {
        Map map = this.getMap(idx);
        if (map == null || map.isEmpty()) {
            return map;
        }
        HashMap<k, v> newMap = new HashMap<k, v>(map.size(), 1.0f);
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (keyClass == byte[].class && key != null && key instanceof String) {
                key = ArrayRecord.stringToBytes((String)key);
            }
            if (valueClass == byte[].class && value != null && value instanceof String) {
                value = ArrayRecord.stringToBytes((String)value);
            }
            newMap.put(keyClass.cast(key), valueClass.cast(value));
        }
        return newMap;
    }

    public Map getMap(String columnName) {
        return this.getMap(this.getColumnIndex(columnName));
    }

    public Map getMap(int idx) {
        return this.toCompatibleMap((MapTypeInfo)this.columns[idx].getTypeInfo(), (Map)this.getInternal(idx));
    }

    private Map toCompatibleMap(MapTypeInfo typeInfo, Map map) {
        if (map == null) {
            return null;
        }
        HashMap ret = new HashMap(map.size());
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (value != null) {
                TypeInfo valueTypeInfo = typeInfo.getValueTypeInfo();
                switch (typeInfo.getValueTypeInfo().getOdpsType()) {
                    case DATE: {
                        value = new Date(ArrayRecord.localDateToDate((LocalDate)value, DEFAULT_CALENDAR).getTime());
                        break;
                    }
                    case ARRAY: {
                        value = this.toCompatibleArray((ArrayTypeInfo)valueTypeInfo, (List)value);
                        break;
                    }
                    case MAP: {
                        value = this.toCompatibleMap((MapTypeInfo)valueTypeInfo, (Map)value);
                        break;
                    }
                    case STRUCT: {
                        value = this.toCompatibleStruct((StructTypeInfo)valueTypeInfo, (Struct)value);
                    }
                }
            }
            if (key != null && OdpsType.DATE.equals((Object)typeInfo.getKeyTypeInfo().getOdpsType())) {
                key = new Date(ArrayRecord.localDateToDate((LocalDate)key, DEFAULT_CALENDAR).getTime());
            }
            ret.put(key, value);
        }
        return ret;
    }

    public void setChar(int idx, Char value) {
        this.set(idx, (Object)value);
    }

    public void setChar(String columnName, Char value) {
        this.setChar(this.getColumnIndex(columnName), value);
    }

    public Char getChar(int idx) {
        return (Char)this.getInternal(idx);
    }

    public Char getChar(String columnName) {
        return this.getChar(this.getColumnIndex(columnName));
    }

    public void setVarchar(int idx, Varchar value) {
        this.set(idx, (Object)value);
    }

    public void setVarchar(String columnName, Varchar value) {
        this.setVarchar(this.getColumnIndex(columnName), value);
    }

    public Varchar getVarchar(int idx) {
        return (Varchar)this.getInternal(idx);
    }

    public Varchar getVarchar(String columnName) {
        return this.getVarchar(this.getColumnIndex(columnName));
    }

    @Deprecated
    public void setDate(int idx, Date value) {
        this.setDate(idx, value, null);
    }

    @Deprecated
    public Date getDate(int idx) {
        return this.getDate(idx, null);
    }

    @Deprecated
    public void setDate(String columnName, Date value) {
        this.setDate(this.getColumnIndex(columnName), value);
    }

    @Deprecated
    public Date getDate(String columnName) {
        return this.getDate(this.getColumnIndex(columnName));
    }

    public void setDate(String columnName, Date value, Calendar calendar) {
        this.setDate(this.getColumnIndex(columnName), value, calendar);
    }

    public Date getDate(String columnName, Calendar calendar) {
        return this.getDate(this.getColumnIndex(columnName), calendar);
    }

    public void setDate(int idx, Date value, Calendar calendar) {
        if (value != null) {
            this.set(idx, (Object)ArrayRecord.dateToLocalDate(value, Optional.ofNullable(calendar).orElse(DEFAULT_CALENDAR)));
        } else {
            this.set(idx, null);
        }
    }

    public Date getDate(int idx, Calendar calendar) {
        java.util.Date date = ArrayRecord.localDateToDate((LocalDate)this.getInternal(idx), Optional.ofNullable(calendar).orElse(DEFAULT_CALENDAR));
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    private void setDateAsLocalDate(int columnIdx, LocalDate localDate) {
        this.set(columnIdx, (Object)localDate);
    }

    private void setDateAsLocalDate(String columnName, LocalDate localDate) {
        this.setDateAsLocalDate(this.getColumnIndex(columnName), localDate);
    }

    private LocalDate getDateAsLocalDate(int columnIdx) {
        return (LocalDate)this.getInternal(columnIdx);
    }

    private LocalDate getDateAsLocalDate(String columnName) {
        return this.getDateAsLocalDate(this.getColumnIndex(columnName));
    }

    public void setTimestamp(int idx, Timestamp value) {
        this.set(idx, (Object)value);
    }

    public Timestamp getTimestamp(int idx) {
        return (Timestamp)this.getInternal(idx);
    }

    public void setTimestamp(String columnName, Timestamp value) {
        this.setTimestamp(this.getColumnIndex(columnName), value);
    }

    public Timestamp getTimestamp(String columnName) {
        return this.getTimestamp(this.getColumnIndex(columnName));
    }

    public void setFloat(int idx, Float value) {
        this.set(idx, (Object)value);
    }

    public void setFloat(String columnName, Float value) {
        this.setFloat(this.getColumnIndex(columnName), value);
    }

    public Float getFloat(int idx) {
        return (Float)this.getInternal(idx);
    }

    public Float getFloat(String columnName) {
        return this.getFloat(this.getColumnIndex(columnName));
    }

    public void setInt(int idx, Integer value) {
        this.set(idx, (Object)value);
    }

    public void setInt(String columnName, Integer value) {
        this.setInt(this.getColumnIndex(columnName), value);
    }

    public Integer getInt(int idx) {
        return (Integer)this.getInternal(idx);
    }

    public Integer getInt(String columnName) {
        return this.getInt(this.getColumnIndex(columnName));
    }

    public void setTinyint(int idx, Byte value) {
        this.set(idx, (Object)value);
    }

    public void setTinyint(String columnName, Byte value) {
        this.setTinyint(this.getColumnIndex(columnName), value);
    }

    public Byte getTinyint(int idx) {
        return (Byte)this.getInternal(idx);
    }

    public Byte getTinyint(String columnName) {
        return this.getTinyint(this.getColumnIndex(columnName));
    }

    public void setSmallint(int idx, Short value) {
        this.set(idx, (Object)value);
    }

    public void setSmallint(String columnName, Short value) {
        this.setSmallint(this.getColumnIndex(columnName), value);
    }

    public Short getSmallint(int idx) {
        return (Short)this.getInternal(idx);
    }

    public Short getSmallint(String columnName) {
        return this.getSmallint(this.getColumnIndex(columnName));
    }

    public void setStruct(int idx, Struct value) {
        this.set(idx, (Object)value);
    }

    public void setStruct(String columnName, Struct value) {
        this.setStruct(this.getColumnIndex(columnName), value);
    }

    public Struct getStruct(int idx) {
        return this.toCompatibleStruct((StructTypeInfo)this.columns[idx].getTypeInfo(), (Struct)this.getInternal(idx));
    }

    private Struct toCompatibleStruct(StructTypeInfo typeInfo, Struct struct) {
        if (struct == null) {
            return null;
        }
        ArrayList<Object> values = new ArrayList<Object>(struct.getFieldCount());
        List<TypeInfo> fieldTypeInfos = typeInfo.getFieldTypeInfos();
        for (int i = 0; i < typeInfo.getFieldCount(); ++i) {
            TypeInfo fieldTypeInfo = fieldTypeInfos.get(i);
            Object o = struct.getFieldValue(i);
            if (o == null) {
                values.add(null);
                continue;
            }
            switch (fieldTypeInfo.getOdpsType()) {
                case DATE: {
                    o = new Date(ArrayRecord.localDateToDate((LocalDate)o, DEFAULT_CALENDAR).getTime());
                    break;
                }
                case ARRAY: {
                    o = this.toCompatibleArray((ArrayTypeInfo)fieldTypeInfo, (List)o);
                    break;
                }
                case MAP: {
                    o = this.toCompatibleMap((MapTypeInfo)fieldTypeInfo, (Map)o);
                    break;
                }
                case STRUCT: {
                    o = this.toCompatibleStruct((StructTypeInfo)fieldTypeInfo, (Struct)o);
                    break;
                }
            }
            values.add(o);
        }
        return new SimpleStruct(typeInfo, values);
    }

    public Struct getStruct(String columnName) {
        return this.getStruct(this.getColumnIndex(columnName));
    }

    public IntervalYearMonth getIntervalYearMonth(int idx) {
        return (IntervalYearMonth)this.getInternal(idx);
    }

    public IntervalYearMonth getIntervalYearMonth(String columnName) {
        return this.getIntervalYearMonth(this.getColumnIndex(columnName));
    }

    public void setIntervalYearMonth(int idx, IntervalYearMonth value) {
        this.set(idx, (Object)value);
    }

    public void setIntervalYearMonth(String columnName, IntervalYearMonth value) {
        this.setIntervalYearMonth(this.getColumnIndex(columnName), value);
    }

    public IntervalDayTime getIntervalDayTime(int idx) {
        return (IntervalDayTime)this.getInternal(idx);
    }

    public IntervalDayTime getIntervalDayTime(String columnName) {
        return this.getIntervalDayTime(this.getColumnIndex(columnName));
    }

    public void setIntervalDayTime(int idx, IntervalDayTime value) {
        this.set(idx, (Object)value);
    }

    public void setIntervalDayTime(String columnName, IntervalDayTime value) {
        this.setIntervalDayTime(this.getColumnIndex(columnName), value);
    }

    @Override
    public boolean isNull(int idx) {
        return this.values[idx] == null;
    }

    @Override
    public boolean isNull(String columnName) {
        return this.isNull(this.getColumnIndex(columnName));
    }

    @Override
    public Record clone() {
        ArrayRecord record = new ArrayRecord(this.getColumns());
        record.set(this.values);
        return record;
    }

    protected <T> T getInternal(int idx) {
        if (this.values[idx] == null) {
            return null;
        }
        return (T)this.values[idx];
    }

    public void setWithoutValidation(int idx, Object o) {
        this.values[idx] = o;
    }

    static String bytesToString(byte[] bytes) {
        try {
            return new String(bytes, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    static byte[] stringToBytes(String string) {
        try {
            return string.getBytes(DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    static java.util.Date localDateToDate(LocalDate localDate, Calendar calendar) {
        if (localDate != null) {
            calendar = (Calendar)calendar.clone();
            calendar.clear();
            calendar.set(localDate.getYear(), localDate.getMonth().getValue() - 1, localDate.getDayOfMonth());
            return calendar.getTime();
        }
        return null;
    }

    static LocalDate dateToLocalDate(java.util.Date date, Calendar calendar) {
        if (date != null) {
            calendar = (Calendar)calendar.clone();
            calendar.clear();
            calendar.setLenient(true);
            calendar.setTime(date);
            return IsoChronology.INSTANCE.date(IsoChronology.INSTANCE.eraOf(calendar.get(0)), calendar.get(1), calendar.get(2) + 1, calendar.get(5));
        }
        return null;
    }
}

