/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class OdpsCltWrapper {
    public static Logger logger = Logger.getLogger((String)OdpsCltWrapper.class.getClass().getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String javaClassPath = System.getProperty("java.class.path");
        logger.info((Object)("OdpsCltWrapper ClassPath: " + javaClassPath));
        Class<?> sparkSubmitCls = null;
        URLClassLoader cl = null;
        Path outputDir = null;
        try {
            sparkSubmitCls = Class.forName("org.apache.spark.deploy.SparkSubmit");
            URL url = sparkSubmitCls.getProtectionDomain().getCodeSource().getLocation();
            cl = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader().getParent());
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (ClassNotFoundException ex) {
            logger.info((Object)("ClassPath: " + javaClassPath + " can not found org.apache.spark.deploy.SparkSubmit, try find __spark_libs__.zip in ClassPath"));
            String sparkLibZipPath = OdpsCltWrapper.tryFindSparkLibZip(javaClassPath);
            outputDir = Files.createTempDirectory("__spark_libs__", new FileAttribute[0]);
            URL[] urls = OdpsCltWrapper.tryExtractSparkLibZip(sparkLibZipPath, outputDir.toAbsolutePath().toString());
            cl = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader().getParent());
            Thread.currentThread().setContextClassLoader(cl);
        }
        try {
            OdpsCltWrapper.setProperpiesForD2();
            sparkSubmitCls = Class.forName("org.apache.spark.deploy.SparkSubmit", true, cl);
            sparkSubmitCls.getMethod("main", String[].class).invoke(sparkSubmitCls, new Object[]{args});
        }
        finally {
            FileUtils.deleteDirectory((File)new File(outputDir.toAbsolutePath().toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL[] tryExtractSparkLibZip(String sparkLibZipPath, String extractTo) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        try (ZipFile zipFile = new ZipFile(sparkLibZipPath);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(extractTo, entry.getName());
                urls.add(entryDestination.toURI().toURL());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryDestination);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
                ((OutputStream)out).close();
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static String tryFindSparkLibZip(String javaClassPath) throws IOException {
        String[] classPaths = javaClassPath.split(":");
        Boolean findSpark2Archives = false;
        String sparkLibZipPath = "";
        for (String i : classPaths) {
            if (!i.toLowerCase().endsWith(".zip")) continue;
            ZipFile zip = new ZipFile(i);
            Enumeration<? extends ZipEntry> entrys = zip.entries();
            while (entrys.hasMoreElements()) {
                ZipEntry entry = entrys.nextElement();
                if (!entry.getName().toLowerCase().startsWith("spark-odps_2.11")) continue;
                findSpark2Archives = true;
                sparkLibZipPath = i;
                break;
            }
            zip.close();
            if (findSpark2Archives.booleanValue()) break;
        }
        if (!findSpark2Archives.booleanValue()) {
            throw new IOException("can not found __spark_libs__.zip in classpath: " + javaClassPath);
        }
        return sparkLibZipPath;
    }

    private static void setProperpiesForD2() {
        String[] keys;
        for (String key : keys = new String[]{"odps.project.name", "odps.access.id", "odps.access.key", "odps.end.point", "odps.runtime.end.point"}) {
            if (!System.getProperties().containsKey(key)) continue;
            logger.info((Object)("setProperpiesForD2 transform key " + key + " to spark.hadoop." + key));
            System.setProperty("spark.hadoop." + key, System.getProperty(key));
        }
    }
}

