/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.object.KeyTypeEnum;
import com.aliyun.opensearch.util.HttpClientManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.ClientProtocolException;

public class CloudsearchClient {
    public static final String DEFAULT_METHOD = "GET";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    private String clientId;
    private String clientSecret;
    private String baseURI;
    private String version = "v2";
    private String host;
    private KeyTypeEnum keyType = KeyTypeEnum.OPENSEARCH;
    private String accesskey;
    private String secret;
    private final String ISO8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public CloudsearchClient(String clientId, String clientSecret, String host, Map<String, Object> opts) throws UnknownHostException {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.host = host;
        if (host == null) {
            throw new UnknownHostException();
        }
        if (opts != null && opts.size() > 0) {
            int connectTimeout;
            int timeout;
            if (opts.get("version") != null) {
                this.version = (String)opts.get("version");
            }
            if (opts.get("gzip") != null && opts.get("gzip").equals(true)) {
                HttpClientManager.setGzip();
            }
            if (opts.get("timeout") != null && (timeout = ((Integer)opts.get("timeout")).intValue()) > 0) {
                HttpClientManager.setTimeout(timeout);
            }
            if (opts.get("connect_timeout") != null && (connectTimeout = ((Integer)opts.get("connect_timeout")).intValue()) > 0) {
                HttpClientManager.setConnectTimeout(connectTimeout);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.host.endsWith("/") ? this.host.substring(0, this.host.length() - 1) : this.host);
        this.baseURI = sb.toString();
    }

    public CloudsearchClient(String accesskey, String secret, String host, Map<String, Object> opts, KeyTypeEnum keyType) throws UnknownHostException {
        this(null, null, host, opts);
        this.accesskey = accesskey;
        this.secret = secret;
        this.keyType = keyType;
    }

    public void setMaxConnections(int maxConnections) {
        if (maxConnections > 0) {
            HttpClientManager.setMaxConnections(maxConnections);
        }
    }

    public String call(String path, Map<String, String> params, String method, boolean isPB) throws ClientProtocolException, IOException, UnknownHostException {
        return this.call(path, params, method, isPB, new StringBuffer());
    }

    public String call(String path, Map<String, String> params, String method, boolean isPB, StringBuffer debugInfo) throws ClientProtocolException, IOException, UnknownHostException {
        String uri = "";
        if (this.keyType == KeyTypeEnum.OPENSEARCH) {
            uri = "/" + this.version + "/api";
        }
        String url = this.baseURI + uri + path;
        TreeMap<String, String> parameters = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        parameters.putAll(params);
        if (this.keyType == KeyTypeEnum.OPENSEARCH) {
            parameters.put("client_id", this.clientId);
            parameters.put("nonce", this.getNonce());
            parameters.put("sign", this.doSign(parameters));
        } else if (this.keyType == KeyTypeEnum.ALIYUN) {
            parameters.put("Version", "v2");
            parameters.put("AccessKeyId", this.accesskey);
            parameters.put("Timestamp", this.formatIso8601Date(new Date()));
            parameters.put("SignatureMethod", "HMAC-SHA1");
            parameters.put("SignatureVersion", "1.0");
            parameters.put("SignatureNonce", UUID.randomUUID().toString());
            parameters.put("Signature", this.getAliyunSign(parameters, method));
        }
        if (method == null) {
            method = "GET";
        }
        debugInfo.setLength(0);
        debugInfo.append(url + this.getHTTPParamsStr(parameters));
        String result = this.doRequest(url, parameters, method, isPB);
        return result;
    }

    private String getAliyunSign(TreeMap<String, String> sortMap, String method) {
        boolean isSignMode = false;
        String items = null;
        if (sortMap.get("sign_mode") != null && sortMap.get("sign_mode").equals("1") && sortMap.containsKey("items")) {
            isSignMode = true;
            items = sortMap.get("items");
            sortMap.remove("items");
        }
        try {
            String stringToSign = this.buildQuery(sortMap);
            stringToSign = method + "&%2F&" + this.percentEncode(stringToSign);
            String ALGORITHM = "HmacSHA1";
            String ENCODING = "UTF-8";
            String accessKeySecret = this.secret + "&";
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(accessKeySecret.getBytes("UTF-8"), "HmacSHA1"));
            byte[] signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
            String signature = new String(Base64.encodeBase64((byte[])signData));
            if (isSignMode && items != null) {
                sortMap.put("items", items);
            }
            return signature;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String call(String path, Map<String, String> params, String method) throws ClientProtocolException, IOException {
        return this.call(path, params, method, false);
    }

    public String call(String path, Map<String, String> params, String method, StringBuffer debugInfo) throws ClientProtocolException, IOException, UnknownHostException {
        return this.call(path, params, method, false, debugInfo);
    }

    protected String doRequest(String url, Map<String, String> requestParams, String method, boolean isPB) throws ClientProtocolException, IOException {
        String result = "";
        if (method.equals(METHOD_POST)) {
            result = HttpClientManager.doPost(url, requestParams, "utf-8");
        } else if (method.equals("GET")) {
            url = url + this.getHTTPParamsStr(requestParams);
            result = HttpClientManager.doGet(url, "utf-8", isPB);
        }
        return result;
    }

    public String call(String path, Map<String, String> params, boolean isPB) throws ClientProtocolException, IOException {
        return this.call(path, params, "GET", isPB);
    }

    protected String getHTTPParamsStr(Map<String, String> params) {
        if (params == null || params.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String value = null;
            String key = null;
            try {
                key = this.percentEncode(entry.getKey());
                value = this.percentEncode(entry.getValue());
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            sb.append("&").append(key).append("=").append(value);
        }
        return "?" + sb.substring(1);
    }

    private String getNonce() {
        long timestemp = System.currentTimeMillis() / 1000L;
        String signStr = this.clientId + this.clientSecret + timestemp;
        byte[] bytes = null;
        try {
            bytes = signStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return DigestUtils.md5Hex((byte[])bytes) + "." + timestemp;
    }

    private String doSign(TreeMap<String, String> sortMap) {
        boolean isSignMode = false;
        String items = null;
        if (sortMap.get("sign_mode") != null && sortMap.get("sign_mode").equals("1") && sortMap.containsKey("items")) {
            isSignMode = true;
            items = sortMap.get("items");
            sortMap.remove("items");
        }
        byte[] bytes = null;
        try {
            bytes = (this.buildQuery(sortMap) + this.clientSecret).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String md5 = DigestUtils.md5Hex(bytes);
        if (isSignMode && items != null) {
            sortMap.put("items", items);
        }
        return md5;
    }

    private String buildQuery(TreeMap<String, String> sortMap) {
        StringBuilder query = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : sortMap.entrySet()) {
                query.append("&").append(this.percentEncode(entry.getKey())).append("=").append(this.percentEncode(entry.getValue()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return query.substring(1);
    }

    private String percentEncode(String value) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    private String formatIso8601Date(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return df.format(date);
    }
}

