/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.CloudsearchClient;
import com.aliyun.opensearch.object.DocItems;
import com.aliyun.opensearch.object.SingleDoc;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.http.client.ClientProtocolException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CloudsearchDoc {
    public static final String DOC_ADD = "add";
    public static final String DOC_REMOVE = "delete";
    public static final String DOC_UPDATE = "update";
    public static final String PUSH_RETURN_STATUS_OK = "OK";
    public static final int SIGN_MODE = 1;
    public static final int PUSH_FREQUENCE = 5;
    public static final int PUSH_MAX_SIZE = 0x200000;
    public static final String HA_DOC_ITEM_SEPARATOR = "\u001e";
    public static final String HA_DOC_FIELD_SEPARATOR = "\u001f";
    public static final String HA_DOC_MULTI_VALUE_SEPARATOR = "\u001d";
    public static final String HA_DOC_SECTION_WEIGHT = "\u001c";
    private String indexName;
    private CloudsearchClient client;
    private String path;
    private JSONArray requestArray = new JSONArray();
    private StringBuffer debugInfo = new StringBuffer();

    public CloudsearchDoc(String indexName, CloudsearchClient client) {
        this.indexName = indexName;
        this.client = client;
        this.path = "/index/doc/" + this.indexName;
    }

    public String detail(String docId) throws ClientProtocolException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", docId);
        return this.client.call(this.path, params, "POST", this.debugInfo);
    }

    public void add(Map<String, Object> fields) throws JSONException {
        JSONObject JSONFields = new JSONObject();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            JSONFields.put(entry.getKey(), entry.getValue());
        }
        JSONObject json = new JSONObject();
        json.put("cmd", (Object)DOC_ADD);
        json.put("fields", (Object)JSONFields);
        this.requestArray.put((Object)json);
    }

    public void update(Map<String, Object> fields) throws JSONException {
        JSONObject JSONFields = new JSONObject();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            JSONFields.put(entry.getKey(), entry.getValue());
        }
        JSONObject json = new JSONObject();
        json.put("cmd", (Object)DOC_UPDATE);
        json.put("fields", (Object)JSONFields);
        this.requestArray.put((Object)json);
    }

    public void remove(Map<String, Object> fields) throws JSONException {
        JSONObject JSONFields = new JSONObject();
        for (Map.Entry<String, Object> entry : fields.entrySet()) {
            JSONFields.put(entry.getKey(), entry.getValue());
        }
        JSONObject json = new JSONObject();
        json.put("cmd", (Object)DOC_REMOVE);
        json.put("fields", (Object)JSONFields);
        this.requestArray.put((Object)json);
    }

    public String push(String tableName) throws ClientProtocolException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "push");
        params.put("items", this.requestArray.toString());
        params.put("table_name", tableName);
        params.put("sign_mode", String.valueOf(1));
        String result = this.client.call(this.path, params, "POST", this.debugInfo);
        this.requestArray = new JSONArray();
        return result;
    }

    public String push(String docs, String tableName) throws ClientProtocolException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "push");
        params.put("items", docs);
        params.put("table_name", tableName);
        params.put("sign_mode", String.valueOf(1));
        return this.client.call(this.path, params, "POST", this.debugInfo);
    }

    public String pushHADocFile(String filePath, String tableName) throws JSONException {
        return this.pushHADocFile(filePath, tableName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pushHADocFile(String filePath, String tableName, long offset) throws JSONException {
        BufferedReader reader = null;
        DocItems docItems = new DocItems();
        SingleDoc singleDoc = new SingleDoc();
        int lineNumber = 1;
        int lastLineNumber = 0;
        String lastField = "";
        String lastKey = "";
        long totalSize = 0L;
        LinkedList<Long> timeLimitQueue = new LinkedList<Long>();
        long time = System.currentTimeMillis();
        timeLimitQueue.offer(time);
        String result = null;
        try {
            reader = new BufferedReader(new FileReader(new File(filePath)));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((long)lineNumber < offset) {
                    ++lineNumber;
                    continue;
                }
                String separator = line.substring(line.length() - 1);
                if (separator.equals(HA_DOC_ITEM_SEPARATOR)) {
                    lastField = "";
                    String jsonString = singleDoc.getJSONObject().toString();
                    int currentSize = URLEncoder.encode(jsonString, "utf-8").getBytes().length;
                    if ((long)currentSize + (totalSize = (long)URLEncoder.encode(docItems.getJSONString(), "utf-8").getBytes().length) >= 0x200000L) {
                        this.timeLimitCheck(timeLimitQueue);
                        result = this.push(docItems.getJSONString(), tableName);
                        JSONObject resultJSON = new JSONObject(result);
                        if (!resultJSON.has("status") || !PUSH_RETURN_STATUS_OK.equals(resultJSON.get("status"))) {
                            String string = "last put not OK , line " + lastLineNumber;
                            return string;
                        }
                        lastLineNumber = lineNumber;
                        docItems = new DocItems();
                    }
                    docItems.addDoc(singleDoc);
                    singleDoc = new SingleDoc();
                } else if (separator.equals(HA_DOC_FIELD_SEPARATOR)) {
                    String detail = line.substring(0, line.length() - 1);
                    if (this.isNotBlank(lastField)) {
                        singleDoc.addField(lastKey, lastField + detail);
                    } else {
                        int middleIndex = detail.indexOf("=");
                        if (middleIndex > 0) {
                            String key = detail.substring(0, middleIndex);
                            String value = detail.substring(middleIndex + 1);
                            if ("CMD".equals(key)) {
                                singleDoc.setCmd(value);
                            } else {
                                singleDoc.addField(key, value);
                            }
                        }
                    }
                    lastField = "";
                } else if (this.isNotBlank(lastField)) {
                    lastField = lastField + line;
                }
                ++lineNumber;
            }
            result = this.push(docItems.getJSONString(), tableName);
        }
        catch (Exception e) {
            String string = "Exception" + e.getMessage() + "\tlastLineNumber:" + lastLineNumber;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    private void timeLimitCheck(Queue<Long> timeLimitQueue) {
        if (timeLimitQueue.size() < 5) {
            timeLimitQueue.offer(System.currentTimeMillis());
        } else {
            long firstTime = timeLimitQueue.poll();
            long currentTime = System.currentTimeMillis();
            if (currentTime - firstTime < 1000L) {
                try {
                    Thread.sleep(currentTime - firstTime);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            timeLimitQueue.offer(System.currentTimeMillis());
        }
    }

    private boolean isNotBlank(String str) {
        return str != null && !str.trim().equals("");
    }

    public String getDebugInfo() {
        return this.debugInfo.toString();
    }
}

