/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.CloudsearchClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.ClientProtocolException;
import org.json.JSONException;
import org.json.JSONObject;

public class CloudsearchIndex {
    private CloudsearchClient client;
    private String indexName;
    private String path;
    private StringBuffer debugInfo = new StringBuffer();

    public CloudsearchIndex(String indexName, CloudsearchClient client) {
        this.indexName = indexName;
        this.client = client;
        this.path = "/index/" + this.indexName;
    }

    public String createByTemplateName(String templateName, Map<String, String> opts) throws ClientProtocolException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "create");
        params.put("template", templateName);
        if (opts != null && opts.get("desc") != null) {
            params.put("index_des", opts.get("desc"));
        }
        if (opts != null && opts.get("package_id") != null) {
            params.put("package_id", opts.get("package_id"));
        }
        return this.client.call(this.path, params, "GET", this.debugInfo);
    }

    public String createByTemplateName(String templateName) throws ClientProtocolException, IOException {
        return this.createByTemplateName(templateName, new HashMap<String, String>());
    }

    public String rename(String toIndexName, Map<String, String> opts) throws JSONException, ClientProtocolException, IOException {
        String result;
        JSONObject jsonResult;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "update");
        params.put("new_index_name", toIndexName);
        if (opts != null && opts.get("desc") != null) {
            params.put("description", opts.get("desc"));
        }
        if ((jsonResult = new JSONObject(result = this.client.call(this.path, params, "GET", this.debugInfo))) != null && jsonResult.getString("status").equals("OK")) {
            this.indexName = toIndexName;
            this.path = "/index/" + this.indexName;
        }
        return result;
    }

    public String delete() throws ClientProtocolException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "delete");
        return this.client.call(this.path, params, "GET", this.debugInfo);
    }

    public String status() throws ClientProtocolException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "status");
        return this.client.call(this.path, params, "GET", this.debugInfo);
    }

    public String listIndexes(Integer page, Integer pageSize) throws ClientProtocolException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", page == null ? "1" : String.valueOf(page));
        params.put("page_size", pageSize == null ? "10" : String.valueOf(pageSize));
        return this.client.call("/index", params, "GET", this.debugInfo);
    }

    public String createTask(String operate, String tableName, boolean needBuild) throws ClientProtocolException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "createTask");
        params.put("operate", operate);
        if (tableName != null) {
            params.put("table_name", tableName);
        } else {
            params.put("table_name", "");
        }
        params.put("need_build", needBuild ? "1" : "0");
        return this.client.call(this.path, params, "GET", this.debugInfo);
    }

    public String createBuildTask() throws ClientProtocolException, IOException {
        return this.createTask("build", "", false);
    }

    public String createImportTask(String tableName, boolean needBuild) throws ClientProtocolException, IOException {
        return this.createTask("import", tableName, needBuild);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getErrorMessage(int page, int pageSize) throws ClientProtocolException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", String.valueOf(page));
        params.put("page_size", String.valueOf(pageSize));
        return this.client.call("/index/error/" + this.indexName, params, "GET", this.debugInfo);
    }

    public String getDebugInfo() {
        return this.debugInfo.toString();
    }
}

