/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch;

import com.aliyun.opensearch.CloudsearchClient;
import com.aliyun.opensearch.object.SearchTypeEnum;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.ClientProtocolException;

public class CloudsearchSearch {
    public static final String SORT_INCREASE = "+";
    public static final String SORT_DECREASE = "-";
    private CloudsearchClient client;
    private List<String> indexes = new ArrayList<String>();
    private Map<String, Map<String, Object>> summary = new HashMap<String, Map<String, Object>>();
    private static final String KEY_FORMAT = "format";
    private static final String KEY_START = "start";
    private static final String KEY_HITS = "hit";
    private static final String KEY_RERANKSIZE = "rerank_size";
    private static final String SEARCH_TYPE_SCAN = "scan";
    private Map<String, Object> configMap = new HashMap<String, Object>();
    private Map<String, String> sort = new LinkedHashMap<String, String>();
    private String filter = null;
    private Map<String, String> customParams = new HashMap<String, String>();
    private List<Map<String, Object>> aggregate = new ArrayList<Map<String, Object>>();
    private Map<String, Map<String, Object>> distinct = new LinkedHashMap<String, Map<String, Object>>();
    private List<String> fetches = new ArrayList<String>();
    private String query;
    private String formulaName = "";
    private String firstFormulaName = "";
    private String path = "/search";
    private String kvpair = "";
    private StringBuffer debugInfo = new StringBuffer();
    private List<String> qp = new ArrayList<String>();
    private Map<String, Object> disable = new HashMap<String, Object>();
    private String scroll = "";
    private String searchType = "";
    private String scrollId = "";

    public CloudsearchSearch(CloudsearchClient client) {
        this.client = client;
        this.initCustomConfigMap();
    }

    private void initCustomConfigMap() {
        this.configMap.put(KEY_FORMAT, "xml");
        this.configMap.put(KEY_START, 0);
        this.configMap.put(KEY_HITS, 20);
        this.configMap.put(KEY_RERANKSIZE, 200);
    }

    public String search(Map<String, Object> opts) throws ClientProtocolException, IOException, UnknownHostException {
        this.extract(opts, SearchTypeEnum.SEARCH);
        return this.call(SearchTypeEnum.SEARCH);
    }

    public String search() throws ClientProtocolException, IOException {
        return this.search(new HashMap<String, Object>());
    }

    public String scroll(Map<String, Object> opts) throws ClientProtocolException, UnknownHostException, IOException {
        this.extract(opts, SearchTypeEnum.SCROLL);
        return this.call(SearchTypeEnum.SCROLL);
    }

    public String scroll() throws ClientProtocolException, UnknownHostException, IOException {
        return this.scroll(new HashMap<String, Object>());
    }

    public void addIndex(List<String> indexes) {
        this.indexes = indexes;
    }

    public void addIndex(String indexName) {
        if (this.indexes.indexOf(indexName) == -1) {
            this.indexes.add(indexName);
        }
    }

    public void removeIndex(String indexName) {
        int index = -1;
        index = this.indexes.indexOf(indexName);
        if (index != -1) {
            this.indexes.remove(index);
        }
    }

    public List<String> getSearchIndexes() {
        return this.indexes;
    }

    public void setFormulaName(String formulaName) {
        this.formulaName = formulaName;
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public void setFirstFormulaName(String formulaName) {
        this.firstFormulaName = formulaName;
    }

    public String getFirstFormulaName() {
        return this.firstFormulaName;
    }

    public boolean addSummary(String fieldName, Integer len, String element, String ellipsis, Integer snippet) {
        if (fieldName == null || fieldName.equals("")) {
            return false;
        }
        HashMap<String, Object> summaryMap = new HashMap<String, Object>();
        summaryMap.put("summary_field", fieldName);
        if (len != null) {
            summaryMap.put("summary_len", len);
        }
        if (element != null) {
            summaryMap.put("summary_element", element);
        }
        if (ellipsis != null) {
            summaryMap.put("summary_ellipsis", ellipsis);
        }
        if (snippet != null) {
            summaryMap.put("summary_snippet", snippet);
        }
        this.summary.put(fieldName, summaryMap);
        return true;
    }

    public boolean addSummary(String fieldName) {
        return this.addSummary(fieldName, null, null, null, null);
    }

    public boolean addSummary(String fieldName, Integer len, String ellipsis, Integer snippet, String elementPrefix, String elementPostfix) {
        if (fieldName == null || fieldName.equals("")) {
            return false;
        }
        HashMap<String, Object> summaryMap = new HashMap<String, Object>();
        summaryMap.put("summary_field", fieldName);
        summaryMap.put("summary_len", len == null ? 0 : len);
        summaryMap.put("summary_ellipsis", ellipsis == null ? "" : ellipsis);
        summaryMap.put("summary_snippet", snippet == null ? 0 : snippet);
        summaryMap.put("summary_element_prefix", elementPrefix == null ? "" : elementPrefix);
        summaryMap.put("summary_element_postfix", elementPostfix == null ? "" : elementPostfix);
        this.summary.put(fieldName, summaryMap);
        return true;
    }

    public Map<String, Map<String, Object>> getSummary() {
        return this.summary;
    }

    public Map<String, Object> getSummary(String fieldName) {
        Map<String, Object> specialSummary = new HashMap<String, Object>();
        if (this.summary.containsKey(fieldName)) {
            specialSummary = this.summary.get(fieldName);
        }
        return specialSummary;
    }

    public String getSummaryString() {
        StringBuilder summaryStr = new StringBuilder();
        if (this.getSummary().size() > 0) {
            for (Map<String, Object> item : this.getSummary().values()) {
                StringBuilder summarySubStr = new StringBuilder();
                for (Map.Entry<String, Object> entry : item.entrySet()) {
                    summarySubStr.append(",").append(entry.getKey()).append(":").append(entry.getValue());
                }
                summaryStr.append(";").append(summarySubStr.substring(1));
            }
            return summaryStr.substring(1);
        }
        return summaryStr.toString();
    }

    public void setFormat(String format) {
        this.configMap.put(KEY_FORMAT, format);
    }

    public String getFormat() {
        return String.valueOf(this.configMap.get(KEY_FORMAT));
    }

    public void setStartHit(int start) {
        this.configMap.put(KEY_START, start);
    }

    public int getStartHit() {
        try {
            int startHit = Integer.valueOf(this.configMap.get(KEY_START).toString());
            return startHit;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setHits(int hits) {
        if (hits < 0) {
            hits = 0;
        }
        this.configMap.put(KEY_HITS, hits);
    }

    public int getHits() {
        try {
            int hits = Integer.valueOf(this.configMap.get(KEY_HITS).toString());
            return hits;
        }
        catch (Exception exception) {
            return 20;
        }
    }

    public void addSort(String field, String sortChar) {
        this.sort.put(field, sortChar);
    }

    public void addSort(String field) {
        this.addSort(field, SORT_DECREASE);
    }

    public void removeSort(String field) {
        if (this.sort.size() > 0 && this.sort.containsKey(field)) {
            this.sort.remove(field);
        }
    }

    public Map<String, String> getSort() {
        return this.sort;
    }

    public String getSortString() {
        StringBuilder sortStr = new StringBuilder();
        if (this.sort.size() > 0) {
            for (Map.Entry<String, String> entry : this.sort.entrySet()) {
                sortStr.append(";").append(entry.getValue()).append(entry.getKey());
            }
            return sortStr.substring(1);
        }
        return sortStr.toString();
    }

    public void addCustomParam(String paramKey, String paramValue) {
        this.customParams.put(paramKey, paramValue);
    }

    public Map<String, String> getCustomParam() {
        return this.customParams;
    }

    public void addFilter(String filter, String operator) {
        if (operator == null) {
            operator = "AND";
        }
        this.filter = this.filter == null ? filter : this.filter + (" " + operator + " " + filter);
    }

    public void addFilter(String filter) {
        this.addFilter(filter, "AND");
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean addAggregate(String groupKey, String aggFun, String range, String maxGroup, String aggFilter, String aggSamplerThresHold, String aggSamplerStep) {
        if (groupKey == null || aggFun == null) {
            return false;
        }
        HashMap<String, String> aggregate = new HashMap<String, String>();
        aggregate.put("group_key", groupKey);
        aggregate.put("agg_fun", aggFun);
        if (range != null) {
            aggregate.put("range", range);
        }
        if (maxGroup != null) {
            aggregate.put("max_group", maxGroup);
        }
        if (aggFilter != null) {
            aggregate.put("agg_filter", aggFilter);
        }
        if (aggSamplerThresHold != null) {
            aggregate.put("agg_sampler_threshold", aggSamplerThresHold);
        }
        if (aggSamplerStep != null) {
            aggregate.put("agg_sampler_step", aggSamplerStep);
        }
        this.aggregate.add(aggregate);
        return true;
    }

    public boolean addAggregate(String groupKey, String aggFun) {
        return this.addAggregate(groupKey, aggFun, null, null, null, null, null);
    }

    public List<Map<String, Object>> getAggregate() {
        return this.aggregate;
    }

    public String getAggregateString() {
        StringBuilder aggregateStr = new StringBuilder();
        if (this.getAggregate() != null && this.getAggregate().size() > 0) {
            for (int i = 0; i < this.getAggregate().size(); ++i) {
                StringBuilder aggregateSubStr = new StringBuilder();
                for (Map.Entry<String, Object> entry : this.getAggregate().get(i).entrySet()) {
                    aggregateSubStr.append(",").append(entry.getKey()).append(":").append(entry.getValue());
                }
                aggregateStr.append(";").append(aggregateSubStr.substring(1));
            }
            return aggregateStr.substring(1);
        }
        return aggregateStr.toString();
    }

    public boolean addDistinct(String key, int distCount, int distTimes, String reserved, String distFilter, String updateTotalHit, double grade) {
        if (key == null) {
            return false;
        }
        LinkedHashMap<String, Object> distinct = new LinkedHashMap<String, Object>();
        distinct.put("dist_key", key);
        if (distCount > 0) {
            distinct.put("dist_count", distCount);
        }
        if (distTimes > 0) {
            distinct.put("dist_times", distTimes);
        }
        if (reserved != null) {
            distinct.put("reserved", reserved);
        }
        if (distFilter != null) {
            distinct.put("dist_filter", distFilter);
        }
        if (updateTotalHit != null) {
            distinct.put("update_total_hit", updateTotalHit);
        }
        if (grade > 0.0) {
            distinct.put("grade", grade);
        }
        this.distinct.put(key, distinct);
        return true;
    }

    public boolean addDistinct(String key) {
        return this.addDistinct(key, 0, 0, null, null, null, 0.0);
    }

    public boolean addDistinct(String key, int distCount) {
        return this.addDistinct(key, distCount, 0, null, null, null, 0.0);
    }

    public boolean addDistinct(String key, int distCount, int distTimes) {
        return this.addDistinct(key, distCount, distTimes, null, null, null, 0.0);
    }

    public boolean addDistinct(String key, int distCount, int distTimes, String reserved) {
        return this.addDistinct(key, distCount, distTimes, reserved, null, null, 0.0);
    }

    public boolean addDistinct(String key, int distCount, int distTimes, String reserved, String distFilter) {
        return this.addDistinct(key, distCount, distTimes, reserved, distFilter, null, 0.0);
    }

    public boolean addDistinct(String key, int distCount, int distTimes, String reserved, String distFilter, String updateTotalHit) {
        return this.addDistinct(key, distCount, distTimes, reserved, distFilter, updateTotalHit, 0.0);
    }

    public void removeDistinct(String distinctKey) {
        if (this.getDistinct().containsKey(distinctKey)) {
            this.getDistinct().remove(distinctKey);
        }
    }

    public Map<String, Map<String, Object>> getDistinct() {
        return this.distinct;
    }

    public String getDistinctString() {
        StringBuilder distinctStr = new StringBuilder();
        if (this.getDistinct().size() > 0) {
            for (Map<String, Object> item : this.getDistinct().values()) {
                StringBuilder distinctSubStr = new StringBuilder();
                for (Map.Entry<String, Object> entry1 : item.entrySet()) {
                    distinctSubStr.append(",").append(entry1.getKey()).append(":").append(entry1.getValue());
                }
                distinctStr.append(";").append(distinctSubStr.substring(1));
            }
            return distinctStr.substring(1);
        }
        return distinctStr.toString();
    }

    public void setQueryString(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setPair(String pair) {
        this.kvpair = pair;
    }

    public String getPair() {
        return this.kvpair;
    }

    public void setRerankSize(int rerank_size) {
        this.configMap.put(KEY_RERANKSIZE, rerank_size);
    }

    public int getRerankSize() {
        try {
            int rerank_size = Integer.valueOf(this.configMap.get(KEY_RERANKSIZE).toString());
            return rerank_size;
        }
        catch (Exception exception) {
            return 200;
        }
    }

    public void addFetchFields(List<String> fields) {
        this.fetches.addAll(fields);
    }

    public void addFetchField(String field) {
        this.fetches.add(field);
    }

    public List<String> getFetchFields() {
        return this.fetches;
    }

    public void addQpName(String qpName) {
        this.qp.add(qpName);
    }

    public void addQpNames(List<String> qpNames) {
        this.qp.addAll(qpNames);
    }

    public List<String> getQpNames() {
        return this.qp;
    }

    public void addDisableFunction(String functionName, String value) {
        this.disable.put(functionName, value);
    }

    public String getDisableFunctions() {
        String result = "";
        for (Map.Entry<String, Object> entry : this.disable.entrySet()) {
            result = result + ";" + entry.getKey();
            if (String.valueOf(entry.getValue()).length() <= 0) continue;
            result = result + ":" + String.valueOf(entry.getValue());
        }
        if (result.length() > 0) {
            return result.substring(1);
        }
        return "";
    }

    public void disableQp(Map<String, ArrayList<String>> opts) {
        String processorConfig = "";
        String processor = "";
        String indexNames = "";
        for (Map.Entry<String, ArrayList<String>> entry : opts.entrySet()) {
            processor = entry.getKey();
            indexNames = "";
            if (!entry.getValue().isEmpty()) {
                indexNames = ":";
                indexNames = indexNames + this.getIndexInQp(entry.getValue());
            }
            processor = processor + indexNames;
            processorConfig = processorConfig + "," + processor;
        }
        this.disable.put("qp", processorConfig.substring(1));
    }

    private String getIndexInQp(ArrayList<String> indexes) {
        String indexNames = "";
        for (String indexName : indexes) {
            indexNames = indexNames + "|" + indexName;
        }
        if (indexNames.length() > 0) {
            return indexNames.substring(1);
        }
        return "";
    }

    public void disableQp() {
        this.disable.put("qp", "");
    }

    public void setScrollExpire(String expire) {
        this.scroll = expire;
    }

    public void setScrollExpire(int expire) {
        this.scroll = String.valueOf(expire);
    }

    public String getScrollExpire() {
        return this.scroll;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public String getSearchType() {
        return this.searchType;
    }

    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    public void clear() {
        this.aggregate.clear();
        this.customParams.clear();
        this.distinct.clear();
        this.fetches.clear();
        this.filter = null;
        this.firstFormulaName = "";
        this.formulaName = "";
        this.indexes.clear();
        this.kvpair = "";
        this.query = "";
        this.sort.clear();
        this.summary.clear();
        this.qp.clear();
        this.disable.clear();
        this.scroll = "";
        this.searchType = "";
        this.scrollId = "";
        this.initCustomConfigMap();
    }

    private void extract(Map<String, Object> opts, SearchTypeEnum type) {
        if (opts != null && opts.size() > 0) {
            Map customConfigMap;
            if (opts.containsKey("config") && opts.get("config") instanceof Map && (customConfigMap = (Map)opts.get("config")) != null) {
                for (Map.Entry entry : customConfigMap.entrySet()) {
                    this.addCustomConfig((String)entry.getKey(), entry.getValue());
                }
            }
            if (opts.get("query") != null) {
                this.setQueryString((String)opts.get("query"));
            }
            if (opts.get("filter") != null) {
                this.addFilter((String)opts.get("filter"));
            }
            if (opts.get("kvpair") != null) {
                this.setPair((String)opts.get("kvpair"));
            }
            if (opts.get("indexes") != null) {
                this.addIndex((List)opts.get("indexes"));
            }
            if (opts.get("fetch_field") != null) {
                this.addFetchFields((List)opts.get("fetch_field"));
            }
            if (opts.get(KEY_FORMAT) != null) {
                this.setFormat((String)opts.get(KEY_FORMAT));
            }
            if (opts.get("hits") != null) {
                this.setHits(Integer.valueOf(opts.get("hits").toString()));
            }
            if (opts.get(KEY_START) != null) {
                this.setStartHit(Integer.valueOf(opts.get(KEY_START).toString()));
            }
            if (opts.get("formula_name") != null) {
                this.setFormulaName((String)opts.get("formula_name"));
            }
            if (opts.get("first_formula_name") != null) {
                this.setFormulaName((String)opts.get("first_formula_name"));
            }
            if (opts.get("summary") != null) {
                this.summary = (Map)opts.get("summary");
            }
            if (opts.get("qp") != null) {
                this.addQpNames((List)opts.get("qp"));
            }
            if (opts.get("disable_qp") != null) {
                this.disableQp((Map)opts.get("disable_qp"));
            }
            if (type == SearchTypeEnum.SEARCH) {
                if (opts.get("sort") != null) {
                    this.sort = (Map)opts.get("sort");
                }
                if (opts.get("aggregate") != null) {
                    this.aggregate = (List)opts.get("aggregate");
                }
                if (opts.get("distinct") != null) {
                    this.distinct = (Map)opts.get("distinct");
                }
            } else if (type == SearchTypeEnum.SCROLL) {
                if (opts.get("scroll") != null) {
                    this.setScrollExpire(String.valueOf(opts.get("scroll")));
                }
                if (opts.get("search_type") != null) {
                    this.setSearchType(String.valueOf(opts.get("search_type")));
                }
                if (opts.get("scroll_id") != null) {
                    this.setScrollId(String.valueOf(opts.get("scroll_id")));
                }
            }
        }
    }

    private String call(SearchTypeEnum type) throws ClientProtocolException, IOException, UnknownHostException {
        Map<String, String> customParam;
        HashMap<String, String> params = new HashMap<String, String>();
        String haQuery = "";
        if (type == SearchTypeEnum.SEARCH) {
            haQuery = "config=" + this.clauseConfig() + "&&" + "query=" + (this.isNotBlank(this.getQuery()) ? this.getQuery() : "''") + (this.isNotBlank(this.getSortString()) ? "&&sort=" + this.getSortString() : "") + (this.isNotBlank(this.getFilter()) ? "&&filter=" + this.getFilter() : "") + (this.isNotBlank(this.getDistinctString()) ? "&&distinct=" + this.getDistinctString() : "") + (this.isNotBlank(this.getAggregateString()) ? "&&aggregate=" + this.getAggregateString() : "") + (this.isNotBlank(this.getPair()) ? "&&kvpairs=" + this.getPair() : "");
        } else if (type == SearchTypeEnum.SCROLL) {
            haQuery = "config=" + this.clauseConfig() + "&&" + "query=" + (this.isNotBlank(this.getQuery()) ? this.getQuery() : "''") + (this.isNotBlank(this.getFilter()) ? "&&filter=" + this.getFilter() : "") + (this.isNotBlank(this.getPair()) ? "&&kvpairs=" + this.getPair() : "");
            if (this.isNotBlank(this.getScrollExpire())) {
                params.put("scroll", this.getScrollExpire());
            }
            if (this.isNotBlank(this.getScrollId())) {
                params.put("scroll_id", this.getScrollId());
            } else {
                params.put("search_type", SEARCH_TYPE_SCAN);
            }
        }
        StringBuilder searchIndexes = new StringBuilder();
        if (this.getSearchIndexes() != null && this.getSearchIndexes().size() > 0) {
            for (String index : this.getSearchIndexes()) {
                searchIndexes.append(";").append(index);
            }
        }
        params.put("query", haQuery);
        if (searchIndexes.length() > 0) {
            params.put("index_name", searchIndexes.substring(1));
        } else {
            params.put("index_name", "");
        }
        params.put(KEY_FORMAT, this.getFormat());
        if (this.isNotBlank(this.getFormulaName())) {
            params.put("formula_name", this.getFormulaName());
        }
        if (this.isNotBlank(this.getFirstFormulaName())) {
            params.put("first_formula_name", this.getFirstFormulaName());
        }
        if (this.isNotBlank(this.getSummaryString())) {
            params.put("summary", this.getSummaryString());
        }
        if (this.getFetchFields() != null && this.getFetchFields().size() > 0) {
            StringBuilder fetchFields = new StringBuilder();
            for (String string : this.getFetchFields()) {
                fetchFields.append(";").append(string);
            }
            params.put("fetch_fields", fetchFields.substring(1));
        }
        if (this.getQpNames() != null && this.getQpNames().size() > 0) {
            StringBuilder qpNames = new StringBuilder();
            for (String string : this.getQpNames()) {
                qpNames.append(",").append(string);
            }
            params.put("qp", qpNames.substring(1));
        }
        if (this.getDisableFunctions() != null && this.getDisableFunctions().length() > 0) {
            params.put("disable", this.getDisableFunctions());
        }
        if ((customParam = this.getCustomParam()) != null && customParam.size() > 0) {
            for (Map.Entry entry : customParam.entrySet()) {
                params.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        boolean isPB = "protobuf".equals(this.getFormat());
        return this.client.call(this.path, params, "GET", isPB, this.debugInfo);
    }

    private boolean isNotBlank(String str) {
        return str != null && !str.trim().equals("");
    }

    private String clauseConfig() {
        StringBuilder sb = new StringBuilder();
        if (this.configMap != null && this.configMap.size() > 0) {
            for (Map.Entry<String, Object> entry : this.configMap.entrySet()) {
                sb.append(entry.getKey()).append(":").append(entry.getValue()).append(",");
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public void addCustomConfig(String key, Object value) {
        this.configMap.put(key, value);
    }

    public void removeCustomConfig(String key) {
        this.configMap.remove(key);
    }

    public String getDebugInfo() {
        return this.debugInfo.toString();
    }
}

