/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.object;

import com.aliyun.opensearch.object.SchemaTableField;
import com.aliyun.opensearch.type.SchemaTableFieldType;
import java.util.ArrayList;
import java.util.List;

public class SchemaTable {
    private String tableName;
    private boolean masterTable;
    private List<SchemaTableField> fieldList = new ArrayList<SchemaTableField>();

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void addField(SchemaTableField schemaTableField) {
        if (schemaTableField == null) {
            return;
        }
        if (schemaTableField.isPrimarykey()) {
            schemaTableField.setSearch(true);
            schemaTableField.addIndex(schemaTableField.getFieldName());
            if (schemaTableField.getType().getType().equals(SchemaTableFieldType.TEXT.getType())) {
                schemaTableField.setFilter(false);
                schemaTableField.setAggregate(false);
            } else if (schemaTableField.getType().getType().equals(SchemaTableFieldType.STRING.getType())) {
                schemaTableField.setFilter(false);
            }
        }
        if (schemaTableField.getType().getType().equals(SchemaTableFieldType.TEXT.getType())) {
            schemaTableField.setAggregate(false);
            schemaTableField.setFilter(false);
            if (schemaTableField.getIndexList().size() == 0) {
                schemaTableField.addIndex("default");
            } else {
                for (String indexStr : schemaTableField.getIndexList()) {
                    if (indexStr.matches("^[_a-zA-Z][a-zA-Z0-9_]*")) continue;
                    return;
                }
            }
        }
        if (schemaTableField.getType().getType().equals(SchemaTableFieldType.STRING.getType())) {
            if (!schemaTableField.isMulti()) {
                schemaTableField.setAggregate(false);
            }
            schemaTableField.setFilter(false);
            if (schemaTableField.getIndexList().size() == 0) {
                schemaTableField.addIndex(schemaTableField.getFieldName());
            } else {
                for (String indexStr : schemaTableField.getIndexList()) {
                    if (indexStr.matches("^[_a-zA-Z][a-zA-Z0-9_]*")) continue;
                    return;
                }
            }
        }
        if (schemaTableField.getType().getType().equals(SchemaTableFieldType.FLOAT.getType()) || schemaTableField.getType().getType().equals(SchemaTableFieldType.DOUBLE.getType()) || schemaTableField.getType().getBigType().equals(SchemaTableFieldType.INT8.getBigType())) {
            schemaTableField.addIndex(schemaTableField.getFieldName());
            if (!schemaTableField.isMulti()) {
                schemaTableField.setFilter(false);
            }
        }
        this.fieldList.add(schemaTableField);
    }

    public List<SchemaTableField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<SchemaTableField> fieldList) {
        this.fieldList = fieldList;
    }

    public boolean isMasterTable() {
        return this.masterTable;
    }

    public void setMasterTable(boolean masterTable) {
        this.masterTable = masterTable;
    }
}

