/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.opensearch.util;

import com.aliyun.opensearch.util.DaemonThreadFactory;
import com.aliyun.opensearch.util.IdleConnectionMonitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactory.class);
    private static final int INIT_DELAY = 5000;
    private static final int CHECK_INTERVAL = 300000;
    private int lastConnections = 50;
    private int timeout = 10000;
    private int connectTimeout = 5000;
    private boolean gzip = false;
    private String version = "v2.1.3";
    private HttpClient httpClient;
    private HttpParams params;
    private ScheduledExecutorService scheduledExeService;
    public PoolingClientConnectionManager connectionManager;

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpClientFactory(int timeout, int connectTimeout, int connections) {
        if (timeout <= 0) {
            timeout = this.timeout;
        }
        if (connectTimeout <= 0) {
            connectTimeout = this.connectTimeout;
        }
        if (connections > 0 && this.lastConnections != connections) {
            this.lastConnections = connections;
        }
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
        this.connectionManager = new PoolingClientConnectionManager(schemeRegistry);
        this.connectionManager.setMaxTotal(this.lastConnections);
        this.connectionManager.setDefaultMaxPerRoute(this.lastConnections);
        this.scheduledExeService = Executors.newScheduledThreadPool(1, new DaemonThreadFactory("Http-client-ConenctionPool-Monitor"));
        this.scheduledExeService.scheduleAtFixedRate(new IdleConnectionMonitor((ClientConnectionManager)this.connectionManager), 5000L, 300000L, TimeUnit.MILLISECONDS);
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)this.connectionManager);
        this.params = this.httpClient.getParams();
        HttpConnectionParams.setSoTimeout((HttpParams)this.params, (int)timeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.params, (int)connectTimeout);
        HttpConnectionParams.setTcpNoDelay((HttpParams)this.params, (boolean)Boolean.TRUE);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)this.params, (boolean)Boolean.FALSE);
    }

    public int getMaxConnections() {
        return this.lastConnections;
    }

    public void setGzip() {
        this.gzip = true;
    }

    public void setTimeOut(int timeout) {
        if (timeout > 0 && timeout != this.timeout) {
            this.timeout = timeout;
            HttpConnectionParams.setSoTimeout((HttpParams)this.params, (int)this.timeout);
        }
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout > 0 && connectTimeout != this.connectTimeout) {
            this.connectTimeout = connectTimeout;
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.params, (int)this.connectTimeout);
        }
    }

    public String doPost(String reqURL, Map<String, String> params, String encoding) throws ClientProtocolException, IOException {
        String responseContent = "";
        HttpPost httpPost = this.buildHttpPostRequest(reqURL, params, encoding);
        httpPost.setHeader("User-Agent", "opensearch/java sdk " + this.version);
        if (this.gzip) {
            httpPost.setHeader("Accept-Encoding", "gzip");
        }
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        this.validateResponse(response, httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            Header contentEncoding = entity.getContentEncoding();
            if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(entity);
                responseContent = EntityUtils.toString((HttpEntity)gzipEntity, (String)encoding);
            } else {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)encoding);
            }
            EntityUtils.consume((HttpEntity)entity);
        } else {
            LOG.warn("Http entity is null! request url is {},response status is {}", (Object)reqURL, (Object)response.getStatusLine());
        }
        return responseContent;
    }

    public String doGet(String url, String encoding, boolean isPB) throws ClientProtocolException, IOException {
        String result = "";
        HttpGet httpget = new HttpGet(url);
        httpget.setHeader("User-Agent", "opensearch/java sdk " + this.version);
        if (this.gzip) {
            httpget.setHeader("Accept-Encoding", "gzip");
        }
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpget);
        this.validateResponse(response, httpget);
        HttpEntity entity = response.getEntity();
        if (null != entity) {
            InputStream is;
            Header header = entity.getContentEncoding();
            if (header != null && header.getValue().equalsIgnoreCase("gzip")) {
                GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(entity);
                is = gzipEntity.getContent();
            } else {
                is = entity.getContent();
            }
            if (isPB) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] bytes = new byte[1024];
                int len = 0;
                while ((len = is.read(bytes)) != -1) {
                    byteArrayOutputStream.write(bytes, 0, len);
                }
                byte[] temp = byteArrayOutputStream.toByteArray();
                result = new String(temp, "ISO8859-1");
            } else {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                byte[] data = new byte[4096];
                int count = -1;
                while ((count = is.read(data, 0, 4096)) != -1) {
                    outStream.write(data, 0, count);
                }
                data = null;
                return new String(outStream.toByteArray(), encoding);
            }
        }
        return result;
    }

    public void shutdownIdleConnectionMonitor() {
        if (this.scheduledExeService != null) {
            this.scheduledExeService.shutdown();
        }
    }

    private HttpPost buildHttpPostRequest(String url, Map<String, String> params, String encoding) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        if (params != null) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> paramEntrys = params.entrySet();
            for (Map.Entry<String, String> entry : paramEntrys) {
                nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, encoding));
        }
        return httpPost;
    }

    private void validateResponse(HttpResponse response, HttpGet get) throws IOException {
        StatusLine status = response.getStatusLine();
        if (status.getStatusCode() >= 300) {
            LOG.warn("Did not receive successful HTTP response: status code = {}, status message = {}", (Object)status.getStatusCode(), (Object)status.getReasonPhrase());
            get.abort();
            return;
        }
    }

    private void validateResponse(HttpResponse response, HttpPost post) throws IOException {
        StatusLine status = response.getStatusLine();
        if (status.getStatusCode() >= 300) {
            LOG.warn("Did not receive successful HTTP response: status code = {}, status message = {}", (Object)status.getStatusCode(), (Object)status.getReasonPhrase());
            post.abort();
            return;
        }
    }
}

