/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.aliyun.openservices.log.common.IndexKeys;
import com.aliyun.openservices.log.common.IndexLine;
import com.aliyun.openservices.log.exception.LogException;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class Index {
    private int ttl = -1;
    private IndexKeys keys = new IndexKeys();
    private IndexLine line = new IndexLine();
    private boolean keysSet = false;
    private boolean lineSet = false;

    public Index() {
    }

    public Index(int ttl, IndexKeys keys, IndexLine line) {
        this.ttl = ttl;
        this.SetKeys(keys);
        this.SetLine(line);
    }

    public Index(Index other) {
        this.ttl = other.GetTtl();
        if (other.isKeysSet()) {
            this.SetKeys(other.GetKeys());
        }
        if (other.isLineSet()) {
            this.SetLine(other.GetLine());
        }
    }

    public boolean isKeysSet() {
        return this.keysSet;
    }

    public boolean isLineSet() {
        return this.lineSet;
    }

    public int GetTtl() {
        return this.ttl;
    }

    public void SetTtl(int ttl) {
        this.ttl = ttl;
    }

    public IndexKeys GetKeys() {
        return this.keys;
    }

    public IndexLine GetLine() {
        return this.line;
    }

    public void SetKeys(IndexKeys keys) {
        this.keysSet = true;
        this.keys = new IndexKeys(keys);
    }

    public void SetLine(IndexLine line) {
        this.lineSet = true;
        this.line = new IndexLine(line);
    }

    public JSONObject ToRequestJson() throws LogException {
        JSONObject index = new JSONObject();
        index.put((Object)"ttl", (Object)this.ttl);
        if (this.lineSet) {
            JSONObject lineDict = this.line.ToJsonObject();
            index.put((Object)"line", (Object)lineDict);
        }
        if (this.keysSet) {
            JSONObject keysDict = this.keys.ToJsonObject();
            index.put((Object)"keys", (Object)keysDict);
        }
        return index;
    }

    public String ToRequestString() throws LogException {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() throws LogException {
        JSONObject index = this.ToRequestJson();
        return index;
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            this.ttl = dict.getInt("ttl");
            if (dict.containsKey((Object)"line")) {
                JSONObject lineDict = dict.getJSONObject("line");
                this.line.FromJsonObject(lineDict);
                this.lineSet = true;
            }
            if (dict.containsKey((Object)"keys")) {
                JSONObject keysDict = dict.getJSONObject("keys");
                this.keys.FromJsonObject(keysDict);
                this.keysSet = true;
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndex", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String indexString) throws LogException {
        try {
            JSONObject dict = JSONObject.fromObject((Object)indexString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndex", e.getMessage(), e, "");
        }
    }
}

