/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.loghub.client;

import com.aliyun.openservices.log.common.Consts;
import com.aliyun.openservices.loghub.client.ITask;
import com.aliyun.openservices.loghub.client.InitTaskResult;
import com.aliyun.openservices.loghub.client.LogHubClientAdapter;
import com.aliyun.openservices.loghub.client.TaskResult;
import com.aliyun.openservices.loghub.client.config.LogHubCursorPosition;
import com.aliyun.openservices.loghub.client.interfaces.ILogHubProcessor;

public class InitializeTask
implements ITask {
    private LogHubClientAdapter mLogHubClientAdapter;
    private ILogHubProcessor mProcessor;
    private int mShardId;
    private LogHubCursorPosition mCursorPosition;
    private long mCursorStartTime = 0L;

    public InitializeTask(ILogHubProcessor processor, LogHubClientAdapter logHubClientAdapter, int shardId, LogHubCursorPosition cursorPosition, long cursorStartTime) {
        this.mProcessor = processor;
        this.mLogHubClientAdapter = logHubClientAdapter;
        this.mShardId = shardId;
        this.mCursorPosition = cursorPosition;
        this.mCursorStartTime = cursorStartTime;
    }

    @Override
    public TaskResult call() {
        try {
            this.mProcessor.initialize(this.mShardId);
            boolean is_cursor_persistent = false;
            String checkPoint = this.mLogHubClientAdapter.GetCheckPoint(this.mShardId);
            String cursor = null;
            if (checkPoint != null && checkPoint.length() > 0) {
                is_cursor_persistent = true;
                cursor = checkPoint;
            } else {
                cursor = this.mCursorPosition.equals((Object)LogHubCursorPosition.BEGIN_CURSOR) ? this.mLogHubClientAdapter.GetCursor(this.mShardId, Consts.CursorMode.BEGIN) : (this.mCursorPosition.equals((Object)LogHubCursorPosition.END_CURSOR) ? this.mLogHubClientAdapter.GetCursor(this.mShardId, Consts.CursorMode.END) : this.mLogHubClientAdapter.GetCursor(this.mShardId, this.mCursorStartTime));
            }
            return new InitTaskResult(cursor, is_cursor_persistent);
        }
        catch (Exception e) {
            return new TaskResult(e);
        }
    }
}

