/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.model;

import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.BucketList;
import com.aliyun.oss.model.ListBucketsRequest;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class BucketListTest {
    @Test
    public void testBucketList() {
        BucketList bucketList = new BucketList();
        bucketList.setPrefix("prefix");
        bucketList.setMarker("marker");
        bucketList.setMaxKeys(6);
        bucketList.setTruncated(true);
        bucketList.setNextMarker("nextMarker");
        List<Bucket> buckets = new ArrayList<Bucket>();
        Bucket bucket = new Bucket();
        bucket.setName("name");
        bucket.setLocation("osslocation");
        buckets.add(bucket);
        bucketList.setBucketList(buckets);
        Assert.assertEquals((Object)"prefix", (Object)bucketList.getPrefix());
        Assert.assertEquals((Object)"marker", (Object)bucketList.getMarker());
        Assert.assertEquals((long)6L, (long)bucketList.getMaxKeys().intValue());
        Assert.assertEquals((Object)"nextMarker", (Object)bucketList.getNextMarker());
        Assert.assertEquals((Object)true, (Object)bucketList.isTruncated());
        Assert.assertEquals((long)1L, (long)bucketList.getBucketList().size());
        buckets = bucketList.getBucketList();
        bucket = buckets.get(0);
        Assert.assertEquals((Object)"name", (Object)bucket.getName());
        Assert.assertEquals((Object)"osslocation", (Object)bucket.getLocation());
    }

    @Test
    public void testListBucketRequest() {
        ListBucketsRequest request = new ListBucketsRequest("prefix", "marker", 1000);
        Assert.assertEquals((Object)"prefix", (Object)request.getPrefix());
        Assert.assertEquals((Object)"marker", (Object)request.getMarker());
        Assert.assertEquals((Object)1000, (Object)request.getMaxKeys());
        request.setPrefix("prefix2");
        request.setMarker("marker2");
        request.setMaxKeys(1);
        Assert.assertEquals((Object)"prefix2", (Object)request.getPrefix());
        Assert.assertEquals((Object)"marker2", (Object)request.getMarker());
        Assert.assertEquals((Object)1, (Object)request.getMaxKeys());
        try {
            request.setMaxKeys(1001);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            request.setMaxKeys(-1);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

