/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;

public class DeleteObjectTest
extends TestBase {
    @Test
    public void testExistingBucketAndObject() {
        ArrayList<String> existingKeys = new ArrayList<String>();
        String existingKey = "existing-bucket-and-key";
        existingKeys.add("existing-bucket-and-key");
        if (!TestUtils.batchPutObject(secondClient, bucketName, existingKeys)) {
            Assert.fail((String)"batch put object failed");
        }
        try {
            secondClient.deleteObject(bucketName, "existing-bucket-and-key");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testExistingBucketAndNonExistentObject() {
        String nonexistentKey = "existing-bucket-and-nonexistent-key";
        try {
            secondClient.deleteObject(bucketName, "existing-bucket-and-nonexistent-key");
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNonExistentBucketAndObject() {
        String nonexistentBucketName = "nonexistent-bucket";
        String nonexistentKey = "nonexistent-bucket-and-key";
        try {
            secondClient.deleteObject("nonexistent-bucket", "nonexistent-bucket-and-key");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
        }
    }
}

