/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestConfig;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class GetObjectTest
extends TestBase {
    @Ignore
    public void testGetSmallFileConcurrently() throws Exception {
        AtomicInteger completedCounter;
        block12: {
            int totalCompleted;
            int threadCount = 100;
            String keyPrefix = "get-small-file-concurrently-";
            final String filePath = TestUtils.genFixedLengthFile(1024L);
            completedCounter = new AtomicInteger(0);
            try {
                try {
                    Thread[] putThreads = new Thread[100];
                    int i = 0;
                    while (i < 100) {
                        final int seqNum = i;
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    secondClient.putObject(bucketName, TestUtils.buildObjectKey("get-small-file-concurrently-", seqNum), new File(filePath));
                                    completedCounter.incrementAndGet();
                                }
                                catch (Exception ex) {
                                    Assert.fail((String)ex.getMessage());
                                }
                            }
                        };
                        putThreads[i] = new Thread(r);
                        ++i;
                    }
                    TestUtils.waitAll(putThreads);
                }
                catch (Exception ex) {
                    Assert.fail((String)ex.getMessage());
                    TestUtils.removeFile(filePath);
                    totalCompleted = completedCounter.get();
                    Assert.assertEquals((int)100, (int)totalCompleted);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                TestUtils.removeFile(filePath);
                int totalCompleted2 = completedCounter.get();
                Assert.assertEquals((int)100, (int)totalCompleted2);
                throw throwable;
            }
            TestUtils.removeFile(filePath);
            totalCompleted = completedCounter.get();
            Assert.assertEquals((int)100, (int)totalCompleted);
        }
        completedCounter.set(0);
        TestUtils.ensureDirExist(TestConfig.DOWNLOAD_DIRECOTRY);
        final ArrayList<File> downloadFiles = new ArrayList<File>();
        final ReentrantLock lock = new ReentrantLock();
        try {
            try {
                Thread[] getThreads = new Thread[100];
                int i = 0;
                while (i < 100) {
                    final int seqNum = i;
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String key = TestUtils.buildObjectKey("get-small-file-concurrently-", seqNum);
                                GetObjectRequest request = new GetObjectRequest(bucketName, key);
                                File file = new File(String.valueOf(TestConfig.DOWNLOAD_DIRECOTRY) + key);
                                file.createNewFile();
                                try {
                                    lock.lock();
                                    downloadFiles.add(file);
                                }
                                finally {
                                    lock.unlock();
                                }
                                secondClient.getObject(request, file);
                                completedCounter.incrementAndGet();
                            }
                            catch (Exception ex) {
                                Assert.fail((String)ex.getMessage());
                            }
                        }
                    };
                    getThreads[i] = new Thread(r);
                    ++i;
                }
                TestUtils.waitAll(getThreads);
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                TestUtils.removeFiles(downloadFiles);
                int totalCompleted = completedCounter.get();
                Assert.assertEquals((int)100, (int)totalCompleted);
            }
        }
        finally {
            TestUtils.removeFiles(downloadFiles);
            int totalCompleted = completedCounter.get();
            Assert.assertEquals((int)100, (int)totalCompleted);
        }
    }

    @Ignore
    public void testGetMediumFileConcurrently() throws Exception {
        AtomicInteger completedCounter;
        block12: {
            int totalCompleted;
            int threadCount = 100;
            String keyPrefix = "get-medium-file-concurrently-";
            final String filePath = TestUtils.genFixedLengthFile(0x10000000L);
            completedCounter = new AtomicInteger(0);
            try {
                try {
                    Thread[] putThreads = new Thread[100];
                    int i = 0;
                    while (i < 100) {
                        final int seqNum = i;
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    secondClient.putObject(bucketName, TestUtils.buildObjectKey("get-medium-file-concurrently-", seqNum), new File(filePath));
                                    completedCounter.incrementAndGet();
                                }
                                catch (Exception ex) {
                                    Assert.fail((String)ex.getMessage());
                                }
                            }
                        };
                        putThreads[i] = new Thread(r);
                        ++i;
                    }
                    TestUtils.waitAll(putThreads);
                }
                catch (Exception ex) {
                    Assert.fail((String)ex.getMessage());
                    TestUtils.removeFile(filePath);
                    totalCompleted = completedCounter.get();
                    Assert.assertEquals((int)100, (int)totalCompleted);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                TestUtils.removeFile(filePath);
                int totalCompleted2 = completedCounter.get();
                Assert.assertEquals((int)100, (int)totalCompleted2);
                throw throwable;
            }
            TestUtils.removeFile(filePath);
            totalCompleted = completedCounter.get();
            Assert.assertEquals((int)100, (int)totalCompleted);
        }
        completedCounter.set(0);
        TestUtils.ensureDirExist(TestConfig.DOWNLOAD_DIRECOTRY);
        final ArrayList<File> downloadFiles = new ArrayList<File>();
        final ReentrantLock lock = new ReentrantLock();
        try {
            try {
                Thread[] getThreads = new Thread[100];
                int i = 0;
                while (i < 100) {
                    final int seqNum = i;
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String key = TestUtils.buildObjectKey("get-medium-file-concurrently-", seqNum);
                                GetObjectRequest request = new GetObjectRequest(bucketName, key);
                                File file = new File(String.valueOf(TestConfig.DOWNLOAD_DIRECOTRY) + key);
                                file.createNewFile();
                                try {
                                    lock.lock();
                                    downloadFiles.add(file);
                                }
                                finally {
                                    lock.unlock();
                                }
                                secondClient.getObject(request, file);
                                completedCounter.incrementAndGet();
                            }
                            catch (Exception ex) {
                                Assert.fail((String)ex.getMessage());
                            }
                        }
                    };
                    getThreads[i] = new Thread(r);
                    ++i;
                }
                TestUtils.waitAll(getThreads);
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                TestUtils.removeFiles(downloadFiles);
                int totalCompleted = completedCounter.get();
                Assert.assertEquals((int)100, (int)totalCompleted);
            }
        }
        finally {
            TestUtils.removeFiles(downloadFiles);
            int totalCompleted = completedCounter.get();
            Assert.assertEquals((int)100, (int)totalCompleted);
        }
    }

    @Ignore
    public void testGetLargeFileConcurrently() throws Exception {
        AtomicInteger completedCounter;
        block12: {
            int totalCompleted;
            int threadCount = 10;
            String keyPrefix = "get-large-file-concurrently-";
            final String filePath = TestUtils.genFixedLengthFile(Integer.MIN_VALUE);
            completedCounter = new AtomicInteger(0);
            try {
                try {
                    Thread[] putThreads = new Thread[10];
                    int i = 0;
                    while (i < 10) {
                        final int seqNum = i;
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    secondClient.putObject(bucketName, TestUtils.buildObjectKey("get-large-file-concurrently-", seqNum), new File(filePath));
                                    completedCounter.incrementAndGet();
                                }
                                catch (Exception ex) {
                                    Assert.fail((String)ex.getMessage());
                                }
                            }
                        };
                        putThreads[i] = new Thread(r);
                        ++i;
                    }
                    TestUtils.waitAll(putThreads);
                }
                catch (Exception ex) {
                    Assert.fail((String)ex.getMessage());
                    TestUtils.removeFile(filePath);
                    totalCompleted = completedCounter.get();
                    Assert.assertEquals((int)10, (int)totalCompleted);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                TestUtils.removeFile(filePath);
                int totalCompleted2 = completedCounter.get();
                Assert.assertEquals((int)10, (int)totalCompleted2);
                throw throwable;
            }
            TestUtils.removeFile(filePath);
            totalCompleted = completedCounter.get();
            Assert.assertEquals((int)10, (int)totalCompleted);
        }
        completedCounter.set(0);
        TestUtils.ensureDirExist(TestConfig.DOWNLOAD_DIRECOTRY);
        final ArrayList<File> downloadFiles = new ArrayList<File>();
        final ReentrantLock lock = new ReentrantLock();
        try {
            try {
                Thread[] getThreads = new Thread[10];
                int i = 0;
                while (i < 10) {
                    final int seqNum = i;
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String key = TestUtils.buildObjectKey("get-large-file-concurrently-", seqNum);
                                GetObjectRequest request = new GetObjectRequest(bucketName, key);
                                File file = new File(String.valueOf(TestConfig.DOWNLOAD_DIRECOTRY) + key);
                                file.createNewFile();
                                try {
                                    lock.lock();
                                    downloadFiles.add(file);
                                }
                                finally {
                                    lock.unlock();
                                }
                                secondClient.getObject(request, file);
                                completedCounter.incrementAndGet();
                            }
                            catch (Exception ex) {
                                Assert.fail((String)ex.getMessage());
                            }
                        }
                    };
                    getThreads[i] = new Thread(r);
                    ++i;
                }
                TestUtils.waitAll(getThreads);
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                TestUtils.removeFiles(downloadFiles);
                int totalCompleted = completedCounter.get();
                Assert.assertEquals((int)10, (int)totalCompleted);
            }
        }
        finally {
            TestUtils.removeFiles(downloadFiles);
            int totalCompleted = completedCounter.get();
            Assert.assertEquals((int)10, (int)totalCompleted);
        }
    }

    @Ignore
    public void testGetRandomScaleFileConcurrently() throws Exception {
        AtomicInteger completedCounter;
        block12: {
            int totalCompleted;
            int threadCount = 100;
            String keyPrefix = "get-random-scale-file-concurrently-";
            completedCounter = new AtomicInteger(0);
            ArrayList<File> fileList = new ArrayList<File>();
            try {
                try {
                    Thread[] putThreads = new Thread[100];
                    int i = 0;
                    while (i < 100) {
                        final int seqNum = i;
                        final File randomFile = new File(TestUtils.genRandomLengthFile());
                        fileList.add(randomFile);
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    secondClient.putObject(bucketName, TestUtils.buildObjectKey("get-random-scale-file-concurrently-", seqNum), randomFile);
                                    completedCounter.incrementAndGet();
                                }
                                catch (Exception ex) {
                                    Assert.fail((String)ex.getMessage());
                                }
                            }
                        };
                        putThreads[i] = new Thread(r);
                        ++i;
                    }
                    TestUtils.waitAll(putThreads);
                }
                catch (Exception ex) {
                    Assert.fail((String)ex.getMessage());
                    totalCompleted = completedCounter.get();
                    Assert.assertEquals((int)100, (int)totalCompleted);
                    TestUtils.removeFiles(fileList);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                int totalCompleted2 = completedCounter.get();
                Assert.assertEquals((int)100, (int)totalCompleted2);
                TestUtils.removeFiles(fileList);
                throw throwable;
            }
            totalCompleted = completedCounter.get();
            Assert.assertEquals((int)100, (int)totalCompleted);
            TestUtils.removeFiles(fileList);
        }
        completedCounter.set(0);
        TestUtils.ensureDirExist(TestConfig.DOWNLOAD_DIRECOTRY);
        final ArrayList<File> downloadFiles = new ArrayList<File>();
        final ReentrantLock lock = new ReentrantLock();
        try {
            try {
                Thread[] getThreads = new Thread[100];
                int i = 0;
                while (i < 100) {
                    final int seqNum = i;
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String key = TestUtils.buildObjectKey("get-random-scale-file-concurrently-", seqNum);
                                GetObjectRequest request = new GetObjectRequest(bucketName, key);
                                File file = new File(String.valueOf(TestConfig.DOWNLOAD_DIRECOTRY) + key);
                                file.createNewFile();
                                try {
                                    lock.lock();
                                    downloadFiles.add(file);
                                }
                                finally {
                                    lock.unlock();
                                }
                                secondClient.getObject(request, file);
                                completedCounter.incrementAndGet();
                            }
                            catch (Exception ex) {
                                Assert.fail((String)ex.getMessage());
                            }
                        }
                    };
                    getThreads[i] = new Thread(r);
                    ++i;
                }
                TestUtils.waitAll(getThreads);
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                TestUtils.removeFiles(downloadFiles);
                int totalCompleted = completedCounter.get();
                Assert.assertEquals((int)100, (int)totalCompleted);
            }
        }
        finally {
            TestUtils.removeFiles(downloadFiles);
            int totalCompleted = completedCounter.get();
            Assert.assertEquals((int)100, (int)totalCompleted);
        }
    }

    @Test
    public void testGetObjectByRange() {
        String key = "get-object-by-range";
        long inputStreamLength = 131072L;
        try {
            secondClient.putObject(bucketName, "get-object-by-range", TestUtils.genFixedLengthInputStream(131072L), null);
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, "get-object-by-range");
            getObjectRequest.setRange(0L, 65535L);
            OSSObject o = secondClient.getObject(getObjectRequest);
            Assert.assertEquals((long)65536L, (long)o.getObjectMetadata().getContentLength());
            getObjectRequest.setRange(65536L, -1L);
            o = secondClient.getObject(getObjectRequest);
            Assert.assertEquals((long)65536L, (long)o.getObjectMetadata().getContentLength());
            getObjectRequest.setRange(-1L, 32768L);
            o = secondClient.getObject(getObjectRequest);
            Assert.assertEquals((long)32768L, (long)o.getObjectMetadata().getContentLength());
            try {
                getObjectRequest.setRange(-1L, 0L);
                o = secondClient.getObject(getObjectRequest);
                Assert.fail((String)"Get object should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"InvalidRange", (String)e.getErrorCode());
            }
            getObjectRequest.setRange(-1L, -1L);
            o = secondClient.getObject(getObjectRequest);
            Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
            getObjectRequest.setRange(65536L, 32768L);
            o = secondClient.getObject(getObjectRequest);
            Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
            getObjectRequest.setRange(0L, 262143L);
            o = secondClient.getObject(getObjectRequest);
            Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOverridedGetObject() {
        String key = "overrided-get-object";
        long inputStreamLength = 131072L;
        try {
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "overrided-get-object", TestUtils.genFixedLengthInputStream(131072L), null);
            secondClient.putObject(putObjectRequest);
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, "overrided-get-object");
            OSSObject o = secondClient.getObject(getObjectRequest);
            Assert.assertEquals((String)bucketName, (String)o.getBucketName());
            Assert.assertEquals((String)"overrided-get-object", (String)o.getKey());
            Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
            o = secondClient.getObject(bucketName, "overrided-get-object");
            Assert.assertEquals((String)bucketName, (String)o.getBucketName());
            Assert.assertEquals((String)"overrided-get-object", (String)o.getKey());
            Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
            String filePath = TestUtils.genFixedLengthFile(0L);
            ObjectMetadata metadata = secondClient.getObject(getObjectRequest, new File(filePath));
            Assert.assertEquals((long)131072L, (long)metadata.getContentLength());
            Assert.assertEquals((long)131072L, (long)new File(filePath).length());
            metadata = secondClient.getObjectMetadata(bucketName, "overrided-get-object");
            Assert.assertEquals((long)131072L, (long)metadata.getContentLength());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetObjectWithSpecialChars() {
        String key = "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip";
        long inputStreamLength = 131072L;
        String metaKey0 = "tag";
        String metaValue0 = "\u5143\u503c0";
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentType("application/octet-stream");
            metadata.addUserMetadata("tag", "\u5143\u503c0");
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip", TestUtils.genFixedLengthInputStream(131072L), metadata);
            secondClient.putObject(putObjectRequest);
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip");
            OSSObject o = secondClient.getObject(getObjectRequest);
            Assert.assertEquals((String)bucketName, (String)o.getBucketName());
            Assert.assertEquals((String)"\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip", (String)o.getKey());
            metadata = o.getObjectMetadata();
            Assert.assertEquals((String)"application/octet-stream", (String)metadata.getContentType());
            Assert.assertEquals((String)"\u5143\u503c0", (String)metadata.getUserMetadata().get("tag"));
            Assert.assertEquals((long)131072L, (long)metadata.getContentLength());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetObjectByUrlsignature() {
        String key = "put-object-by-urlsignature";
        String expirationString = "Sun, 12 Apr 2016 12:00:00 GMT";
        long inputStreamLength = 131072L;
        long firstByte = 65536L;
        long lastByte = 131071L;
        try {
            secondClient.putObject(bucketName, "put-object-by-urlsignature", TestUtils.genFixedLengthInputStream(131072L), null);
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, "put-object-by-urlsignature");
            Date expiration = DateUtil.parseRfc822Date("Sun, 12 Apr 2016 12:00:00 GMT");
            request.setExpiration(expiration);
            request.setContentType("application/octet-stream");
            URL signedUrl = secondClient.generatePresignedUrl(request);
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            requestHeaders.put("Range", String.format("bytes=%d-%d", 65536L, 131071L));
            requestHeaders.put("Content-Type", "application/octet-stream");
            OSSObject o = secondClient.getObject(signedUrl, requestHeaders);
            try {
                try {
                    int bytesRead = -1;
                    int totalBytes = 0;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = o.getObjectContent().read(buffer)) != -1) {
                        totalBytes += bytesRead;
                    }
                    Assert.assertEquals((long)65536L, (long)totalBytes);
                }
                catch (IOException e) {
                    Assert.fail((String)e.getMessage());
                    IOUtils.safeClose(o.getObjectContent());
                }
            }
            finally {
                IOUtils.safeClose(o.getObjectContent());
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUnormalGetObject() throws Exception {
        Date modifiedSinceConstraint;
        OSSObject o;
        GetObjectRequest getObjectRequest;
        block52: {
            String eTag;
            Date beforeModifiedTime;
            block50: {
                Date unmodifiedSinceConstraint;
                block48: {
                    block46: {
                        ArrayList<String> nonmatchingETagConstraints;
                        block44: {
                            block42: {
                                ArrayList<String> matchingETagConstraints;
                                block40: {
                                    beforeModifiedTime = new Date();
                                    Thread.sleep(1000L);
                                    String key = "unormal-get-object";
                                    String nonexistentBucket = "nonexistent-bukcet";
                                    try {
                                        secondClient.getObject("nonexistent-bukcet", "unormal-get-object");
                                        Assert.fail((String)"Get object should not be successful");
                                    }
                                    catch (OSSException ex) {
                                        Assert.assertEquals((String)"NoSuchBucket", (String)ex.getErrorCode());
                                        Assert.assertTrue((boolean)ex.getMessage().startsWith("The specified bucket does not exist."));
                                    }
                                    String nonexistentKey = "nonexistent-object";
                                    try {
                                        secondClient.getObject(bucketName, "nonexistent-object");
                                        Assert.fail((String)"Get object should not be successful");
                                    }
                                    catch (OSSException ex) {
                                        Assert.assertEquals((String)"NoSuchKey", (String)ex.getErrorCode());
                                        Assert.assertTrue((boolean)ex.getMessage().startsWith("The specified key does not exist."));
                                    }
                                    eTag = null;
                                    try {
                                        PutObjectResult result = secondClient.putObject(bucketName, "unormal-get-object", TestUtils.genFixedLengthInputStream(1024L), null);
                                        eTag = result.getETag();
                                    }
                                    catch (Exception e) {
                                        Assert.fail((String)e.getMessage());
                                    }
                                    getObjectRequest = new GetObjectRequest(bucketName, "unormal-get-object");
                                    matchingETagConstraints = new ArrayList<String>();
                                    o = null;
                                    matchingETagConstraints.add(eTag);
                                    getObjectRequest.setMatchingETagConstraints(matchingETagConstraints);
                                    try {
                                        try {
                                            o = secondClient.getObject(getObjectRequest);
                                            Assert.assertEquals((String)eTag, (String)o.getObjectMetadata().getETag());
                                        }
                                        catch (Exception e) {
                                            Assert.fail((String)e.getMessage());
                                            getObjectRequest.setMatchingETagConstraints(null);
                                            break block40;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        getObjectRequest.setMatchingETagConstraints(null);
                                        throw throwable;
                                    }
                                    getObjectRequest.setMatchingETagConstraints(null);
                                }
                                matchingETagConstraints.clear();
                                matchingETagConstraints.add("nonmatching-etag");
                                getObjectRequest.setMatchingETagConstraints(matchingETagConstraints);
                                try {
                                    try {
                                        o = secondClient.getObject(getObjectRequest);
                                        Assert.fail((String)"Get object should not be successful.");
                                    }
                                    catch (OSSException e) {
                                        Assert.assertEquals((String)"PreconditionFailed", (String)e.getErrorCode());
                                        getObjectRequest.setMatchingETagConstraints(null);
                                        break block42;
                                    }
                                }
                                catch (Throwable throwable) {
                                    getObjectRequest.setMatchingETagConstraints(null);
                                    throw throwable;
                                }
                                getObjectRequest.setMatchingETagConstraints(null);
                            }
                            nonmatchingETagConstraints = new ArrayList<String>();
                            nonmatchingETagConstraints.add("nonmatching-etag");
                            getObjectRequest.setNonmatchingETagConstraints(nonmatchingETagConstraints);
                            try {
                                try {
                                    o = secondClient.getObject(getObjectRequest);
                                    Assert.assertEquals((String)eTag, (String)o.getObjectMetadata().getETag());
                                }
                                catch (OSSException e) {
                                    Assert.fail((String)e.getMessage());
                                    getObjectRequest.setNonmatchingETagConstraints(null);
                                    break block44;
                                }
                            }
                            catch (Throwable throwable) {
                                getObjectRequest.setNonmatchingETagConstraints(null);
                                throw throwable;
                            }
                            getObjectRequest.setNonmatchingETagConstraints(null);
                        }
                        nonmatchingETagConstraints.clear();
                        nonmatchingETagConstraints.add(eTag);
                        getObjectRequest.setNonmatchingETagConstraints(nonmatchingETagConstraints);
                        try {
                            try {
                                o = secondClient.getObject(getObjectRequest);
                                Assert.fail((String)"Get object should not be successful.");
                            }
                            catch (OSSException e) {
                                Assert.assertEquals((String)"NotModified", (String)e.getErrorCode());
                                Assert.assertTrue((boolean)e.getMessage().startsWith("Not Modified"));
                                getObjectRequest.setNonmatchingETagConstraints(null);
                                break block46;
                            }
                        }
                        catch (Throwable throwable) {
                            getObjectRequest.setNonmatchingETagConstraints(null);
                            throw throwable;
                        }
                        getObjectRequest.setNonmatchingETagConstraints(null);
                    }
                    unmodifiedSinceConstraint = new Date();
                    getObjectRequest.setUnmodifiedSinceConstraint(unmodifiedSinceConstraint);
                    try {
                        try {
                            o = secondClient.getObject(getObjectRequest);
                            Assert.assertEquals((String)eTag, (String)o.getObjectMetadata().getETag());
                        }
                        catch (OSSException e) {
                            Assert.fail((String)e.getMessage());
                            getObjectRequest.setUnmodifiedSinceConstraint(null);
                            break block48;
                        }
                    }
                    catch (Throwable throwable) {
                        getObjectRequest.setUnmodifiedSinceConstraint(null);
                        throw throwable;
                    }
                    getObjectRequest.setUnmodifiedSinceConstraint(null);
                }
                unmodifiedSinceConstraint = beforeModifiedTime;
                getObjectRequest.setUnmodifiedSinceConstraint(unmodifiedSinceConstraint);
                try {
                    try {
                        o = secondClient.getObject(getObjectRequest);
                        Assert.fail((String)"Get object should not be successful.");
                    }
                    catch (OSSException e) {
                        Assert.assertEquals((String)"PreconditionFailed", (String)e.getErrorCode());
                        getObjectRequest.setUnmodifiedSinceConstraint(null);
                        break block50;
                    }
                }
                catch (Throwable throwable) {
                    getObjectRequest.setUnmodifiedSinceConstraint(null);
                    throw throwable;
                }
                getObjectRequest.setUnmodifiedSinceConstraint(null);
            }
            modifiedSinceConstraint = beforeModifiedTime;
            getObjectRequest.setModifiedSinceConstraint(modifiedSinceConstraint);
            try {
                try {
                    o = secondClient.getObject(getObjectRequest);
                    Assert.assertEquals((String)eTag, (String)o.getObjectMetadata().getETag());
                }
                catch (OSSException e) {
                    Assert.fail((String)e.getMessage());
                    getObjectRequest.setModifiedSinceConstraint(null);
                    break block52;
                }
            }
            catch (Throwable throwable) {
                getObjectRequest.setModifiedSinceConstraint(null);
                throw throwable;
            }
            getObjectRequest.setModifiedSinceConstraint(null);
        }
        modifiedSinceConstraint = new Date();
        getObjectRequest.setModifiedSinceConstraint(modifiedSinceConstraint);
        try {
            try {
                o = secondClient.getObject(getObjectRequest);
                Assert.fail((String)"Get object should not be successful.");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"NotModified", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("Not Modified"));
                getObjectRequest.setModifiedSinceConstraint(null);
            }
        }
        finally {
            getObjectRequest.setModifiedSinceConstraint(null);
        }
    }

    @Test
    public void testGetObjectMetadataWithIllegalExpires() {
        String key = "get-object-with-illegal-expires";
        long inputStreamLength = 131072L;
        String illegalExpires = "2015-10-01 00:00:00";
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setHeader("Expires", "2015-10-01 00:00:00");
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, "get-object-with-illegal-expires", TestUtils.genFixedLengthInputStream(131072L), metadata);
            secondClient.putObject(putObjectRequest);
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, "get-object-with-illegal-expires");
            OSSObject o = secondClient.getObject(getObjectRequest);
            try {
                o.getObjectMetadata().getExpirationTime();
                Assert.fail((String)"Get expiration time should not be successful.");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof ParseException));
                Assert.assertEquals((String)"Unparseable date: \"2015-10-01 00:00:00\"", (String)e.getMessage());
            }
            String rawExpiresValue = o.getObjectMetadata().getRawExpiresValue();
            Assert.assertEquals((String)"2015-10-01 00:00:00", (String)rawExpiresValue);
            metadata = secondClient.getObjectMetadata(bucketName, "get-object-with-illegal-expires");
            try {
                metadata.getExpirationTime();
                Assert.fail((String)"Get expiration time should not be successful.");
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof ParseException));
                Assert.assertEquals((String)"Unparseable date: \"2015-10-01 00:00:00\"", (String)e.getMessage());
            }
            rawExpiresValue = o.getObjectMetadata().getRawExpiresValue();
            Assert.assertEquals((String)"2015-10-01 00:00:00", (String)rawExpiresValue);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

