/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tea;

import com.aliyun.tea.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Response;

public class TeaResponse {
    public Response response;
    public int statusCode;
    public String statusMessage;
    public HashMap<String, String> headers = new HashMap();
    public InputStream body;

    public TeaResponse() {
    }

    public TeaResponse(Response response) {
        this.response = response;
        this.statusCode = response.code();
        this.statusMessage = response.message();
        this.body = response.body().byteStream();
        Headers headers = response.headers();
        Map resultHeaders = headers.toMultimap();
        for (Map.Entry entry : resultHeaders.entrySet()) {
            this.headers.put((String)entry.getKey(), StringUtils.join(";", (Iterable)entry.getValue()));
        }
    }

    public InputStream getResponse() throws IOException {
        return this.body;
    }

    public String getResponseBody() throws IOException {
        int read;
        if (null == this.body) {
            return String.format("{\"message\":\"%s\"}", this.statusMessage);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        while ((read = this.body.read(buff)) != -1) {
            os.write(buff, 0, read);
        }
        return new String(os.toByteArray());
    }
}

