/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.appsync.model.Resolver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListResolversResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Resolver> resolvers;
    private String nextToken;

    public List<Resolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(Collection<Resolver> resolvers) {
        if (resolvers == null) {
            this.resolvers = null;
            return;
        }
        this.resolvers = new ArrayList<Resolver>(resolvers);
    }

    public ListResolversResult withResolvers(Resolver ... resolvers) {
        if (this.resolvers == null) {
            this.setResolvers(new ArrayList<Resolver>(resolvers.length));
        }
        for (Resolver ele : resolvers) {
            this.resolvers.add(ele);
        }
        return this;
    }

    public ListResolversResult withResolvers(Collection<Resolver> resolvers) {
        this.setResolvers(resolvers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListResolversResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResolvers() != null) {
            sb.append("Resolvers: ").append(this.getResolvers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolversResult)) {
            return false;
        }
        ListResolversResult other = (ListResolversResult)obj;
        if (other.getResolvers() == null ^ this.getResolvers() == null) {
            return false;
        }
        if (other.getResolvers() != null && !other.getResolvers().equals(this.getResolvers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResolvers() == null ? 0 : this.getResolvers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListResolversResult clone() {
        try {
            return (ListResolversResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

