/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codepipeline.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The detail returned for each webhook after listing webhooks, such as the webhook URL, the webhook name, and the
 * webhook ARN.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/ListWebhookItem" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListWebhookItem implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The detail returned for each webhook, such as the webhook authentication type and filter rules.
     * </p>
     */
    private WebhookDefinition definition;
    /**
     * <p>
     * A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is started
     * as long as the body of the post request satisfies the defined authentication and filtering conditions. Deleting
     * and re-creating a webhook will make the old URL invalid and generate a new URL.
     * </p>
     */
    private String url;
    /**
     * <p>
     * The text of the error message about the webhook.
     * </p>
     */
    private String errorMessage;
    /**
     * <p>
     * The number code of the error.
     * </p>
     */
    private String errorCode;
    /**
     * <p>
     * The date and time a webhook was last successfully triggered, in timestamp format.
     * </p>
     */
    private java.util.Date lastTriggered;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the webhook.
     * </p>
     */
    private String arn;

    /**
     * <p>
     * The detail returned for each webhook, such as the webhook authentication type and filter rules.
     * </p>
     * 
     * @param definition
     *        The detail returned for each webhook, such as the webhook authentication type and filter rules.
     */

    public void setDefinition(WebhookDefinition definition) {
        this.definition = definition;
    }

    /**
     * <p>
     * The detail returned for each webhook, such as the webhook authentication type and filter rules.
     * </p>
     * 
     * @return The detail returned for each webhook, such as the webhook authentication type and filter rules.
     */

    public WebhookDefinition getDefinition() {
        return this.definition;
    }

    /**
     * <p>
     * The detail returned for each webhook, such as the webhook authentication type and filter rules.
     * </p>
     * 
     * @param definition
     *        The detail returned for each webhook, such as the webhook authentication type and filter rules.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWebhookItem withDefinition(WebhookDefinition definition) {
        setDefinition(definition);
        return this;
    }

    /**
     * <p>
     * A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is started
     * as long as the body of the post request satisfies the defined authentication and filtering conditions. Deleting
     * and re-creating a webhook will make the old URL invalid and generate a new URL.
     * </p>
     * 
     * @param url
     *        A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is
     *        started as long as the body of the post request satisfies the defined authentication and filtering
     *        conditions. Deleting and re-creating a webhook will make the old URL invalid and generate a new URL.
     */

    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * <p>
     * A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is started
     * as long as the body of the post request satisfies the defined authentication and filtering conditions. Deleting
     * and re-creating a webhook will make the old URL invalid and generate a new URL.
     * </p>
     * 
     * @return A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is
     *         started as long as the body of the post request satisfies the defined authentication and filtering
     *         conditions. Deleting and re-creating a webhook will make the old URL invalid and generate a new URL.
     */

    public String getUrl() {
        return this.url;
    }

    /**
     * <p>
     * A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is started
     * as long as the body of the post request satisfies the defined authentication and filtering conditions. Deleting
     * and re-creating a webhook will make the old URL invalid and generate a new URL.
     * </p>
     * 
     * @param url
     *        A unique URL generated by CodePipeline. When a POST request is made to this URL, the defined pipeline is
     *        started as long as the body of the post request satisfies the defined authentication and filtering
     *        conditions. Deleting and re-creating a webhook will make the old URL invalid and generate a new URL.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWebhookItem withUrl(String url) {
        setUrl(url);
        return this;
    }

    /**
     * <p>
     * The text of the error message about the webhook.
     * </p>
     * 
     * @param errorMessage
     *        The text of the error message about the webhook.
     */

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    /**
     * <p>
     * The text of the error message about the webhook.
     * </p>
     * 
     * @return The text of the error message about the webhook.
     */

    public String getErrorMessage() {
        return this.errorMessage;
    }

    /**
     * <p>
     * The text of the error message about the webhook.
     * </p>
     * 
     * @param errorMessage
     *        The text of the error message about the webhook.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWebhookItem withErrorMessage(String errorMessage) {
        setErrorMessage(errorMessage);
        return this;
    }

    /**
     * <p>
     * The number code of the error.
     * </p>
     * 
     * @param errorCode
     *        The number code of the error.
     */

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * <p>
     * The number code of the error.
     * </p>
     * 
     * @return The number code of the error.
     */

    public String getErrorCode() {
        return this.errorCode;
    }

    /**
     * <p>
     * The number code of the error.
     * </p>
     * 
     * @param errorCode
     *        The number code of the error.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWebhookItem withErrorCode(String errorCode) {
        setErrorCode(errorCode);
        return this;
    }

    /**
     * <p>
     * The date and time a webhook was last successfully triggered, in timestamp format.
     * </p>
     * 
     * @param lastTriggered
     *        The date and time a webhook was last successfully triggered, in timestamp format.
     */

    public void setLastTriggered(java.util.Date lastTriggered) {
        this.lastTriggered = lastTriggered;
    }

    /**
     * <p>
     * The date and time a webhook was last successfully triggered, in timestamp format.
     * </p>
     * 
     * @return The date and time a webhook was last successfully triggered, in timestamp format.
     */

    public java.util.Date getLastTriggered() {
        return this.lastTriggered;
    }

    /**
     * <p>
     * The date and time a webhook was last successfully triggered, in timestamp format.
     * </p>
     * 
     * @param lastTriggered
     *        The date and time a webhook was last successfully triggered, in timestamp format.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWebhookItem withLastTriggered(java.util.Date lastTriggered) {
        setLastTriggered(lastTriggered);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the webhook.
     * </p>
     * 
     * @param arn
     *        The Amazon Resource Name (ARN) of the webhook.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the webhook.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the webhook.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the webhook.
     * </p>
     * 
     * @param arn
     *        The Amazon Resource Name (ARN) of the webhook.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWebhookItem withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDefinition() != null)
            sb.append("Definition: ").append(getDefinition()).append(",");
        if (getUrl() != null)
            sb.append("Url: ").append(getUrl()).append(",");
        if (getErrorMessage() != null)
            sb.append("ErrorMessage: ").append(getErrorMessage()).append(",");
        if (getErrorCode() != null)
            sb.append("ErrorCode: ").append(getErrorCode()).append(",");
        if (getLastTriggered() != null)
            sb.append("LastTriggered: ").append(getLastTriggered()).append(",");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListWebhookItem == false)
            return false;
        ListWebhookItem other = (ListWebhookItem) obj;
        if (other.getDefinition() == null ^ this.getDefinition() == null)
            return false;
        if (other.getDefinition() != null && other.getDefinition().equals(this.getDefinition()) == false)
            return false;
        if (other.getUrl() == null ^ this.getUrl() == null)
            return false;
        if (other.getUrl() != null && other.getUrl().equals(this.getUrl()) == false)
            return false;
        if (other.getErrorMessage() == null ^ this.getErrorMessage() == null)
            return false;
        if (other.getErrorMessage() != null && other.getErrorMessage().equals(this.getErrorMessage()) == false)
            return false;
        if (other.getErrorCode() == null ^ this.getErrorCode() == null)
            return false;
        if (other.getErrorCode() != null && other.getErrorCode().equals(this.getErrorCode()) == false)
            return false;
        if (other.getLastTriggered() == null ^ this.getLastTriggered() == null)
            return false;
        if (other.getLastTriggered() != null && other.getLastTriggered().equals(this.getLastTriggered()) == false)
            return false;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDefinition() == null) ? 0 : getDefinition().hashCode());
        hashCode = prime * hashCode + ((getUrl() == null) ? 0 : getUrl().hashCode());
        hashCode = prime * hashCode + ((getErrorMessage() == null) ? 0 : getErrorMessage().hashCode());
        hashCode = prime * hashCode + ((getErrorCode() == null) ? 0 : getErrorCode().hashCode());
        hashCode = prime * hashCode + ((getLastTriggered() == null) ? 0 : getLastTriggered().hashCode());
        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        return hashCode;
    }

    @Override
    public ListWebhookItem clone() {
        try {
            return (ListWebhookItem) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.codepipeline.model.transform.ListWebhookItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
