/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devicefarm.model.MonetaryAmount;
import com.amazonaws.services.devicefarm.model.RecurringChargeFrequency;
import com.amazonaws.services.devicefarm.model.transform.RecurringChargeMarshaller;
import java.io.Serializable;

public class RecurringCharge
implements Serializable,
Cloneable,
StructuredPojo {
    private MonetaryAmount cost;
    private String frequency;

    public void setCost(MonetaryAmount cost) {
        this.cost = cost;
    }

    public MonetaryAmount getCost() {
        return this.cost;
    }

    public RecurringCharge withCost(MonetaryAmount cost) {
        this.setCost(cost);
        return this;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public RecurringCharge withFrequency(String frequency) {
        this.setFrequency(frequency);
        return this;
    }

    public void setFrequency(RecurringChargeFrequency frequency) {
        this.withFrequency(frequency);
    }

    public RecurringCharge withFrequency(RecurringChargeFrequency frequency) {
        this.frequency = frequency.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCost() != null) {
            sb.append("Cost: ").append(this.getCost()).append(",");
        }
        if (this.getFrequency() != null) {
            sb.append("Frequency: ").append(this.getFrequency());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringCharge)) {
            return false;
        }
        RecurringCharge other = (RecurringCharge)obj;
        if (other.getCost() == null ^ this.getCost() == null) {
            return false;
        }
        if (other.getCost() != null && !other.getCost().equals(this.getCost())) {
            return false;
        }
        if (other.getFrequency() == null ^ this.getFrequency() == null) {
            return false;
        }
        return other.getFrequency() == null || other.getFrequency().equals(this.getFrequency());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCost() == null ? 0 : this.getCost().hashCode());
        hashCode = 31 * hashCode + (this.getFrequency() == null ? 0 : this.getFrequency().hashCode());
        return hashCode;
    }

    public RecurringCharge clone() {
        try {
            return (RecurringCharge)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecurringChargeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

