/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DiskImageFormat;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.ExportTaskS3LocationRequest;
import com.amazonaws.services.ec2.model.transform.ExportImageRequestMarshaller;
import java.io.Serializable;

public class ExportImageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ExportImageRequest> {
    private String clientToken;
    private String description;
    private String diskImageFormat;
    private String imageId;
    private ExportTaskS3LocationRequest s3ExportLocation;
    private String roleName;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public ExportImageRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ExportImageRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDiskImageFormat(String diskImageFormat) {
        this.diskImageFormat = diskImageFormat;
    }

    public String getDiskImageFormat() {
        return this.diskImageFormat;
    }

    public ExportImageRequest withDiskImageFormat(String diskImageFormat) {
        this.setDiskImageFormat(diskImageFormat);
        return this;
    }

    public ExportImageRequest withDiskImageFormat(DiskImageFormat diskImageFormat) {
        this.diskImageFormat = diskImageFormat.toString();
        return this;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public ExportImageRequest withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setS3ExportLocation(ExportTaskS3LocationRequest s3ExportLocation) {
        this.s3ExportLocation = s3ExportLocation;
    }

    public ExportTaskS3LocationRequest getS3ExportLocation() {
        return this.s3ExportLocation;
    }

    public ExportImageRequest withS3ExportLocation(ExportTaskS3LocationRequest s3ExportLocation) {
        this.setS3ExportLocation(s3ExportLocation);
        return this;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public ExportImageRequest withRoleName(String roleName) {
        this.setRoleName(roleName);
        return this;
    }

    @Override
    public Request<ExportImageRequest> getDryRunRequest() {
        Request<ExportImageRequest> request = new ExportImageRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDiskImageFormat() != null) {
            sb.append("DiskImageFormat: ").append(this.getDiskImageFormat()).append(",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getS3ExportLocation() != null) {
            sb.append("S3ExportLocation: ").append(this.getS3ExportLocation()).append(",");
        }
        if (this.getRoleName() != null) {
            sb.append("RoleName: ").append(this.getRoleName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportImageRequest)) {
            return false;
        }
        ExportImageRequest other = (ExportImageRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDiskImageFormat() == null ^ this.getDiskImageFormat() == null) {
            return false;
        }
        if (other.getDiskImageFormat() != null && !other.getDiskImageFormat().equals(this.getDiskImageFormat())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getS3ExportLocation() == null ^ this.getS3ExportLocation() == null) {
            return false;
        }
        if (other.getS3ExportLocation() != null && !other.getS3ExportLocation().equals(this.getS3ExportLocation())) {
            return false;
        }
        if (other.getRoleName() == null ^ this.getRoleName() == null) {
            return false;
        }
        return other.getRoleName() == null || other.getRoleName().equals(this.getRoleName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDiskImageFormat() == null ? 0 : this.getDiskImageFormat().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getS3ExportLocation() == null ? 0 : this.getS3ExportLocation().hashCode());
        hashCode = 31 * hashCode + (this.getRoleName() == null ? 0 : this.getRoleName().hashCode());
        return hashCode;
    }

    public ExportImageRequest clone() {
        return (ExportImageRequest)super.clone();
    }
}

