/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.gamelift.model.ServerProcess;

@SdkInternalApi
public class ServerProcessMarshaller {
    private static final MarshallingInfo<String> LAUNCHPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LaunchPath").build();
    private static final MarshallingInfo<String> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<Integer> CONCURRENTEXECUTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConcurrentExecutions").build();
    private static final ServerProcessMarshaller instance = new ServerProcessMarshaller();

    public static ServerProcessMarshaller getInstance() {
        return instance;
    }

    public void marshall(ServerProcess serverProcess, ProtocolMarshaller protocolMarshaller) {
        if (serverProcess == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)serverProcess.getLaunchPath(), LAUNCHPATH_BINDING);
            protocolMarshaller.marshall((Object)serverProcess.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)serverProcess.getConcurrentExecutions(), CONCURRENTEXECUTIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

