/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iot.model.MetricValue;
import java.util.List;

@SdkInternalApi
public class MetricValueMarshaller {
    private static final MarshallingInfo<Long> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").build();
    private static final MarshallingInfo<List> CIDRS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cidrs").build();
    private static final MarshallingInfo<List> PORTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ports").build();
    private static final MetricValueMarshaller instance = new MetricValueMarshaller();

    public static MetricValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricValue metricValue, ProtocolMarshaller protocolMarshaller) {
        if (metricValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricValue.getCount(), COUNT_BINDING);
            protocolMarshaller.marshall(metricValue.getCidrs(), CIDRS_BINDING);
            protocolMarshaller.marshall(metricValue.getPorts(), PORTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

