/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.medialive.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.medialive.model.ChannelEgressEndpoint;
import com.amazonaws.services.medialive.model.ChannelState;
import com.amazonaws.services.medialive.model.EncoderSettings;
import com.amazonaws.services.medialive.model.InputAttachment;
import com.amazonaws.services.medialive.model.InputSpecification;
import com.amazonaws.services.medialive.model.LogLevel;
import com.amazonaws.services.medialive.model.OutputDestination;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeChannelResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String arn;
    private List<OutputDestination> destinations;
    private List<ChannelEgressEndpoint> egressEndpoints;
    private EncoderSettings encoderSettings;
    private String id;
    private List<InputAttachment> inputAttachments;
    private InputSpecification inputSpecification;
    private String logLevel;
    private String name;
    private Integer pipelinesRunningCount;
    private String roleArn;
    private String state;

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public DescribeChannelResult withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<OutputDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<OutputDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<OutputDestination>(destinations);
    }

    public DescribeChannelResult withDestinations(OutputDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<OutputDestination>(destinations.length));
        }
        for (OutputDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public DescribeChannelResult withDestinations(Collection<OutputDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public List<ChannelEgressEndpoint> getEgressEndpoints() {
        return this.egressEndpoints;
    }

    public void setEgressEndpoints(Collection<ChannelEgressEndpoint> egressEndpoints) {
        if (egressEndpoints == null) {
            this.egressEndpoints = null;
            return;
        }
        this.egressEndpoints = new ArrayList<ChannelEgressEndpoint>(egressEndpoints);
    }

    public DescribeChannelResult withEgressEndpoints(ChannelEgressEndpoint ... egressEndpoints) {
        if (this.egressEndpoints == null) {
            this.setEgressEndpoints(new ArrayList<ChannelEgressEndpoint>(egressEndpoints.length));
        }
        for (ChannelEgressEndpoint ele : egressEndpoints) {
            this.egressEndpoints.add(ele);
        }
        return this;
    }

    public DescribeChannelResult withEgressEndpoints(Collection<ChannelEgressEndpoint> egressEndpoints) {
        this.setEgressEndpoints(egressEndpoints);
        return this;
    }

    public void setEncoderSettings(EncoderSettings encoderSettings) {
        this.encoderSettings = encoderSettings;
    }

    public EncoderSettings getEncoderSettings() {
        return this.encoderSettings;
    }

    public DescribeChannelResult withEncoderSettings(EncoderSettings encoderSettings) {
        this.setEncoderSettings(encoderSettings);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public DescribeChannelResult withId(String id) {
        this.setId(id);
        return this;
    }

    public List<InputAttachment> getInputAttachments() {
        return this.inputAttachments;
    }

    public void setInputAttachments(Collection<InputAttachment> inputAttachments) {
        if (inputAttachments == null) {
            this.inputAttachments = null;
            return;
        }
        this.inputAttachments = new ArrayList<InputAttachment>(inputAttachments);
    }

    public DescribeChannelResult withInputAttachments(InputAttachment ... inputAttachments) {
        if (this.inputAttachments == null) {
            this.setInputAttachments(new ArrayList<InputAttachment>(inputAttachments.length));
        }
        for (InputAttachment ele : inputAttachments) {
            this.inputAttachments.add(ele);
        }
        return this;
    }

    public DescribeChannelResult withInputAttachments(Collection<InputAttachment> inputAttachments) {
        this.setInputAttachments(inputAttachments);
        return this;
    }

    public void setInputSpecification(InputSpecification inputSpecification) {
        this.inputSpecification = inputSpecification;
    }

    public InputSpecification getInputSpecification() {
        return this.inputSpecification;
    }

    public DescribeChannelResult withInputSpecification(InputSpecification inputSpecification) {
        this.setInputSpecification(inputSpecification);
        return this;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public DescribeChannelResult withLogLevel(String logLevel) {
        this.setLogLevel(logLevel);
        return this;
    }

    public DescribeChannelResult withLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DescribeChannelResult withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPipelinesRunningCount(Integer pipelinesRunningCount) {
        this.pipelinesRunningCount = pipelinesRunningCount;
    }

    public Integer getPipelinesRunningCount() {
        return this.pipelinesRunningCount;
    }

    public DescribeChannelResult withPipelinesRunningCount(Integer pipelinesRunningCount) {
        this.setPipelinesRunningCount(pipelinesRunningCount);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public DescribeChannelResult withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public DescribeChannelResult withState(String state) {
        this.setState(state);
        return this;
    }

    public DescribeChannelResult withState(ChannelState state) {
        this.state = state.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getEgressEndpoints() != null) {
            sb.append("EgressEndpoints: ").append(this.getEgressEndpoints()).append(",");
        }
        if (this.getEncoderSettings() != null) {
            sb.append("EncoderSettings: ").append(this.getEncoderSettings()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getInputAttachments() != null) {
            sb.append("InputAttachments: ").append(this.getInputAttachments()).append(",");
        }
        if (this.getInputSpecification() != null) {
            sb.append("InputSpecification: ").append(this.getInputSpecification()).append(",");
        }
        if (this.getLogLevel() != null) {
            sb.append("LogLevel: ").append(this.getLogLevel()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPipelinesRunningCount() != null) {
            sb.append("PipelinesRunningCount: ").append(this.getPipelinesRunningCount()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChannelResult)) {
            return false;
        }
        DescribeChannelResult other = (DescribeChannelResult)obj;
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getEgressEndpoints() == null ^ this.getEgressEndpoints() == null) {
            return false;
        }
        if (other.getEgressEndpoints() != null && !other.getEgressEndpoints().equals(this.getEgressEndpoints())) {
            return false;
        }
        if (other.getEncoderSettings() == null ^ this.getEncoderSettings() == null) {
            return false;
        }
        if (other.getEncoderSettings() != null && !other.getEncoderSettings().equals(this.getEncoderSettings())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getInputAttachments() == null ^ this.getInputAttachments() == null) {
            return false;
        }
        if (other.getInputAttachments() != null && !other.getInputAttachments().equals(this.getInputAttachments())) {
            return false;
        }
        if (other.getInputSpecification() == null ^ this.getInputSpecification() == null) {
            return false;
        }
        if (other.getInputSpecification() != null && !other.getInputSpecification().equals(this.getInputSpecification())) {
            return false;
        }
        if (other.getLogLevel() == null ^ this.getLogLevel() == null) {
            return false;
        }
        if (other.getLogLevel() != null && !other.getLogLevel().equals(this.getLogLevel())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPipelinesRunningCount() == null ^ this.getPipelinesRunningCount() == null) {
            return false;
        }
        if (other.getPipelinesRunningCount() != null && !other.getPipelinesRunningCount().equals(this.getPipelinesRunningCount())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        return other.getState() == null || other.getState().equals(this.getState());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getEgressEndpoints() == null ? 0 : this.getEgressEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getEncoderSettings() == null ? 0 : this.getEncoderSettings().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getInputAttachments() == null ? 0 : this.getInputAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getInputSpecification() == null ? 0 : this.getInputSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getLogLevel() == null ? 0 : this.getLogLevel().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPipelinesRunningCount() == null ? 0 : this.getPipelinesRunningCount().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        return hashCode;
    }

    public DescribeChannelResult clone() {
        try {
            return (DescribeChannelResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

