/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediastore.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediastore.model.CorsRule;
import java.util.List;

@SdkInternalApi
public class CorsRuleMarshaller {
    private static final MarshallingInfo<List> ALLOWEDORIGINS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedOrigins").build();
    private static final MarshallingInfo<List> ALLOWEDMETHODS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedMethods").build();
    private static final MarshallingInfo<List> ALLOWEDHEADERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedHeaders").build();
    private static final MarshallingInfo<Integer> MAXAGESECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxAgeSeconds").build();
    private static final MarshallingInfo<List> EXPOSEHEADERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExposeHeaders").build();
    private static final CorsRuleMarshaller instance = new CorsRuleMarshaller();

    public static CorsRuleMarshaller getInstance() {
        return instance;
    }

    public void marshall(CorsRule corsRule, ProtocolMarshaller protocolMarshaller) {
        if (corsRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(corsRule.getAllowedOrigins(), ALLOWEDORIGINS_BINDING);
            protocolMarshaller.marshall(corsRule.getAllowedMethods(), ALLOWEDMETHODS_BINDING);
            protocolMarshaller.marshall(corsRule.getAllowedHeaders(), ALLOWEDHEADERS_BINDING);
            protocolMarshaller.marshall((Object)corsRule.getMaxAgeSeconds(), MAXAGESECONDS_BINDING);
            protocolMarshaller.marshall(corsRule.getExposeHeaders(), EXPOSEHEADERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

