/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.secretsmanager.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.secretsmanager.model.SecretVersionsListEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSecretVersionIdsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<SecretVersionsListEntry> versions;
    private String nextToken;
    private String aRN;
    private String name;

    public List<SecretVersionsListEntry> getVersions() {
        return this.versions;
    }

    public void setVersions(Collection<SecretVersionsListEntry> versions) {
        if (versions == null) {
            this.versions = null;
            return;
        }
        this.versions = new ArrayList<SecretVersionsListEntry>(versions);
    }

    public ListSecretVersionIdsResult withVersions(SecretVersionsListEntry ... versions) {
        if (this.versions == null) {
            this.setVersions(new ArrayList<SecretVersionsListEntry>(versions.length));
        }
        for (SecretVersionsListEntry ele : versions) {
            this.versions.add(ele);
        }
        return this;
    }

    public ListSecretVersionIdsResult withVersions(Collection<SecretVersionsListEntry> versions) {
        this.setVersions(versions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSecretVersionIdsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public ListSecretVersionIdsResult withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ListSecretVersionIdsResult withName(String name) {
        this.setName(name);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersions() != null) {
            sb.append("Versions: ").append(this.getVersions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecretVersionIdsResult)) {
            return false;
        }
        ListSecretVersionIdsResult other = (ListSecretVersionIdsResult)obj;
        if (other.getVersions() == null ^ this.getVersions() == null) {
            return false;
        }
        if (other.getVersions() != null && !other.getVersions().equals(this.getVersions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        return other.getName() == null || other.getName().equals(this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersions() == null ? 0 : this.getVersions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        return hashCode;
    }

    public ListSecretVersionIdsResult clone() {
        try {
            return (ListSecretVersionIdsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

