/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.common;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.common.FlowValueConstraint;
import com.amazonaws.services.simpleworkflow.model.CloseStatus;
import com.amazonaws.services.simpleworkflow.model.Decision;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.EventType;
import com.amazonaws.services.simpleworkflow.model.ExecutionStatus;
import com.amazonaws.services.simpleworkflow.model.GetWorkflowExecutionHistoryRequest;
import com.amazonaws.services.simpleworkflow.model.History;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionCompletedEventAttributes;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionContinuedAsNewEventAttributes;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfo;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class WorkflowExecutionUtils {
    public static WorkflowExecutionCompletedEventAttributes waitForWorkflowExecutionResult(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution) throws InterruptedException {
        try {
            return WorkflowExecutionUtils.waitForWorkflowExecutionResult(service, domain, workflowExecution, 0L);
        }
        catch (TimeoutException e) {
            throw new Error("should never happen", e);
        }
    }

    public static WorkflowExecutionCompletedEventAttributes waitForWorkflowExecutionResult(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution, long timeoutSeconds) throws InterruptedException, TimeoutException {
        if (!WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, workflowExecution, timeoutSeconds).equals(CloseStatus.COMPLETED.toString())) {
            String historyDump = WorkflowExecutionUtils.prettyPrintHistory(service, domain, workflowExecution);
            throw new RuntimeException("Workflow instance is not in completed state:\n" + historyDump);
        }
        return WorkflowExecutionUtils.getWorkflowExecutionResult(service, domain, workflowExecution);
    }

    public static WorkflowExecutionCompletedEventAttributes getWorkflowExecutionResult(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution) {
        HistoryEvent closeEvent = WorkflowExecutionUtils.getInstanceCloseEvent(service, domain, workflowExecution);
        if (closeEvent == null) {
            throw new IllegalStateException("Workflow is still running");
        }
        if (closeEvent.getEventType().equals(EventType.WorkflowExecutionCompleted.toString())) {
            return closeEvent.getWorkflowExecutionCompletedEventAttributes();
        }
        throw new RuntimeException("Workflow end state is not completed: " + WorkflowExecutionUtils.prettyPrintHistoryEvent(closeEvent));
    }

    public static HistoryEvent getInstanceCloseEvent(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution) {
        WorkflowExecutionInfo executionInfo = WorkflowExecutionUtils.describeWorkflowInstance(service, domain, workflowExecution);
        if (executionInfo == null || executionInfo.getExecutionStatus().equals(ExecutionStatus.OPEN.toString())) {
            return null;
        }
        List<HistoryEvent> events = WorkflowExecutionUtils.getHistory(service, domain, workflowExecution);
        HistoryEvent result = null;
        for (HistoryEvent event : events) {
            if (!WorkflowExecutionUtils.isWorkflowExecutionCompletedEvent(event)) continue;
            result = event;
            break;
        }
        return result;
    }

    public static boolean isWorkflowExecutionCompletedEvent(HistoryEvent event) {
        return event != null && (event.getEventType().equals(EventType.WorkflowExecutionCompleted.toString()) || event.getEventType().equals(EventType.WorkflowExecutionCanceled.toString()) || event.getEventType().equals(EventType.WorkflowExecutionFailed.toString()) || event.getEventType().equals(EventType.WorkflowExecutionTimedOut.toString()) || event.getEventType().equals(EventType.WorkflowExecutionContinuedAsNew.toString()) || event.getEventType().equals(EventType.WorkflowExecutionTerminated.toString()));
    }

    public static boolean isActivityTaskClosedEvent(HistoryEvent event) {
        return event != null && (event.getEventType().equals(EventType.ActivityTaskCompleted.toString()) || event.getEventType().equals(EventType.ActivityTaskCanceled.toString()) || event.getEventType().equals(EventType.ActivityTaskFailed.toString()) || event.getEventType().equals(EventType.ActivityTaskTimedOut.toString()));
    }

    public static boolean isExternalWorkflowClosedEvent(HistoryEvent event) {
        return event != null && (event.getEventType().equals(EventType.ChildWorkflowExecutionCompleted.toString()) || event.getEventType().equals(EventType.ChildWorkflowExecutionCanceled.toString()) || event.getEventType().equals(EventType.ChildWorkflowExecutionFailed.toString()) || event.getEventType().equals(EventType.ChildWorkflowExecutionTerminated.toString()) || event.getEventType().equals(EventType.ChildWorkflowExecutionTimedOut.toString()));
    }

    public static WorkflowExecution getWorkflowIdFromExternalWorkflowCompletedEvent(HistoryEvent event) {
        if (event != null) {
            if (event.getEventType().equals(EventType.ChildWorkflowExecutionCompleted.toString())) {
                return event.getChildWorkflowExecutionCompletedEventAttributes().getWorkflowExecution();
            }
            if (event.getEventType().equals(EventType.ChildWorkflowExecutionCanceled.toString())) {
                return event.getChildWorkflowExecutionCanceledEventAttributes().getWorkflowExecution();
            }
            if (event.getEventType().equals(EventType.ChildWorkflowExecutionFailed.toString())) {
                return event.getChildWorkflowExecutionFailedEventAttributes().getWorkflowExecution();
            }
            if (event.getEventType().equals(EventType.ChildWorkflowExecutionTerminated.toString())) {
                return event.getChildWorkflowExecutionTerminatedEventAttributes().getWorkflowExecution();
            }
            if (event.getEventType().equals(EventType.ChildWorkflowExecutionTimedOut.toString())) {
                return event.getChildWorkflowExecutionTimedOutEventAttributes().getWorkflowExecution();
            }
        }
        return null;
    }

    public static String getId(HistoryEvent historyEvent) {
        String id = null;
        if (historyEvent != null) {
            if (historyEvent.getEventType().equals(EventType.StartChildWorkflowExecutionFailed.toString())) {
                id = historyEvent.getStartChildWorkflowExecutionFailedEventAttributes().getWorkflowId();
            } else if (historyEvent.getEventType().equals(EventType.ScheduleActivityTaskFailed.toString())) {
                id = historyEvent.getScheduleActivityTaskFailedEventAttributes().getActivityId();
            } else if (historyEvent.getEventType().equals(EventType.StartTimerFailed.toString())) {
                id = historyEvent.getStartTimerFailedEventAttributes().getTimerId();
            }
        }
        return id;
    }

    public static String getFailureCause(HistoryEvent historyEvent) {
        String failureCause = null;
        if (historyEvent != null) {
            if (historyEvent.getEventType().equals(EventType.StartChildWorkflowExecutionFailed.toString())) {
                failureCause = historyEvent.getStartChildWorkflowExecutionFailedEventAttributes().getCause();
            } else if (historyEvent.getEventType().equals(EventType.SignalExternalWorkflowExecutionFailed.toString())) {
                failureCause = historyEvent.getSignalExternalWorkflowExecutionFailedEventAttributes().getCause();
            } else if (historyEvent.getEventType().equals(EventType.ScheduleActivityTaskFailed.toString())) {
                failureCause = historyEvent.getScheduleActivityTaskFailedEventAttributes().getCause();
            } else if (historyEvent.getEventType().equals(EventType.StartTimerFailed.toString())) {
                failureCause = historyEvent.getStartTimerFailedEventAttributes().getCause();
            } else if (historyEvent.getEventType().equals(EventType.ContinueAsNewWorkflowExecutionFailed.toString())) {
                failureCause = historyEvent.getContinueAsNewWorkflowExecutionFailedEventAttributes().getCause();
            } else if (historyEvent.getEventType().equals(EventType.RecordMarkerFailed.toString())) {
                failureCause = historyEvent.getRecordMarkerFailedEventAttributes().getCause();
            }
        }
        return failureCause;
    }

    public static String waitForWorkflowInstanceCompletion(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution) throws InterruptedException {
        try {
            return WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, workflowExecution, 0L);
        }
        catch (TimeoutException e) {
            throw new Error("should never happen", e);
        }
    }

    public static String waitForWorkflowInstanceCompletion(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution, long timeoutSeconds) throws InterruptedException, TimeoutException {
        long start = System.currentTimeMillis();
        WorkflowExecutionInfo executionInfo = null;
        do {
            if (timeoutSeconds > 0L && System.currentTimeMillis() - start >= timeoutSeconds * 1000L) {
                String historyDump = WorkflowExecutionUtils.prettyPrintHistory(service, domain, workflowExecution);
                throw new TimeoutException("Workflow instance is not complete after " + timeoutSeconds + " seconds: \n" + historyDump);
            }
            if (executionInfo == null) continue;
            Thread.sleep(1000L);
        } while ((executionInfo = WorkflowExecutionUtils.describeWorkflowInstance(service, domain, workflowExecution)).getExecutionStatus().equals(ExecutionStatus.OPEN.toString()));
        return executionInfo.getCloseStatus();
    }

    public static String waitForWorkflowInstanceCompletionAcrossGenerations(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution, long timeoutSeconds) throws InterruptedException, TimeoutException {
        WorkflowExecution lastExecutionToRun = workflowExecution;
        long millisecondsAtFirstWait = System.currentTimeMillis();
        String lastExecutionToRunCloseStatus = WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, lastExecutionToRun, timeoutSeconds);
        while (lastExecutionToRunCloseStatus.equals(CloseStatus.CONTINUED_AS_NEW.toString())) {
            HistoryEvent closeEvent = WorkflowExecutionUtils.getInstanceCloseEvent(service, domain, lastExecutionToRun);
            WorkflowExecutionContinuedAsNewEventAttributes continuedAsNewAttributes = closeEvent.getWorkflowExecutionContinuedAsNewEventAttributes();
            WorkflowExecution newGenerationExecution = new WorkflowExecution().withWorkflowId(lastExecutionToRun.getWorkflowId()).withRunId(continuedAsNewAttributes.getNewExecutionRunId());
            long currentTime = System.currentTimeMillis();
            long millisecondsSinceFirstWait = currentTime - millisecondsAtFirstWait;
            long timeoutInSecondsForNextWait = timeoutSeconds - millisecondsSinceFirstWait / 1000L;
            lastExecutionToRunCloseStatus = WorkflowExecutionUtils.waitForWorkflowInstanceCompletion(service, domain, newGenerationExecution, timeoutInSecondsForNextWait);
            lastExecutionToRun = newGenerationExecution;
        }
        return lastExecutionToRunCloseStatus;
    }

    public static String waitForWorkflowInstanceCompletionAcrossGenerations(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution) throws InterruptedException {
        try {
            return WorkflowExecutionUtils.waitForWorkflowInstanceCompletionAcrossGenerations(service, domain, workflowExecution, 0L);
        }
        catch (TimeoutException e) {
            throw new Error("should never happen", e);
        }
    }

    public static WorkflowExecutionInfo describeWorkflowInstance(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution) {
        DescribeWorkflowExecutionRequest describeRequest = new DescribeWorkflowExecutionRequest();
        describeRequest.setDomain(domain);
        describeRequest.setExecution(workflowExecution);
        WorkflowExecutionDetail executionDetail = service.describeWorkflowExecution(describeRequest);
        WorkflowExecutionInfo instanceMetadata = executionDetail.getExecutionInfo();
        return instanceMetadata;
    }

    public static String prettyPrintHistory(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution) {
        return WorkflowExecutionUtils.prettyPrintHistory(service, domain, workflowExecution, true);
    }

    public static String prettyPrintHistory(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution, boolean showWorkflowTasks) {
        List<HistoryEvent> events = WorkflowExecutionUtils.getHistory(service, domain, workflowExecution);
        return WorkflowExecutionUtils.prettyPrintHistory(events, showWorkflowTasks);
    }

    public static List<HistoryEvent> getHistory(AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution) {
        History history;
        ArrayList<HistoryEvent> events = new ArrayList<HistoryEvent>();
        String nextPageToken = null;
        do {
            history = WorkflowExecutionUtils.getHistoryPage(nextPageToken, service, domain, workflowExecution);
            events.addAll(history.getEvents());
        } while ((nextPageToken = history.getNextPageToken()) != null);
        return events;
    }

    public static History getHistoryPage(String nextPageToken, AmazonSimpleWorkflow service, String domain, WorkflowExecution workflowExecution) {
        GetWorkflowExecutionHistoryRequest getHistoryRequest = new GetWorkflowExecutionHistoryRequest();
        getHistoryRequest.setDomain(domain);
        getHistoryRequest.setExecution(workflowExecution);
        getHistoryRequest.setNextPageToken(nextPageToken);
        History history = service.getWorkflowExecutionHistory(getHistoryRequest);
        if (history == null) {
            throw new IllegalArgumentException("unknown workflow execution: " + workflowExecution);
        }
        return history;
    }

    public static String prettyPrintHistory(History history, boolean showWorkflowTasks) {
        return WorkflowExecutionUtils.prettyPrintHistory(history.getEvents(), showWorkflowTasks);
    }

    public static String prettyPrintHistory(Iterable<HistoryEvent> events, boolean showWorkflowTasks) {
        StringBuffer result = new StringBuffer();
        result.append("{");
        boolean first = true;
        for (HistoryEvent event : events) {
            if (!showWorkflowTasks && event.getEventType().startsWith("WorkflowTask")) continue;
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append("\n    ");
            result.append(WorkflowExecutionUtils.prettyPrintHistoryEvent(event));
        }
        result.append("\n}");
        return result.toString();
    }

    public static String prettyPrintDecisions(Iterable<Decision> decisions) {
        StringBuffer result = new StringBuffer();
        result.append("{");
        boolean first = true;
        for (Decision decision : decisions) {
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append("\n    ");
            result.append(WorkflowExecutionUtils.prettyPrintDecision(decision));
        }
        result.append("\n}");
        return result.toString();
    }

    public static String prettyPrintHistoryEvent(HistoryEvent event) {
        String eventType = event.getEventType();
        StringBuffer result = new StringBuffer();
        result.append(eventType);
        result.append(WorkflowExecutionUtils.prettyPrintObject(event, "getType", true, "    ", false));
        return result.toString();
    }

    public static String prettyPrintDecision(Decision decision) {
        return WorkflowExecutionUtils.prettyPrintObject(decision, "getType", true, "    ", true);
    }

    private static String prettyPrintObject(Object object, String methodToSkip, boolean skipNullsAndEmptyCollections, String indentation, boolean skipLevel) {
        StringBuffer result = new StringBuffer();
        if (object == null) {
            return "null";
        }
        Class<?> clz = object.getClass();
        if (Number.class.isAssignableFrom(clz)) {
            return String.valueOf(object);
        }
        if (Boolean.class.isAssignableFrom(clz)) {
            return String.valueOf(object);
        }
        if (clz.equals(String.class)) {
            return (String)object;
        }
        if (clz.equals(Date.class)) {
            return String.valueOf(object);
        }
        if (Map.class.isAssignableFrom(clz)) {
            return String.valueOf(object);
        }
        if (Collection.class.isAssignableFrom(clz)) {
            return String.valueOf(object);
        }
        if (!skipLevel) {
            result.append(" {");
        }
        Method[] eventMethods = object.getClass().getMethods();
        boolean first = true;
        Method[] methodArray = eventMethods;
        int n = eventMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String name = method.getName();
            if (name.startsWith("get") && !name.equals(methodToSkip) && !name.equals("getClass") && !Modifier.isStatic(method.getModifiers())) {
                Object value;
                try {
                    value = method.invoke(object, null);
                    if (value != null && value.getClass().equals(String.class) && name.equals("getDetails")) {
                        value = WorkflowExecutionUtils.printDetails((String)value);
                    }
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getTargetException());
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!(skipNullsAndEmptyCollections && (value == null || value instanceof Map && ((Map)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty()))) {
                    if (!skipLevel) {
                        if (first) {
                            first = false;
                        } else {
                            result.append(";");
                        }
                        result.append("\n");
                        result.append(indentation);
                        result.append("    ");
                        result.append(name.substring(3));
                        result.append(" = ");
                        result.append(WorkflowExecutionUtils.prettyPrintObject(value, methodToSkip, skipNullsAndEmptyCollections, String.valueOf(indentation) + "    ", false));
                    } else {
                        result.append(WorkflowExecutionUtils.prettyPrintObject(value, methodToSkip, skipNullsAndEmptyCollections, indentation, false));
                    }
                }
            }
            ++n2;
        }
        if (!skipLevel) {
            result.append("\n");
            result.append(indentation);
            result.append("}");
        }
        return result.toString();
    }

    public static String printDetails(String details) {
        Throwable failure = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
            failure = (Throwable)mapper.readValue(details, Throwable.class);
        }
        catch (Exception exception) {}
        if (failure != null) {
            StringBuilder builder = new StringBuilder();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            failure.printStackTrace(pw);
            builder.append(sw.toString());
            details = builder.toString();
        }
        return details;
    }

    public static String truncateReason(String reason) {
        if (reason != null && reason.length() > FlowValueConstraint.FAILURE_REASON.getMaxSize()) {
            reason = reason.substring(0, FlowValueConstraint.FAILURE_REASON.getMaxSize());
        }
        return reason;
    }

    public static String truncateDetails(String details) {
        if (details != null && details.length() > FlowValueConstraint.FAILURE_DETAILS.getMaxSize()) {
            details = details.substring(0, FlowValueConstraint.FAILURE_DETAILS.getMaxSize());
        }
        return details;
    }
}

