/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.xray.model.AnnotationValue;

@SdkInternalApi
public class AnnotationValueMarshaller {
    private static final MarshallingInfo<Double> NUMBERVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberValue").build();
    private static final MarshallingInfo<Boolean> BOOLEANVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BooleanValue").build();
    private static final MarshallingInfo<String> STRINGVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StringValue").build();
    private static final AnnotationValueMarshaller instance = new AnnotationValueMarshaller();

    public static AnnotationValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(AnnotationValue annotationValue, ProtocolMarshaller protocolMarshaller) {
        if (annotationValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)annotationValue.getNumberValue(), NUMBERVALUE_BINDING);
            protocolMarshaller.marshall((Object)annotationValue.getBooleanValue(), BOOLEANVALUE_BINDING);
            protocolMarshaller.marshall((Object)annotationValue.getStringValue(), STRINGVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

