/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner.junit3;

import android.support.test.internal.runner.junit3.AndroidTestSuite;
import android.support.test.internal.runner.junit3.JUnit38ClassRunner;
import android.support.test.internal.util.AndroidRunnerParams;
import android.util.Log;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.internal.builders.SuiteMethodBuilder;
import org.junit.internal.runners.SuiteMethod;
import org.junit.runner.Runner;

public class AndroidSuiteBuilder
extends SuiteMethodBuilder {
    private static final String LOG_TAG = "AndroidSuiteBuilder";
    private final AndroidRunnerParams mAndroidRunnerParams;

    public AndroidSuiteBuilder(AndroidRunnerParams runnerParams) {
        this.mAndroidRunnerParams = runnerParams;
    }

    public Runner runnerForClass(Class<?> testClass) throws Throwable {
        if (this.mAndroidRunnerParams.isIgnoreSuiteMethods()) {
            return null;
        }
        try {
            if (this.hasSuiteMethod(testClass)) {
                Test t = SuiteMethod.testFromSuiteMethod(testClass);
                if (!(t instanceof TestSuite)) {
                    throw new IllegalArgumentException(String.valueOf(testClass.getName()).concat("#suite() did not return a TestSuite"));
                }
                return new JUnit38ClassRunner((Test)new AndroidTestSuite((TestSuite)t, this.mAndroidRunnerParams));
            }
        }
        catch (Throwable e) {
            Log.e((String)LOG_TAG, (String)"Error constructing runner", (Throwable)e);
            throw e;
        }
        return null;
    }
}

