/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.internal.runner.listener;

import android.util.Log;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class LogRunListener
extends RunListener {
    private static final String TAG = "TestRunner";

    public void testRunStarted(Description description) throws Exception {
        Log.i((String)TAG, (String)String.format("run started: %d tests", description.testCount()));
    }

    public void testRunFinished(Result result) throws Exception {
        Log.i((String)TAG, (String)String.format("run finished: %d tests, %d failed, %d ignored", result.getRunCount(), result.getFailureCount(), result.getIgnoreCount()));
    }

    public void testStarted(Description description) throws Exception {
        String string = String.valueOf(description.getDisplayName());
        Log.i((String)TAG, (String)(string.length() != 0 ? "started: ".concat(string) : new String("started: ")));
    }

    public void testFinished(Description description) throws Exception {
        String string = String.valueOf(description.getDisplayName());
        Log.i((String)TAG, (String)(string.length() != 0 ? "finished: ".concat(string) : new String("finished: ")));
    }

    public void testFailure(Failure failure) throws Exception {
        String string = String.valueOf(failure.getDescription().getDisplayName());
        Log.i((String)TAG, (String)(string.length() != 0 ? "failed: ".concat(string) : new String("failed: ")));
        Log.i((String)TAG, (String)"----- begin exception -----");
        Log.i((String)TAG, (String)failure.getTrace());
        Log.i((String)TAG, (String)"----- end exception -----");
    }

    public void testAssumptionFailure(Failure failure) {
        String string = String.valueOf(failure.getDescription().getDisplayName());
        Log.i((String)TAG, (String)(string.length() != 0 ? "assumption failed: ".concat(string) : new String("assumption failed: ")));
        Log.i((String)TAG, (String)"----- begin exception -----");
        Log.i((String)TAG, (String)failure.getTrace());
        Log.i((String)TAG, (String)"----- end exception -----");
    }

    public void testIgnored(Description description) throws Exception {
        String string = String.valueOf(description.getDisplayName());
        Log.i((String)TAG, (String)(string.length() != 0 ? "ignored: ".concat(string) : new String("ignored: ")));
    }
}

