/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.orchestrator.junit;

import android.os.Parcel;
import android.os.Parcelable;
import org.junit.runner.Description;

public final class ParcelableDescription
implements Parcelable {
    private final String mClassName;
    private final String mMethodName;
    private final String mDisplayName;
    public static final Parcelable.Creator<ParcelableDescription> CREATOR = new Parcelable.Creator<ParcelableDescription>(){

        public ParcelableDescription createFromParcel(Parcel in) {
            return new ParcelableDescription(in);
        }

        public ParcelableDescription[] newArray(int size) {
            return new ParcelableDescription[size];
        }
    };

    public ParcelableDescription(Description description) {
        this.mClassName = description.getClassName();
        this.mMethodName = description.getMethodName();
        this.mDisplayName = description.getDisplayName();
    }

    public ParcelableDescription(String classAndMethodName) {
        String[] classAndMethodNames = classAndMethodName.split("#");
        this.mClassName = classAndMethodNames[0];
        this.mMethodName = classAndMethodNames.length > 1 ? classAndMethodNames[1] : "";
        this.mDisplayName = classAndMethodName;
    }

    private ParcelableDescription(Parcel in) {
        this.mClassName = this.getNonNullString(in);
        this.mMethodName = this.getNonNullString(in);
        this.mDisplayName = this.getNonNullString(in);
    }

    private String getNonNullString(Parcel in) {
        String str = in.readString();
        return str == null ? "" : str;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mClassName);
        out.writeString(this.mMethodName);
        out.writeString(this.mDisplayName);
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getMethodName() {
        return this.mMethodName;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }
}

