/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner.intercepting;

import android.app.Activity;
import android.content.Intent;
import android.support.test.internal.util.Checks;
import android.support.test.runner.intercepting.InterceptingActivityFactory;

public abstract class SingleActivityFactory<T extends Activity>
implements InterceptingActivityFactory {
    private final Class<T> mActivityClassToIntercept;

    public SingleActivityFactory(Class<T> activityClassToIntercept) {
        Checks.checkNotNull(activityClassToIntercept);
        this.mActivityClassToIntercept = (Class)Checks.checkNotNull(activityClassToIntercept);
    }

    public final boolean shouldIntercept(ClassLoader classLoader, String className, Intent intent) {
        return this.mActivityClassToIntercept.getName().equals(className);
    }

    public final Activity create(ClassLoader classLoader, String className, Intent intent) {
        if (!this.shouldIntercept(classLoader, className, intent)) {
            throw new UnsupportedOperationException(String.format("Can't create instance of %s", className));
        }
        return this.create(intent);
    }

    public final Class<T> getActivityClassToIntercept() {
        return this.mActivityClassToIntercept;
    }

    protected abstract T create(Intent var1);
}

