/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.runner.permission;

import android.annotation.TargetApi;
import android.app.UiAutomation;
import android.os.ParcelFileDescriptor;
import android.support.annotation.VisibleForTesting;
import android.support.test.InstrumentationRegistry;
import android.support.test.internal.util.Checks;
import android.support.test.runner.permission.ShellCommand;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@TargetApi(value=23)
class UiAutomationShellCommand
extends ShellCommand {
    private static final String TAG = "UiAutomationShellCmd";
    private final String mTargetPackage;
    private final String mPermission;
    private final PmCommand mCommand;
    private final UiAutomation mUiAutomation;

    UiAutomationShellCommand(String targetPackage, String permission, PmCommand pmCommand) {
        this.mTargetPackage = UiAutomationShellCommand.shellEscape(targetPackage);
        this.mPermission = UiAutomationShellCommand.shellEscape(permission);
        this.mCommand = pmCommand;
        this.mUiAutomation = (UiAutomation)Checks.checkNotNull((Object)InstrumentationRegistry.getInstrumentation().getUiAutomation());
    }

    @Override
    public void execute() throws Exception {
        this.executePermissionCommand(this.commandForPermission());
    }

    @VisibleForTesting
    protected String commandForPermission() {
        return this.mCommand.get() + " " + this.mTargetPackage + " " + this.mPermission;
    }

    private void executePermissionCommand(String cmd) throws IOException {
        String string = String.valueOf(cmd);
        Log.i((String)TAG, (String)(string.length() != 0 ? "Requesting permission: ".concat(string) : new String("Requesting permission: ")));
        try {
            UiAutomationShellCommand.awaitTermination(this.mUiAutomation.executeShellCommand(cmd), 2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            String string2 = String.valueOf(cmd);
            Log.e((String)TAG, (String)(string2.length() != 0 ? "Timeout while executing cmd: ".concat(string2) : new String("Timeout while executing cmd: ")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void awaitTermination(ParcelFileDescriptor pfDescriptor, long timeout, TimeUnit unit) throws IOException, TimeoutException {
        long timeoutInMillis = unit.toMillis(timeout);
        long endTimeInMillis = timeoutInMillis > 0L ? System.currentTimeMillis() + timeoutInMillis : 0L;
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(pfDescriptor)));
            while ((line = reader.readLine()) != null) {
                Log.i((String)TAG, (String)line);
                if (endTimeInMillis <= System.currentTimeMillis()) continue;
                throw new TimeoutException();
            }
        }
    }

    static enum PmCommand {
        GRANT_PERMISSION("grant");

        private final String mPmCommand;

        private PmCommand(String command) {
            String string2 = String.valueOf(command);
            this.mPmCommand = string2.length() != 0 ? "pm ".concat(string2) : new String("pm ");
        }

        public String get() {
            return this.mPmCommand;
        }
    }
}

