/*
 * Decompiled with CFR 0.152.
 */
package com.antherd.smcrypto.sm2;

import com.antherd.smcrypto.sm2.Keypair;
import com.antherd.smcrypto.sm2.Point;
import com.antherd.smcrypto.sm2.SignatureOptions;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class Sm2 {
    private static Invocable invocable = null;

    public static Keypair generateKeyPairHex() {
        ScriptObjectMirror scriptObjectMirror = null;
        try {
            scriptObjectMirror = (ScriptObjectMirror)invocable.invokeFunction("generateKeyPairHex", new Object[0]);
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
        return new Keypair((String)scriptObjectMirror.get((Object)"privateKey"), (String)scriptObjectMirror.get((Object)"publicKey"));
    }

    public static String doEncrypt(String msg, String publicKey, int cipherMode) {
        if (msg == null || msg.trim().isEmpty()) {
            return "";
        }
        String encryptMsg = null;
        try {
            Object[] param = new Object[]{msg, publicKey, cipherMode};
            encryptMsg = (String)invocable.invokeFunction("doEncrypt", param);
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
        return encryptMsg;
    }

    public static String doEncrypt(String msg, String publicKey) {
        return Sm2.doEncrypt(msg, publicKey, 1);
    }

    public static String doDecrypt(String encryptData, String privateKey, int cipherMode) {
        if (encryptData == null || encryptData.trim().isEmpty()) {
            return "";
        }
        String msg = null;
        try {
            Object[] param = new Object[]{encryptData, privateKey, cipherMode};
            msg = (String)invocable.invokeFunction("doDecrypt", param);
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
        return msg;
    }

    public static String doDecrypt(String encryptData, String privateKey) {
        return Sm2.doDecrypt(encryptData, privateKey, 1);
    }

    public static String doSignature(String msg, String publicKey, SignatureOptions signatureOptions) {
        String signature = null;
        try {
            signature = (String)invocable.invokeFunction("doSignature", msg, publicKey, Sm2.getOptionsMap(signatureOptions));
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
        return signature;
    }

    public static String doSignature(String msg, String publicKey) {
        return Sm2.doSignature(msg, publicKey, null);
    }

    public static boolean doVerifySignature(String msg, String signHex, String publicKey, SignatureOptions signatureOptions) {
        boolean result = false;
        try {
            result = (Boolean)invocable.invokeFunction("doVerifySignature", msg, signHex, publicKey, Sm2.getOptionsMap(signatureOptions));
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean doVerifySignature(String msg, String signHex, String publicKey) {
        return Sm2.doVerifySignature(msg, signHex, publicKey, null);
    }

    private static Map<String, Object> getOptionsMap(SignatureOptions signatureOptions) {
        String userId;
        String publicKey;
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (signatureOptions == null) {
            return options;
        }
        if (signatureOptions.getPointPool() != null && signatureOptions.getPointPool().size() == 4) {
            options.put("pointPool", signatureOptions.getPointPool());
        }
        if (signatureOptions.isDer()) {
            options.put("der", signatureOptions.isDer());
        }
        if (signatureOptions.isHash()) {
            options.put("hash", signatureOptions.isHash());
        }
        if ((publicKey = signatureOptions.getPublicKey()) != null && !publicKey.trim().equals("")) {
            options.put("publicKey", publicKey);
        }
        if ((userId = signatureOptions.getUserId()) != null && !userId.trim().equals("")) {
            options.put("userId", userId);
        }
        return options;
    }

    public static Point getPoint() {
        Point point = null;
        try {
            ScriptObjectMirror invokeResult = (ScriptObjectMirror)invocable.invokeFunction("getPoint", new Object[0]);
            point = new Point((String)invokeResult.get((Object)"privateKey"), (String)invokeResult.get((Object)"publicKey"), (Map)invokeResult.get((Object)"k"), (Map)invokeResult.get((Object)"x1"));
        }
        catch (NoSuchMethodException | ScriptException e) {
            e.printStackTrace();
        }
        return point;
    }

    static {
        try {
            InputStream inputStream = Sm2.class.getClassLoader().getResourceAsStream("sm2.js");
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
            engine.eval(new BufferedReader(new InputStreamReader(inputStream)));
            invocable = (Invocable)((Object)engine);
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }
}

