/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.nonxa;

import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.jdbc.AbstractDataSourceBean;
import com.atomikos.jdbc.nonxa.AtomikosNonXAConnectionFactory;
import com.atomikos.jdbc.nonxa.AtomikosThreadLocalConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.DynamicProxy;
import java.sql.Connection;
import java.sql.SQLException;

public class AtomikosNonXADataSourceBean
extends AbstractDataSourceBean {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosNonXADataSourceBean.class);
    private static final long serialVersionUID = 1L;
    private String url;
    private String user;
    private String password;
    private String driverClassName;
    private boolean readOnly;

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String string) {
        this.driverClassName = string;
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected ConnectionFactory doInit() throws Exception {
        AtomikosNonXAConnectionFactory ret = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logInfo(this + ": initializing with [" + " uniqueResourceName=" + this.getUniqueResourceName() + "," + " maxPoolSize=" + this.getMaxPoolSize() + "," + " minPoolSize=" + this.getMinPoolSize() + "," + " borrowConnectionTimeout=" + this.getBorrowConnectionTimeout() + "," + " maxIdleTime=" + this.getMaxIdleTime() + "," + " reapTimeout=" + this.getReapTimeout() + "," + " maintenanceInterval=" + this.getMaintenanceInterval() + "," + " testQuery=" + this.getTestQuery() + "," + " driverClassName=" + this.getDriverClassName() + "," + " user=" + this.getUser() + "," + " url=" + this.getUrl() + " loginTimeout=" + this.getLoginTimeout() + "]");
        }
        ret = new AtomikosNonXAConnectionFactory(this, this.url, this.driverClassName, this.user, this.password, this.getLoginTimeout(), this.readOnly);
        ret.init();
        return ret;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(this + ": getConnection()...");
        }
        this.init();
        Connection proxy = super.getConnection();
        DynamicProxy dproxy = (DynamicProxy)proxy;
        AtomikosThreadLocalConnection previous = (AtomikosThreadLocalConnection)dproxy.getInvocationHandler();
        previous.incUseCount();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": returning " + proxy);
        }
        return proxy;
    }

    public String toString() {
        String ret = "AtomikosNonXADataSourceBean";
        String name = this.getUniqueResourceName();
        if (name != null) {
            ret = ret + " '" + name + "'";
        }
        return ret;
    }

    @Override
    protected boolean isAssignableFromWrappedVendorClass(Class<?> iface) {
        return false;
    }

    @Override
    protected Object unwrapVendorInstance() {
        throw new UnsupportedOperationException();
    }
}

