/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.imp;

import com.atomikos.recovery.CoordinatorLogEntry;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.LogReadException;
import com.atomikos.recovery.OltpLog;
import com.atomikos.recovery.Repository;

public class OltpLogImp
implements OltpLog {
    private Repository repository;

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void write(CoordinatorLogEntry coordinatorLogEntry) throws IllegalStateException, LogException {
        this.assertEntryIsAllowedInCurrentState(coordinatorLogEntry);
        this.repository.put(coordinatorLogEntry.id, coordinatorLogEntry);
    }

    private void assertEntryIsAllowedInCurrentState(CoordinatorLogEntry coordinatorLogEntry) throws IllegalStateException, LogReadException {
        CoordinatorLogEntry existing = this.repository.get(coordinatorLogEntry.id);
        if (!coordinatorLogEntry.transitionAllowedFrom(existing)) {
            String existingState = "NONE";
            if (existing != null) {
                existingState = existing.getResultingState().toString();
            }
            throw new IllegalStateException("Existing entry: " + existingState + " incompatible with new entry: " + coordinatorLogEntry.getResultingState());
        }
    }

    public void close() {
        this.repository.close();
    }
}

