/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client;

import com.baidu.brpc.client.RpcFuture;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastFutureStore {
    private static final Logger LOG = LoggerFactory.getLogger(FastFutureStore.class);
    private static final int DEFAULT_ARRAY_CAP = 10000;
    private static volatile FastFutureStore singletonInstance;
    private AtomicReferenceArray<RpcFuture> futArray;
    private AtomicLong slotCounter = new AtomicLong(0L);
    private int cap;
    private Map<Long, RpcFuture> backupMap = new ConcurrentHashMap<Long, RpcFuture>();
    private static long COUNTER_VALUE_BOUNDARY;

    public FastFutureStore(int cap) {
        if (cap < 1) {
            cap = 10000;
        }
        this.cap = cap;
        this.futArray = new AtomicReferenceArray(cap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FastFutureStore getInstance(int cap) {
        if (null != singletonInstance) return singletonInstance;
        Class<FastFutureStore> clazz = FastFutureStore.class;
        synchronized (FastFutureStore.class) {
            if (null != singletonInstance) return singletonInstance;
            singletonInstance = new FastFutureStore(cap);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singletonInstance;
        }
    }

    public long put(RpcFuture fut) {
        long currentCounter;
        int loopCount = 0;
        while (true) {
            if ((currentCounter = this.slotCounter.getAndIncrement()) >= COUNTER_VALUE_BOUNDARY) {
                this.slotCounter.getAndSet(0L);
                continue;
            }
            int slot = this.mapSlot(currentCounter);
            boolean success = this.futArray.compareAndSet(slot, null, fut);
            if (success) {
                fut.setCorrelationId(currentCounter);
                return currentCounter;
            }
            if (++loopCount >= this.cap) break;
        }
        LOG.debug("FutureStore exhausted, current=%d, store id in map", (Object)this.cap);
        return this.storeInMap(currentCounter, fut);
    }

    public RpcFuture get(long id) {
        if (this.isStoredInMap(id)) {
            return this.getFromMap(id);
        }
        return this.getFromArray(id);
    }

    public RpcFuture getAndRemove(long id) {
        if (this.isStoredInMap(id)) {
            return this.getAndRemoveMap(id);
        }
        return this.getAndRemoveArray(id);
    }

    public int size() {
        int sum = 0;
        for (int ix = 0; ix < this.cap; ++ix) {
            if (null == this.futArray.get(ix)) continue;
            ++sum;
        }
        return sum + this.backupMap.size();
    }

    public void traverse(StoreWalker walker) {
        boolean keep;
        if (null == walker) {
            throw new NullPointerException("walker cannot be null");
        }
        if (!this.hasElements()) {
            return;
        }
        for (int ix = 0; ix < this.cap; ++ix) {
            RpcFuture fut = this.futArray.get(ix);
            if (null == fut || (keep = walker.visitElement(fut))) continue;
            this.futArray.set(ix, null);
            walker.actionAfterDelete(fut);
        }
        for (Map.Entry<Long, RpcFuture> pair : this.backupMap.entrySet()) {
            keep = walker.visitElement(pair.getValue());
            if (keep) continue;
            this.backupMap.remove(pair.getKey());
            walker.actionAfterDelete(pair.getValue());
        }
    }

    private RpcFuture getAndRemoveMap(long id) {
        return this.backupMap.remove(id);
    }

    private RpcFuture getAndRemoveArray(long id) {
        int slot = this.mapSlot(id);
        if (!this.rangeCheck(slot)) {
            return null;
        }
        RpcFuture prev = this.futArray.get(slot);
        if (null != prev && prev.getCorrelationId() == id) {
            this.futArray.set(slot, null);
            return prev;
        }
        return null;
    }

    private RpcFuture getFromMap(long id) {
        return this.backupMap.get(id);
    }

    private RpcFuture getFromArray(long id) {
        int slot = this.mapSlot(id);
        if (!this.rangeCheck(slot)) {
            return null;
        }
        return this.futArray.get(slot);
    }

    private long storeInMap(long id, RpcFuture fut) {
        long mapId = this.markMapBit(id);
        this.backupMap.put(mapId, fut);
        return mapId;
    }

    private long markMapBit(long id) {
        return id | COUNTER_VALUE_BOUNDARY;
    }

    private boolean isStoredInMap(long id) {
        return id >= COUNTER_VALUE_BOUNDARY;
    }

    private boolean hasElements() {
        boolean arrayNotEmpty = false;
        for (int ix = 0; ix < this.cap; ++ix) {
            if (null == this.futArray.get(ix)) continue;
            arrayNotEmpty = true;
            break;
        }
        boolean mapNotEmpty = !this.backupMap.isEmpty();
        return arrayNotEmpty || mapNotEmpty;
    }

    private int mapSlot(long id) {
        return (int)(id % (long)this.cap);
    }

    private boolean rangeCheck(int index) {
        return index < this.cap && index >= 0;
    }

    static {
        COUNTER_VALUE_BOUNDARY = 0x4000000000000000L;
    }

    public static interface StoreWalker {
        public boolean visitElement(RpcFuture var1);

        public void actionAfterDelete(RpcFuture var1);
    }
}

