/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client;

import com.baidu.brpc.ChannelInfo;
import com.baidu.brpc.client.AsyncAwareFuture;
import com.baidu.brpc.client.BrpcProxy;
import com.baidu.brpc.client.FastFutureStore;
import com.baidu.brpc.client.RpcClientOptions;
import com.baidu.brpc.client.RpcFuture;
import com.baidu.brpc.client.RpcTimeoutTimer;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.client.channel.ChannelType;
import com.baidu.brpc.client.handler.IdleChannelHandler;
import com.baidu.brpc.client.handler.RpcClientHandler;
import com.baidu.brpc.client.instance.BasicInstanceProcessor;
import com.baidu.brpc.client.instance.Endpoint;
import com.baidu.brpc.client.instance.EnhancedInstanceProcessor;
import com.baidu.brpc.client.instance.InstanceProcessor;
import com.baidu.brpc.client.instance.ServiceInstance;
import com.baidu.brpc.client.loadbalance.LoadBalanceManager;
import com.baidu.brpc.client.loadbalance.LoadBalanceStrategy;
import com.baidu.brpc.client.loadbalance.RandomStrategy;
import com.baidu.brpc.exceptions.RpcException;
import com.baidu.brpc.interceptor.ClientTraceInterceptor;
import com.baidu.brpc.interceptor.Interceptor;
import com.baidu.brpc.interceptor.LoadBalanceInterceptor;
import com.baidu.brpc.naming.BrpcURL;
import com.baidu.brpc.naming.ListNamingService;
import com.baidu.brpc.naming.NamingOptions;
import com.baidu.brpc.naming.NamingService;
import com.baidu.brpc.naming.NamingServiceFactory;
import com.baidu.brpc.naming.NamingServiceFactoryManager;
import com.baidu.brpc.naming.NotifyListener;
import com.baidu.brpc.naming.SubscribeInfo;
import com.baidu.brpc.protocol.Protocol;
import com.baidu.brpc.protocol.ProtocolManager;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.server.ServiceManager;
import com.baidu.brpc.spi.ExtensionLoaderManager;
import com.baidu.brpc.thread.BrpcIoThreadPoolInstance;
import com.baidu.brpc.thread.BrpcWorkClientThreadPoolInstance;
import com.baidu.brpc.thread.ClientCallBackThreadPoolInstance;
import com.baidu.brpc.thread.ClientTimeoutTimerInstance;
import com.baidu.brpc.thread.ShutDownManager;
import com.baidu.brpc.utils.BrpcConstants;
import com.baidu.brpc.utils.CustomThreadFactory;
import com.baidu.brpc.utils.ThreadPool;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(RpcClient.class);
    private RpcClientOptions rpcClientOptions = new RpcClientOptions();
    private Bootstrap bootstrap;
    private Timer timeoutTimer;
    private Protocol protocol;
    private LoadBalanceStrategy loadBalanceStrategy;
    private List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private LoadBalanceInterceptor loadBalanceInterceptor = new LoadBalanceInterceptor();
    private NamingService namingService;
    private ThreadPool workThreadPool;
    private EventLoopGroup ioThreadPool;
    private Class serviceInterface;
    private SubscribeInfo subscribeInfo;
    private AtomicBoolean stop = new AtomicBoolean(false);
    private InstanceProcessor instanceProcessor;
    private ExecutorService callbackThread;
    private FastFutureStore fastFutureStore;

    public void registerPushService(Object service) {
        ServiceManager.getInstance().registerPushService(service);
        if (this.instanceProcessor.getInstances().size() == 0) {
            LOG.error("there should be have normal servcies before register push service.");
            throw new RpcException("there should be have normal services before register push service");
        }
    }

    public RpcClient(String namingServiceUrl) {
        this(namingServiceUrl, new RpcClientOptions(), null);
    }

    public RpcClient(String namingServiceUrl, RpcClientOptions options) {
        this(namingServiceUrl, options, null);
    }

    public RpcClient(String serviceUrl, RpcClientOptions options, List<Interceptor> interceptors) {
        Validate.notEmpty((CharSequence)serviceUrl);
        Validate.notNull((Object)options);
        ExtensionLoaderManager.getInstance().loadAllExtensions(options.getEncoding());
        BrpcURL url = new BrpcURL(serviceUrl);
        NamingServiceFactory namingServiceFactory = NamingServiceFactoryManager.getInstance().getNamingServiceFactory(url.getSchema());
        this.namingService = namingServiceFactory.createNamingService(url);
        boolean singleServer = false;
        if (this.namingService instanceof ListNamingService) {
            List<ServiceInstance> instances = this.namingService.lookup(null);
            singleServer = instances.size() == 1;
        }
        this.init(options, interceptors, singleServer);
    }

    public RpcClient(Endpoint endPoint) {
        this(endPoint, null);
    }

    public RpcClient(Endpoint endPoint, RpcClientOptions options) {
        this(endPoint, options, null);
    }

    public RpcClient(Endpoint endPoint, RpcClientOptions options, List<Interceptor> interceptors) {
        if (null == options) {
            options = new RpcClientOptions();
        }
        ExtensionLoaderManager.getInstance().loadAllExtensions(options.getEncoding());
        this.init(options, interceptors, true);
        this.instanceProcessor.addInstance(new ServiceInstance(endPoint));
    }

    public RpcClient(List<Endpoint> endPoints) {
        this(endPoints, new RpcClientOptions(), null);
    }

    public RpcClient(List<Endpoint> endPoints, RpcClientOptions options, List<Interceptor> interceptors) {
        ExtensionLoaderManager.getInstance().loadAllExtensions(options.getEncoding());
        this.init(options, interceptors, endPoints.size() == 1);
        for (Endpoint endpoint : endPoints) {
            this.instanceProcessor.addInstance(new ServiceInstance(endpoint));
        }
    }

    public static <T> T getProxy(RpcClient rpcClient, Class clazz, NamingOptions namingOptions) {
        return BrpcProxy.getProxy(rpcClient, clazz, namingOptions);
    }

    public static <T> T getProxy(RpcClient rpcClient, Class clazz) {
        return BrpcProxy.getProxy(rpcClient, clazz, null);
    }

    public <T> T getProxy(Class clazz, NamingOptions namingOptions) {
        return BrpcProxy.getProxy(this, clazz, namingOptions);
    }

    public <T> T getProxy(Class clazz) {
        return BrpcProxy.getProxy(this, clazz, null);
    }

    public void setServiceInterface(Class clazz) {
        this.setServiceInterface(clazz, null);
    }

    public void setServiceInterface(Class clazz, NamingOptions namingOptions) {
        if (this.serviceInterface != null) {
            throw new RpcException("serviceInterface must not be set repeatedly, please use another RpcClient");
        }
        this.serviceInterface = clazz.getInterfaces().length == 0 ? clazz : clazz.getInterfaces()[0];
        if (this.namingService != null) {
            this.subscribeInfo = namingOptions != null ? new SubscribeInfo(namingOptions) : new SubscribeInfo();
            this.subscribeInfo.setInterfaceName(this.serviceInterface.getName());
            List<ServiceInstance> instances = this.namingService.lookup(this.subscribeInfo);
            this.instanceProcessor.addInstances(instances);
            this.namingService.subscribe(this.subscribeInfo, new NotifyListener(){

                @Override
                public void notify(Collection<ServiceInstance> addList, Collection<ServiceInstance> deleteList) {
                    RpcClient.this.instanceProcessor.addInstances(addList);
                    RpcClient.this.instanceProcessor.deleteInstances(deleteList);
                }
            });
        }
    }

    public void shutdown() {
        this.stop();
    }

    public void stop() {
        if (this.stop.compareAndSet(false, true)) {
            if (this.namingService != null) {
                this.namingService.unsubscribe(this.subscribeInfo);
            }
            if (this.instanceProcessor != null) {
                this.instanceProcessor.stop();
            }
            if (this.loadBalanceStrategy != null) {
                this.loadBalanceStrategy.destroy();
            }
            if (this.ioThreadPool != null && !this.rpcClientOptions.isGlobalThreadPoolSharing()) {
                this.ioThreadPool.shutdownGracefully().syncUninterruptibly();
            }
            if (this.workThreadPool != null && !this.rpcClientOptions.isGlobalThreadPoolSharing()) {
                this.workThreadPool.stop();
            }
        }
    }

    public boolean isShutdown() {
        return this.stop.get();
    }

    public Channel selectChannel(Request request) {
        Channel channel;
        BrpcChannel brpcChannel = this.loadBalanceStrategy.selectInstance(request, this.instanceProcessor.getHealthyInstanceChannels(), request.getSelectedInstances());
        if (brpcChannel == null) {
            LOG.debug("no available healthy server, so random select one unhealthy server");
            RandomStrategy randomStrategy = new RandomStrategy();
            randomStrategy.init(this);
            brpcChannel = randomStrategy.selectInstance(request, this.instanceProcessor.getUnHealthyInstanceChannels(), request.getSelectedInstances());
            if (brpcChannel == null) {
                throw new RpcException(1, "no available instance");
            }
        }
        try {
            channel = brpcChannel.getChannel();
        }
        catch (NoSuchElementException full) {
            int maxConnections = brpcChannel.getCurrentMaxConnection() * 2;
            brpcChannel.updateMaxConnection(maxConnections);
            String errMsg = String.format("channel pool is exhausted, and double maxTotalConnection,server=%s:%d", brpcChannel.getServiceInstance().getIp(), brpcChannel.getServiceInstance().getPort());
            LOG.debug(errMsg);
            throw new RpcException(1, errMsg, full);
        }
        catch (IllegalStateException illegalState) {
            String errMsg = String.format("channel pool is closed, server=%s:%d", brpcChannel.getServiceInstance().getIp(), brpcChannel.getServiceInstance().getPort());
            LOG.debug(errMsg);
            throw new RpcException(0, errMsg, illegalState);
        }
        catch (Exception connectedFailed) {
            String errMsg = String.format("channel pool make new object failed, active=%d,idle=%d,server=%s:%d, ex=%s", brpcChannel.getActiveConnectionNum(), brpcChannel.getIdleConnectionNum(), brpcChannel.getServiceInstance().getIp(), brpcChannel.getServiceInstance().getPort(), connectedFailed.getMessage());
            LOG.debug(errMsg);
            throw new RpcException(0, errMsg, connectedFailed);
        }
        if (channel == null) {
            String errMsg = "channel is null, retry another channel";
            LOG.debug(errMsg);
            throw new RpcException(0, errMsg);
        }
        if (!channel.isActive()) {
            brpcChannel.incFailedNum();
            brpcChannel.removeChannel(channel);
            String errMsg = "channel is non active, retry another channel";
            throw new RpcException(1, errMsg);
        }
        return channel;
    }

    public Channel selectChannel(Endpoint endpoint) {
        Channel channel;
        BrpcChannel brpcChannel = (BrpcChannel)this.instanceProcessor.getInstanceChannelMap().get(endpoint);
        if (brpcChannel == null) {
            LOG.warn("instance:{} not found, may be it is removed from naming service.", (Object)endpoint);
            throw new RpcException(3, "instance not found:" + endpoint);
        }
        try {
            channel = brpcChannel.getChannel();
        }
        catch (Exception ex) {
            throw new RpcException(1, "select channel failed from " + endpoint, ex);
        }
        if (!channel.isActive()) {
            brpcChannel.incFailedNum();
            brpcChannel.removeChannel(channel);
            String errMsg = "channel is non active, retry another channel";
            throw new RpcException(1, errMsg);
        }
        return channel;
    }

    public void returnChannel(Channel channel) {
        ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(channel);
        channelInfo.getChannelGroup().returnChannel(channel);
    }

    public void removeChannel(Channel channel) {
        ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(channel);
        channelInfo.getChannelGroup().removeChannel(channel);
    }

    public <T> AsyncAwareFuture<T> sendRequest(Request request) {
        Channel channel = request.getChannel();
        ChannelInfo channelInfo = ChannelInfo.getClientChannelInfo(channel);
        BrpcChannel brpcChannel = channelInfo.getChannelGroup();
        this.protocol.beforeRequestSent(request, this, brpcChannel);
        RpcFuture rpcFuture = new RpcFuture();
        rpcFuture.setRpcMethodInfo(request.getRpcMethodInfo());
        rpcFuture.setCallback(request.getCallback());
        rpcFuture.setRpcClient(this);
        rpcFuture.setChannelInfo(channelInfo);
        long correlationId = FastFutureStore.getInstance(0).put(rpcFuture);
        request.setCorrelationId(correlationId);
        channelInfo.setCorrelationId(rpcFuture.getCorrelationId());
        long readTimeout = request.getReadTimeoutMillis().intValue();
        long writeTimeout = request.getWriteTimeoutMillis().intValue();
        RpcTimeoutTimer timeoutTask = new RpcTimeoutTimer(channelInfo, request.getCorrelationId(), this);
        Timeout timeout = this.timeoutTimer.newTimeout((TimerTask)timeoutTask, readTimeout, TimeUnit.MILLISECONDS);
        rpcFuture.setTimeout(timeout);
        try {
            request.retain();
            ByteBuf byteBuf = this.protocol.encodeRequest(request);
            ChannelFuture sendFuture = channel.writeAndFlush((Object)byteBuf);
            sendFuture.awaitUninterruptibly(writeTimeout);
            if (!sendFuture.isSuccess()) {
                if (!(sendFuture.cause() instanceof ClosedChannelException)) {
                    LOG.warn("send request failed, channelActive={}, ex=", (Object)channel.isActive(), (Object)sendFuture.cause());
                }
                String errMsg = String.format("send request failed, channelActive=%b, ex=%s", channel.isActive(), sendFuture.cause().getMessage());
                throw new RpcException(1, errMsg);
            }
        }
        catch (Exception ex) {
            channelInfo.handleRequestFail(this.rpcClientOptions.getChannelType());
            timeout.cancel();
            if (ex instanceof RpcException) {
                throw (RpcException)ex;
            }
            throw new RpcException(5, ex.getMessage(), ex);
        }
        channelInfo.handleRequestSuccess();
        return rpcFuture;
    }

    public void triggerCallback(Runnable runnable) {
        if (!this.callbackThread.isTerminated()) {
            this.callbackThread.execute(runnable);
        }
    }

    private void init(RpcClientOptions options, List<Interceptor> interceptors, boolean singleServer) {
        Validate.notNull((Object)options);
        try {
            this.rpcClientOptions.copyFrom(options);
        }
        catch (Exception ex) {
            LOG.warn("init rpc options failed, so use default");
        }
        if (interceptors != null) {
            this.interceptors.addAll(interceptors);
        }
        this.interceptors.add(new ClientTraceInterceptor());
        this.protocol = ProtocolManager.getInstance().getProtocol(options.getProtocolType());
        this.fastFutureStore = FastFutureStore.getInstance(options.getFutureBufferSize());
        this.timeoutTimer = ClientTimeoutTimerInstance.getOrCreateInstance();
        this.instanceProcessor = singleServer || this.rpcClientOptions.getChannelType() == ChannelType.SHORT_CONNECTION ? new BasicInstanceProcessor(this) : new EnhancedInstanceProcessor(this);
        this.loadBalanceStrategy = LoadBalanceManager.getInstance().createLoadBalance(this.rpcClientOptions.getLoadBalanceType());
        this.loadBalanceStrategy.init(this);
        ShutDownManager.getInstance();
        boolean threadPoolSharing = this.rpcClientOptions.isGlobalThreadPoolSharing();
        if (threadPoolSharing) {
            this.workThreadPool = BrpcWorkClientThreadPoolInstance.getOrCreateInstance(this.rpcClientOptions.getWorkThreadNum());
            this.ioThreadPool = this.rpcClientOptions.getIoEventType() == BrpcConstants.IO_EVENT_NETTY_EPOLL ? BrpcIoThreadPoolInstance.getOrCreateEpollInstance(options.getIoThreadNum()) : BrpcIoThreadPoolInstance.getOrCreateNioInstance(options.getIoThreadNum());
        } else {
            this.workThreadPool = new ThreadPool(this.rpcClientOptions.getWorkThreadNum(), new CustomThreadFactory("client-work-thread"));
            this.ioThreadPool = this.rpcClientOptions.getIoEventType() == BrpcConstants.IO_EVENT_NETTY_EPOLL ? new EpollEventLoopGroup(options.getIoThreadNum(), (ThreadFactory)new CustomThreadFactory("client-io-thread")) : new NioEventLoopGroup(options.getIoThreadNum(), (ThreadFactory)new CustomThreadFactory("client-io-thread"));
        }
        this.callbackThread = ClientCallBackThreadPoolInstance.getOrCreateInstance(1);
        this.bootstrap = new Bootstrap();
        if (this.rpcClientOptions.getIoEventType() == BrpcConstants.IO_EVENT_NETTY_EPOLL) {
            this.bootstrap.channel(EpollSocketChannel.class);
            this.bootstrap.option(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED);
        } else {
            this.bootstrap.channel(NioSocketChannel.class);
        }
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.rpcClientOptions.getConnectTimeoutMillis());
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.rpcClientOptions.isKeepAlive());
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.rpcClientOptions.isReuseAddr());
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.rpcClientOptions.isTcpNoDelay());
        this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.rpcClientOptions.getReceiveBufferSize());
        this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.rpcClientOptions.getSendBufferSize());
        final RpcClientHandler rpcClientHandler = new RpcClientHandler(this);
        ChannelInitializer<SocketChannel> initializer = new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                if (RpcClient.this.rpcClientOptions.getChannelType() == ChannelType.SINGLE_CONNECTION) {
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0, 0, RpcClient.this.rpcClientOptions.getKeepAliveTime())});
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleChannelHandler()});
                }
                ch.pipeline().addLast(new ChannelHandler[]{rpcClientHandler});
            }
        };
        ((Bootstrap)this.bootstrap.group(this.ioThreadPool)).handler((ChannelHandler)initializer);
    }

    public void removeLogId(long id) {
        this.fastFutureStore.getAndRemove(id);
    }

    public RpcClientOptions getRpcClientOptions() {
        return this.rpcClientOptions;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public CopyOnWriteArrayList<BrpcChannel> getHealthyInstances() {
        return this.instanceProcessor.getHealthyInstanceChannels();
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public ThreadPool getWorkThreadPool() {
        return this.workThreadPool;
    }

    public LoadBalanceStrategy getLoadBalanceStrategy() {
        return this.loadBalanceStrategy;
    }

    public boolean isLongConnection() {
        return this.rpcClientOptions.getChannelType() != ChannelType.SHORT_CONNECTION;
    }

    public NamingService getNamingService() {
        return this.namingService;
    }

    public Timer getTimeoutTimer() {
        return this.timeoutTimer;
    }

    public LoadBalanceInterceptor getLoadBalanceInterceptor() {
        return this.loadBalanceInterceptor;
    }

    public void setLoadBalanceInterceptor(LoadBalanceInterceptor loadBalanceInterceptor) {
        this.loadBalanceInterceptor = loadBalanceInterceptor;
    }

    public SubscribeInfo getSubscribeInfo() {
        return this.subscribeInfo;
    }

    public InstanceProcessor getInstanceProcessor() {
        return this.instanceProcessor;
    }

    public void setInstanceProcessor(InstanceProcessor instanceProcessor) {
        this.instanceProcessor = instanceProcessor;
    }

    public EventLoopGroup getIoThreadPool() {
        return this.ioThreadPool;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public AtomicBoolean getStop() {
        return this.stop;
    }

    public ExecutorService getCallbackThread() {
        return this.callbackThread;
    }

    public FastFutureStore getFastFutureStore() {
        return this.fastFutureStore;
    }
}

