/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.loadbalance;

import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.client.loadbalance.LoadBalanceStrategy;
import com.baidu.brpc.protocol.Request;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class WeightStrategy
implements LoadBalanceStrategy {
    private Random random = new Random(System.currentTimeMillis());

    @Override
    public void init(RpcClient rpcClient) {
    }

    @Override
    public BrpcChannel selectInstance(Request request, List<BrpcChannel> instances, Set<BrpcChannel> selectedInstances) {
        long instanceNum = instances.size();
        if (instanceNum == 0L) {
            return null;
        }
        long sum = 0L;
        for (BrpcChannel instance : instances) {
            sum += this.getWeight(instance.getFailedNum());
        }
        long randWeight = this.random.nextLong() % sum;
        for (BrpcChannel channelGroup : instances) {
            if ((randWeight -= this.getWeight(channelGroup.getFailedNum())) > 0L) continue;
            return channelGroup;
        }
        return null;
    }

    @Override
    public void destroy() {
    }

    private long getWeight(long failedNum) {
        return 1000000000L / (failedNum + 1L);
    }
}

