/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.protocol.stargate;

import com.baidu.brpc.protocol.stargate.StargateConstants;
import com.baidu.brpc.protocol.stargate.StargateUtils;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class StargateURI {
    private final String protocol;
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final String path;
    private final Map<String, String> parameters;
    private final Map<String, Number> numbers = new ConcurrentHashMap<String, Number>();
    private final transient String ip;
    private final transient String fullString;
    private final transient String identityString;
    private final transient String parameterString;
    private final transient String string;

    public StargateURI(Builder builder) {
        this(builder.protocol, builder.username, builder.password, builder.host, builder.port, builder.path, builder.parameters);
    }

    public StargateURI(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters) {
        if ((username == null || username.length() == 0) && password != null && password.length() > 0) {
            throw new IllegalArgumentException("Invalid uri, password without username!");
        }
        this.protocol = protocol;
        this.username = username;
        this.password = password;
        this.host = host;
        int n = this.port = port < 0 ? 0 : port;
        while (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path;
        parameters = parameters == null ? new HashMap<String, String>() : new HashMap<String, String>(parameters);
        this.parameters = Collections.unmodifiableMap(parameters);
        this.parameterString = this.buildParameters();
        this.identityString = this.buildString(true);
        this.fullString = this.identityString + (this.parameterString.length() > 0 ? '?' + this.parameterString : "");
        this.string = this.buildString(false) + (this.parameterString.length() > 0 ? '?' + this.parameterString : "");
        this.ip = StargateUtils.getIpByHost(host);
    }

    public static StargateURI valueOf(String uri) {
        if (uri == null || (uri = uri.trim()).length() == 0) {
            throw new IllegalArgumentException("uri == null");
        }
        String protocol = null;
        String username = null;
        String password = null;
        String host = null;
        int port = 0;
        String path = null;
        HashMap<String, String> parameters = null;
        int i = uri.indexOf("?");
        if (i >= 0) {
            String[] parts = uri.substring(i + 1).split("\\&");
            parameters = new HashMap<String, String>();
            for (String part : parts) {
                if ((part = part.trim()).length() <= 0) continue;
                int j = part.indexOf(61);
                if (j >= 0) {
                    parameters.put(part.substring(0, j), part.substring(j + 1));
                    continue;
                }
                parameters.put(part, part);
            }
            uri = uri.substring(0, i);
        }
        if ((i = uri.indexOf("://")) >= 0) {
            if (i == 0) {
                throw new IllegalStateException("uri missing protocol: \"" + uri + "\"");
            }
            protocol = uri.substring(0, i);
            uri = uri.substring(i + 3);
        } else {
            i = uri.indexOf(":/");
            if (i >= 0) {
                if (i == 0) {
                    throw new IllegalStateException("uri missing protocol: \"" + uri + "\"");
                }
                protocol = uri.substring(0, i);
                uri = uri.substring(i + 1);
            }
        }
        i = uri.indexOf("/");
        if (i >= 0) {
            path = uri.substring(i + 1);
            uri = uri.substring(0, i);
        }
        if ((i = uri.indexOf("@")) >= 0) {
            username = uri.substring(0, i);
            int j = username.indexOf(":");
            if (j >= 0) {
                password = username.substring(j + 1);
                username = username.substring(0, j);
            }
            uri = uri.substring(i + 1);
        }
        if ((i = uri.indexOf(":")) >= 0 && i < uri.length() - 1) {
            port = Integer.parseInt(uri.substring(i + 1));
            uri = uri.substring(0, i);
        }
        if (uri.length() > 0) {
            host = uri;
        }
        return new StargateURI(protocol, username, password, host, port, path, parameters);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getAddress() {
        return this.port <= 0 ? this.host : this.host + ":" + this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsolutePath() {
        if (this.path != null && !this.path.startsWith("/")) {
            return "/" + this.path;
        }
        return this.path;
    }

    public StargateURI resetPath(String path) {
        return new StargateURI(this.protocol, this.username, this.password, this.host, this.port, path, this.getParameters());
    }

    public StargateURI resetHost(String host) {
        return new StargateURI(this.protocol, this.username, this.password, host, this.port, this.path, this.getParameters());
    }

    public StargateURI resetPort(int port) {
        return new StargateURI(this.protocol, this.username, this.password, this.host, port, this.path, this.getParameters());
    }

    public StargateURI resetProtocol(String protocol) {
        return new StargateURI(protocol, this.username, this.password, this.host, this.port, this.path, this.getParameters());
    }

    public StargateURI resetUsername(String username) {
        return new StargateURI(this.protocol, username, this.password, this.host, this.port, this.path, this.getParameters());
    }

    public StargateURI resetPassword(String password) {
        return new StargateURI(this.protocol, this.username, password, this.host, this.port, this.path, this.getParameters());
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getParameterAndDecoded(String key) {
        return this.getParameterAndDecoded(key, null);
    }

    public String getParameterAndDecoded(String key, String defaultValue) {
        return StargateURI.decode(this.getParameter(key, defaultValue));
    }

    public String getParameter(String key) {
        String value = this.parameters.get(key);
        if (value == null || value.length() == 0) {
            value = this.parameters.get("default." + key);
        }
        return value;
    }

    public String getParameter(String key, String defaultValue) {
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public String[] getParameter(String key, String[] defaultValue) {
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return StargateConstants.COMMA_SPLIT_PATTERN.split(value);
    }

    public double getParameter(String key, double defaultValue) {
        Number n = this.numbers.get(key);
        if (n != null) {
            return n.doubleValue();
        }
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.numbers.put(key, d);
        return d;
    }

    public long getParameter(String key, long defaultValue) {
        Number n = this.numbers.get(key);
        if (n != null) {
            return n.longValue();
        }
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.numbers.put(key, l);
        return l;
    }

    public int getParameter(String key, int defaultValue) {
        Number n = this.numbers.get(key);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.numbers.put(key, i);
        return i;
    }

    public boolean getParameter(String key, boolean defaultValue) {
        String value = this.getParameter(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public double getPositiveParameter(String key, double defaultValue) {
        if (defaultValue <= 0.0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        double value = this.getParameter(key, defaultValue);
        if (value <= 0.0) {
            return defaultValue;
        }
        return value;
    }

    public long getPositiveParameter(String key, long defaultValue) {
        if (defaultValue <= 0L) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        long value = this.getParameter(key, defaultValue);
        if (value <= 0L) {
            return defaultValue;
        }
        return value;
    }

    public int getPositiveParameter(String key, int defaultValue) {
        if (defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        int value = this.getParameter(key, defaultValue);
        if (value <= 0) {
            return defaultValue;
        }
        return value;
    }

    public boolean hasParameter(String key) {
        String value = this.getParameter(key);
        return value != null && value.length() > 0;
    }

    public String getMethodParameterAndDecoded(String method, String key) {
        return StargateURI.decode(this.getMethodParameter(method, key));
    }

    public String getMethodParameterAndDecoded(String method, String key, String defaultValue) {
        return StargateURI.decode(this.getMethodParameter(method, key, defaultValue));
    }

    public String getMethodParameter(String method, String key) {
        String value = this.parameters.get(method + "." + key);
        if (value == null || value.length() == 0) {
            return this.getParameter(key);
        }
        return value;
    }

    public String getMethodParameter(String method, String key, String defaultValue) {
        String value = this.getMethodParameter(method, key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public double getMethodParameter(String method, String key, double defaultValue) {
        String methodKey = method + "." + key;
        Number n = this.numbers.get(methodKey);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getMethodParameter(method, key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        double d = Double.parseDouble(value);
        this.numbers.put(methodKey, d);
        return d;
    }

    public long getMethodParameter(String method, String key, long defaultValue) {
        String methodKey = method + "." + key;
        Number n = this.numbers.get(methodKey);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getMethodParameter(method, key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        long l = Long.parseLong(value);
        this.numbers.put(methodKey, l);
        return l;
    }

    public int getMethodParameter(String method, String key, int defaultValue) {
        String methodKey = method + "." + key;
        Number n = this.numbers.get(methodKey);
        if (n != null) {
            return n.intValue();
        }
        String value = this.getMethodParameter(method, key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        int i = Integer.parseInt(value);
        this.numbers.put(methodKey, i);
        return i;
    }

    public boolean getMethodParameter(String method, String key, boolean defaultValue) {
        String value = this.getMethodParameter(method, key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public boolean hasMethodParameter(String method, String key) {
        if (method == null) {
            String suffix = "." + key;
            for (String fullKey : this.parameters.keySet()) {
                if (!fullKey.endsWith(suffix)) continue;
                return true;
            }
            return false;
        }
        if (key == null) {
            String prefix = method + ".";
            for (String fullKey : this.parameters.keySet()) {
                if (!fullKey.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        String value = this.getMethodParameter(method, key);
        return value != null && value.length() > 0;
    }

    public StargateURI addParameters(Map<String, String> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.putAll(parameters);
        return new StargateURI(this.protocol, this.username, this.password, this.host, this.port, this.path, map);
    }

    public StargateURI addParameters(String ... pairs) {
        return this.addParameters(StargateUtils.toStringMap(pairs));
    }

    public StargateURI addParameterString(String query) {
        if (query == null || query.length() == 0) {
            return this;
        }
        return this.addParameters(StargateUtils.parseQueryString(query));
    }

    public StargateURI addParametersIfAbsent(Map<String, String> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(parameters);
        map.putAll(this.getParameters());
        return new StargateURI(this.protocol, this.username, this.password, this.host, this.port, this.path, map);
    }

    public StargateURI removeParameter(String key) {
        if (key == null || key.length() == 0) {
            return this;
        }
        return this.removeParameters(key);
    }

    public StargateURI removeParameters(Collection<String> keys) {
        if (keys == null || keys.size() == 0) {
            return this;
        }
        return this.removeParameters(keys.toArray(new String[0]));
    }

    public StargateURI removeParameters(String ... keys) {
        if (keys == null || keys.length == 0) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        for (String key : keys) {
            map.remove(key);
        }
        if (map.size() == this.getParameters().size()) {
            return this;
        }
        return new StargateURI(this.protocol, this.username, this.password, this.host, this.port, this.path, map);
    }

    public StargateURI clearParameters() {
        return new StargateURI(this.protocol, this.username, this.password, this.host, this.port, this.path, new HashMap<String, String>());
    }

    public String toString() {
        return this.string;
    }

    public String toIdentityString() {
        return this.identityString;
    }

    public String toFullString() {
        return this.fullString;
    }

    public String toParameterString() {
        return this.parameterString;
    }

    private String buildParameters() {
        StringBuilder buf = new StringBuilder();
        if (this.getParameters() != null && this.getParameters().size() > 0) {
            boolean first = true;
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.getParameters()).entrySet()) {
                if (entry.getKey() == null || entry.getKey().length() <= 0) continue;
                if (first) {
                    first = false;
                } else {
                    buf.append("&");
                }
                buf.append(entry.getKey());
                buf.append("=");
                buf.append(entry.getValue() == null ? "" : entry.getValue().trim());
            }
        }
        return buf.toString();
    }

    private String buildString(boolean u) {
        StringBuilder buf = new StringBuilder();
        if (this.protocol != null && this.protocol.length() > 0) {
            buf.append(this.protocol);
            buf.append("://");
        }
        if (u && this.username != null && this.username.length() > 0) {
            buf.append(this.username);
            if (this.password != null && this.password.length() > 0) {
                buf.append(":");
                buf.append(this.password);
            }
            buf.append("@");
        }
        if (this.host != null && this.host.length() > 0) {
            buf.append(this.host);
            if (this.port > 0) {
                buf.append(":");
                buf.append(this.port);
            }
        }
        if (this.path != null && this.path.length() > 0) {
            buf.append("/");
            buf.append(this.path);
        }
        return buf.toString();
    }

    public URL toJavaURL() {
        try {
            return new URL(this.toFullString());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String getServiceKey() {
        String inf = this.getServiceName();
        if (inf == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String group = this.getParameter("group");
        if (group != null && group.length() > 0) {
            buf.append(group).append(":");
        }
        buf.append(inf);
        String version = this.getParameter("version");
        if (version != null && version.length() > 0) {
            buf.append(":").append(version);
        }
        return buf.toString();
    }

    public String getSimpleServiceKey() {
        String inf = this.getServiceName(true);
        if (inf == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String group = this.getParameter("group");
        if (group != null && group.length() > 0) {
            buf.append(group).append(":");
        }
        buf.append(inf);
        String version = this.getParameter("version");
        if (version != null && version.length() > 0) {
            buf.append(":").append(version);
        }
        return buf.toString();
    }

    public String getServiceName() {
        return this.getServiceName(false);
    }

    public String getServiceName(boolean simple) {
        String xx = this.getParameter("interface.simple", this.path);
        return simple ? xx : this.getParameter("interface", this.path);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StargateURI other = (StargateURI)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.protocol == null) {
            return other.protocol == null;
        }
        return this.protocol.equals(other.protocol);
    }

    public static String encode(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String decode(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static class Builder {
        private final String protocol;
        private final String host;
        private final int port;
        private String username;
        private String password;
        private String path;
        private Map<String, String> parameters = new HashMap<String, String>();

        public Builder(String protocol, String host, int port) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
        }

        public Builder(StargateURI uri) {
            this.protocol = uri.getProtocol();
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.username = uri.getUsername();
            this.password = uri.getPassword();
            this.path = uri.getPath();
            this.parameters.putAll(uri.getParameters());
        }

        public Builder(String uri) {
            this(StargateURI.valueOf(uri));
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder params(String ... pairs) {
            this.parameters.putAll(StargateUtils.toStringMap(pairs));
            return this;
        }

        public Builder params(Map<String, String> parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        public Builder paramString(String query) {
            if (query == null || query.length() == 0) {
                return this;
            }
            return this.params(StargateUtils.parseQueryString(query));
        }

        public Builder paramAndEncoded(String key, String value) {
            if (value == null || value.length() == 0) {
                return this;
            }
            return this.param(key, StargateURI.encode(value));
        }

        public Builder param(String key, String value) {
            if (key == null || key.length() == 0 || value == null || value.length() == 0) {
                return this;
            }
            this.parameters.put(key, value);
            return this;
        }

        public Builder param(String key, boolean value) {
            return this.param(key, String.valueOf(value));
        }

        public Builder param(String key, int value) {
            return this.param(key, String.valueOf(value));
        }

        public Builder param(String key, long value) {
            return this.param(key, String.valueOf(value));
        }

        public Builder param(String key, double value) {
            return this.param(key, String.valueOf(value));
        }

        public Builder param(String key, Enum<?> value) {
            if (value == null) {
                return this;
            }
            return this.param(key, String.valueOf(value));
        }

        public Builder param(String key, Number value) {
            if (value == null) {
                return this;
            }
            return this.param(key, String.valueOf(value));
        }

        public Builder paramIfAbsent(String key, String value) {
            if (key == null || key.length() == 0 || value == null || value.length() == 0) {
                return this;
            }
            String oldValue = this.parameters.get(key);
            if (oldValue == null) {
                oldValue = this.parameters.get("default." + key);
            }
            if (oldValue != null && oldValue.length() > 0) {
                return this;
            }
            this.parameters.put(key, value);
            return this;
        }

        public StargateURI build() {
            return new StargateURI(this);
        }
    }
}

