/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.server.currentlimit;

import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.server.currentlimit.CurrentLimiter;
import com.baidu.brpc.utils.CustomThreadFactory;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterCurrentLimiter
implements CurrentLimiter {
    private static final Logger log = LoggerFactory.getLogger(CounterCurrentLimiter.class);
    private final int timeIntervalMs = 200;
    private final int maxReqPerInterval;
    private AtomicInteger count = new AtomicInteger(0);
    private Timer timer = new HashedWheelTimer((ThreadFactory)new CustomThreadFactory("counterLimiter-timer-thread"));

    public CounterCurrentLimiter(int maxQps) {
        if (maxQps <= 0) {
            throw new IllegalArgumentException("maxQps must be positive!");
        }
        this.maxReqPerInterval = maxQps / 5;
        this.timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) {
                CounterCurrentLimiter.this.count.set(0);
                CounterCurrentLimiter.this.timer.newTimeout((TimerTask)this, 200L, TimeUnit.MILLISECONDS);
            }
        }, 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isAllowable(Request request) {
        return this.count.getAndIncrement() <= this.maxReqPerInterval;
    }
}

